#ifndef THUMBNAILSIZE_H
#define THUMBNAILSIZE_H

class QString;

class ThumbnailSize {

public:

    enum Size { Small, Medium, Large };

    ThumbnailSize(Size val=Large);
    ThumbnailSize(const QString& size);
    ThumbnailSize(const ThumbnailSize& thumbSize);
    ThumbnailSize& operator=(const ThumbnailSize& thumbSize);

    bool operator==(const ThumbnailSize& thumbSize);
    bool operator!=(const ThumbnailSize& thumbSize);

    void setSize(Size val);
    void setSize(const QString& size);

    int getSizeAsNumber() const;
    Size getSize() const { return mSize; }
    double scaleFactor() const;

private:

    Size mSize;

};

#endif
