#include "digikamcameraclient.h"
#include <kapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char *description =
    I18N_NOOP("Digital camera interface for KDE");

static const char *version = "v0.1";

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KLocale::setMainCatalogue("digikam");
    
    KAboutData about ("digikamcameraclient",
                      I18N_NOOP("DigikamCameraClient"),
                      version,
		      description,
		      KAboutData::License_GPL,
                      "(C) 2003 Renchi Raju",
		      0,
		      "http://digikam.sourceforge.net",
		      "renchi@pooh.tam.uiuc.edu");

    about.addAuthor ( "Renchi Raju",
                      I18N_NOOP("coordinator and main developer"),
                      "renchi@pooh.tam.uiuc.edu",
                      "http://digikam.sourceforge.net");

    about.addAuthor ( "Caulier Gilles",
                      I18N_NOOP("Developer, translations coordinator, French translations"),
                      "caulier.gilles@free.fr",
                      "http://caulier.gilles.free.fr");

    about.addCredit ( "Todd Shoemaker",
                      I18N_NOOP("Developer"),
                      "todd@theshoemakers.net",
                      0);

    about.addCredit ( "Gregory Kokanosky",
                      I18N_NOOP("Developer"),
                      "gregory.kokanosky@free.fr",
		      0);

    about.addCredit ( "Rune Laursen",
                      I18N_NOOP("Danish translations"),
                      "runerl@skjoldhoej.dk",
		      0);

    about.addCredit ( "Stefano Rivoir",
                      I18N_NOOP("Italian translations"),
                      "s.rivoir@gts.it",
                      0);

    about.addCredit ( "Jan Toenjes",
                      I18N_NOOP("German translations"),
                      "jan.toenjes@web.de",
                      0);

    about.addCredit ( "Oliver Doerr",
                      I18N_NOOP("German translations and beta tester"),
                      "oliver@doerr-privat.de",
                      0);

    about.addCredit ( "Quique",
                      I18N_NOOP("Spanish translations"),
                      "quique@sindominio.net",
                      0);

    about.addCredit ( "Marcus Meissner",
                      I18N_NOOP("Czech and Hungarian translations"),
                      "marcus@jet.franken.de",
                      0);

    about.addCredit ( "Achim Bohnet",
                      I18N_NOOP("Bugs reports and patchs"),
                      "ach@mpe.mpg.de",
                      0);

    about.addCredit ( "Charles Bouveyron",
                      I18N_NOOP("Beta tester"),
                      "c.bouveyron@tuxfamily.org",
                      0);

    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);

    KApplication app;

    // register ourselves as a dcop client
    app.dcopClient()->registerAs(app.name(), false);

    DigikamCameraClient *client = new DigikamCameraClient;

    return app.exec();

}
