/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2011-09-01
 * Description : a plugin to create photo layouts by fusion of several images.
 * Acknowledge : based on the expoblending plugin
 *
 * Copyright (C) 2011 by Łukasz Spas <lukasz dot spas at gmail dot com>
 * Copyright (C) 2009-2011 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef UNDOCOMMANDEVENT_H
#define UNDOCOMMANDEVENT_H

#include <QEvent>
#include <QUndoCommand>

namespace KIPIPhotoLayoutsEditor
{
    class UndoCommandEvent : public QEvent
    {
            QUndoCommand * m_command;

        public:

            static Type registeredEventType()
            {
                static Type myType = static_cast<QEvent::Type>(QEvent::registerEventType());
                return myType;
            }

            explicit UndoCommandEvent();

            void setUndoCommand(QUndoCommand * command)
            {
                m_command = command;
            }
            QUndoCommand * undoCommand()
            {
                return m_command;
            }

        signals:

        public slots:

    };
}

#endif // UNDOCOMMANDEVENT_H
