/*  -*- C++ -*-
*  Copyright (C) 1998 <developer@mozilla.org>
*
*
*  Permission is hereby granted, free of charge, to any person obtaining
*  a copy of this software and associated documentation files (the
*  "Software"), to deal in the Software without restriction, including
*  without limitation the rights to use, copy, modify, merge, publish,
*  distribute, sublicense, and/or sell copies of the Software, and to
*  permit persons to whom the Software is furnished to do so, subject to
*  the following conditions:
*
*  The above copyright notice and this permission notice shall be included
*  in all copies or substantial portions of the Software.
*
*  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
*  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
*  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
*  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
*  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "nsEscCharsetProber.h"

namespace kencodingprober
{
nsEscCharSetProber::nsEscCharSetProber(void)
{
    mCodingSM[0] = new nsCodingStateMachine(&HZSMModel);
    mCodingSM[1] = new nsCodingStateMachine(&ISO2022CNSMModel);
    mCodingSM[2] = new nsCodingStateMachine(&ISO2022JPSMModel);
    mCodingSM[3] = new nsCodingStateMachine(&ISO2022KRSMModel);
    mActiveSM = NUM_OF_ESC_CHARSETS;
    mState = eDetecting;
    mDetectedCharset = nullptr;
}

nsEscCharSetProber::~nsEscCharSetProber(void)
{
    for (unsigned int i = 0; i < NUM_OF_ESC_CHARSETS; i++) {
        delete mCodingSM[i];
    }
}

void nsEscCharSetProber::Reset(void)
{
    mState = eDetecting;
    for (unsigned int i = 0; i < NUM_OF_ESC_CHARSETS; i++) {
        mCodingSM[i]->Reset();
    }
    mActiveSM = NUM_OF_ESC_CHARSETS;
    mDetectedCharset = nullptr;
}

nsProbingState nsEscCharSetProber::HandleData(const char *aBuf, unsigned int aLen)
{
    nsSMState codingState;
    int j;
    unsigned int i;

    for (i = 0; i < aLen && mState == eDetecting; i++) {
        for (j = mActiveSM - 1; j >= 0; j--) {
            //byte is feed to all active state machine
            codingState = mCodingSM[j]->NextState(aBuf[i]);
            if (codingState == eError) {
                //got negative answer for this state machine, make it inactive
                mActiveSM--;
                if (mActiveSM == 0) {
                    mState = eNotMe;
                    return mState;
                } else if (j != (int)mActiveSM) {
                    nsCodingStateMachine *t;
                    t = mCodingSM[mActiveSM];
                    mCodingSM[mActiveSM] = mCodingSM[j];
                    mCodingSM[j] = t;
                }
            } else if (codingState == eItsMe) {
                mState = eFoundIt;
                mDetectedCharset = mCodingSM[j]->GetCodingStateMachine();
                return mState;
            }
        }
    }

    return mState;
}
}

