//////////////////////////////////////////////////////////////////////////////
//
//    KEXIF.H
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles Caulier <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//////////////////////////////////////////////////////////////////////////////

#ifndef KEXIF_H
#define KEXIF_H

// Include files for KDE

#include <kdialogbase.h>

class QString;
class QTabWidget;
class QTextEdit;
class QGroupBox;
class QPushButton;

class KExifData;

class KExif : public KDialogBase
{
    Q_OBJECT

public:


    KExif(QWidget* parent=0, const char *name=0);
    ~KExif();

    bool loadFile(const QString& filename);
    bool loadData(const QString& filename, char *data, int size);

private:

    KExifData   *mExifData;
 
    QPushButton *mhelpButton;
    
    QTabWidget  *mTabWidget;
    
    QTextEdit   *mTextEdit;
    
    QGroupBox   *mMainBox;

    QString      mFileName;

private:

    void buildView();

    
private slots:

    void slotTabPageChanged(QWidget*);
    void slotShowItemDescription(const QString& desc);
    void slotHelp();
};

#endif  // KEXIF_H
