/*
 *   Copyright (C) 2015 Aleix Pol Gonzalez <aleixpol@blue-systems.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library/Lesser General Public License
 *   version 2, or (at your option) any later version, as published by the
 *   Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library/Lesser General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.4
import QtQuick.Controls 2.1
import QtQuick.Layouts 1.1
import org.kde.discover 2.0
import org.kde.discover.app 1.0
import "navigation.js" as Navigation
import org.kde.kirigami 2.4 as Kirigami

DiscoverPage
{
    id: page
    title: i18n("Featured")
    leftPadding: 0
    rightPadding: 0
    topPadding: 0
    bottomPadding: 0

    readonly property bool isHome: true

    function searchFor(text) {
        if (text.length === 0)
            return;
        Navigation.openCategory(null, "")
    }

    BusyIndicator {
        id: indicator
        anchors.centerIn: parent
        width: Kirigami.Units.gridUnit * 8
        height: width
        visible: apps.count === 0 && apps.model.isFetching
    }

    background: Rectangle {
        color: Kirigami.Theme.backgroundColor
        Kirigami.Theme.colorSet: Kirigami.Theme.Window
        Kirigami.Theme.inherit: false
    }

    signal clearSearch()

    readonly property bool compact: page.width < 550 || !applicationWindow().wideScreen

    Kirigami.CardsListView {
        id: apps
        model: FeaturedModel {}
        currentIndex: -1
        delegate: ApplicationDelegate {
            application: model.application
            compact: page.compact
        }

        footer: ColumnLayout {
            visible: apps.count === 0 && !apps.model.isFetching
            width: parent.width

            Kirigami.Icon {
                source: "network-disconnect"
                Layout.alignment: Qt.AlignHCenter
                width: Kirigami.Units.gridUnit * 4
                height: width
            }

            Kirigami.Heading {
                Layout.fillWidth: true
                horizontalAlignment: Text.AlignHCenter
                text: xi18nc("@info", "Unable to load applications.<nl/>Please verify Internet connectivity.")
                level: 3
            }
        }
    }
}
