/*
   SPDX-FileCopyrightText: 2018-2021 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#ifndef MARKDOWNPREVIEWDIALOG_H
#define MARKDOWNPREVIEWDIALOG_H

#include "libkmailmarkdown_export.h"
#include <QDialog>
class MarkdownPreviewWidget;
class LIBKMAILMARKDOWN_EXPORT MarkdownPreviewDialog : public QDialog
{
    Q_OBJECT
public:
    explicit MarkdownPreviewDialog(QWidget *parent = nullptr);
    ~MarkdownPreviewDialog() override;
    void setText(const QString &str);

    void setConverterSettings(bool enableEmbeddedLabel, bool enableExtraDefinitionLists);

private:
    void readConfig();
    void writeConfig();
    MarkdownPreviewWidget *mPreviewWidget = nullptr;
};

#endif // MARKDOWNPREVIEWDIALOG_H
