/*
    This file is part of KOrganizer.
    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>
    Copyright (c) 2002 Klarlvdalens Datakonsult AB <info@klaralvdalens-datakonsult.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    As a special exception, permission is given to link this program
    with any edition of Qt, and distribute the resulting executable,
    without including the source code for Qt in the source distribution.
*/

#ifndef KOEVENTTIMEWIDGET_H
#define KOEVENTTIMEWIDGET_H

#include <qvgroupbox.h>
#include <qdatetime.h>
#include <libkcal/event.h>

class KDateEdit;
class KOTimeEdit;
class QCheckBox;
class QLabel;

class KOEventTimeWidget : public QVGroupBox
{
    Q_OBJECT

public:
    KOEventTimeWidget( QWidget* parent = 0, const char* name = 0 );

    /** Set widgets to default values */
    void setDefaults(QDateTime from,QDateTime to,bool allDay);

    void readEvent( KCal::Event *event, bool tmpl );
    void writeEvent( KCal::Event *event );

    bool validateInput();

    QDateTime startDateTime() const;
    QDateTime endDateTime() const;

signals:
    void dateTimesChanged(QDateTime start,QDateTime end);
    void allDayChanged(bool);
    void recursChanged(bool);

public slots:
    void setDuration();
    void slotDateTimesChanged(QDateTime start, QDateTime end, const QString&, bool);
    void setAllDay(bool,bool);
    void setRecurs(bool,bool);

protected slots:
    void timeStuffDisable(bool disable);
    void dontAssociateTime(bool);

private slots:
    void startTimeChanged( QTime );
    void endTimeChanged( QTime );
    void startDateChanged( QDate );
    void endDateChanged( QDate );

private:

    KDateEdit* mStartDateEdit;
    KOTimeEdit* mStartTimeEdit;
    KDateEdit* mEndDateEdit;
    KOTimeEdit* mEndTimeEdit;
    QCheckBox* mRecursButton;
    QCheckBox* mNoTimeButton;
    QLabel* mDurationLabel;

    QDateTime mCurrStartDateTime;
    QDateTime mCurrEndDateTime;
};

#endif
