#include "kogroupwareincomingdialogimpl.h"
#include <libkcal/event.h>
#include <qlabel.h>
#include <qtextedit.h>

/*
 *  Constructs a KOGroupwareIncomingDialogImpl which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
KOGroupwareIncomingDialogImpl::KOGroupwareIncomingDialogImpl( KCal::Incidence* evt,
                                                              QWidget* parent,  
                                                              const char* name, 
                                                              bool modal, 
                                                              WFlags fl )
    : KOGroupwareIncomingDialog( parent, name, modal, fl )
{
    mAccepted = false;
    mConditionallyAccepted = false;
    mDeclined = false;
    
    fromLA->setText( evt->dtStartDateStr() + ", " + evt->dtStartTimeStr() );
    if( evt->type() == "Event" ) {
      KCal::Event* event = static_cast<KCal::Event*>(evt);
      toLA->setText( event->dtEndDateStr() + ", " + event->dtEndTimeStr() );
    }
    locationLA->setText( evt->location() );
    summaryLA->setText( evt->summary() );
    descriptionTE->setText( evt->description() );
}

/*
 *  Destroys the object and frees any allocated resources
 */
KOGroupwareIncomingDialogImpl::~KOGroupwareIncomingDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 * protected slot
 */
void KOGroupwareIncomingDialogImpl::slotAcceptEvent()
{
    mAccepted = true;
    mConditionallyAccepted = false;
    mDeclined = false;
}

/*
 * protected slot
 */
void KOGroupwareIncomingDialogImpl::slotAcceptEventConditionally()
{
    mAccepted = false;
    mConditionallyAccepted = true;
    mDeclined = false;
}

/*
 * protected slot
 */
void KOGroupwareIncomingDialogImpl::slotDeclineEvent()
{
    mAccepted = false;
    mConditionallyAccepted = false;
    mDeclined = true;
}


