/*
    This file is part of KOrganizer.
    Copyright (c) 2002 Steffen Hansen,
    Klaraelvdalens Datakonsult <steffem@klaralvdalens-datakonsult.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
// $Id: konotesview.cpp,v 1.1.2.16 2003/06/20 08:44:18 steffen Exp $

#include <qlayout.h>
#include <qfont.h>
#include <qlabel.h>
#include <qaction.h>

#include <kapplication.h>
#include <kdebug.h>
#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kconfig.h>
#include <kinstance.h>
#include <kaction.h>
#include <kiconloader.h>
#include <kiconview.h>
#include <kpopupmenu.h>

#include "kogroupware.h"

//#include <libkcal/vcaldrag.h>
#include <libkcal/calformat.h>

#include "konotesview.h"
#include "knote.h"

using namespace KOrg;
#include "konotesview.moc"

#include <time.h>

class NotesIconView : public KIconView {
public:
  NotesIconView( KONotesView* notesview, QWidget* parent, const char* name = 0)
    : KIconView( parent, name ), mNotesView( notesview ) {
    setSelectionMode( QIconView::Extended );
  }
private:
  KONotesView* mNotesView;
};

class NotesIconViewItem : public QIconViewItem {
public:
  NotesIconViewItem( NotesIconView* parent, const Note& note ) : QIconViewItem( parent ), mNote(note)
  {
    setNote( note );
    setPixmap( KGlobal::iconLoader()->loadIcon( "knotes", KIcon::Desktop ) );
  }

  void setNote( const Note& note ) {
    mNote = note;
    if( note.text.length() < 40 ) {
      setText( note.text );
    } else {
      setText( note.text.left(37)+i18n("...") );
    }
  }
  const Note& note() const { return mNote; }

  Note mNote;
};

KONotesView::KONotesView(Calendar *calendar,QWidget* parent,
                             const char* name) :
  KOrg::BaseView(calendar,parent,name)
{
  //setInstance( m_instance );
  //setXMLFile( QString( m_instance->instanceName() + "ui.rc" ) );
  //setXMLFile( "notesviewui.rc" );
  //setXML( QString( "notesviewui.rc" ) );
  //factory = new KXMLGUIFactory( this, this, "guifactory" );
  //factory->addClient( this );

  /*
    // Why does this stuff not work !?!?

  // Menu over empty area
  new KAction( i18n("New"), "filenew", 0, this, SLOT(newNote()), actionCollection(), "new_note" );

  // Menu over note
  new KAction( i18n("Hide"), "fileclose" , 0, this, SLOT(slotClose()), actionCollection(), "hide_note" );
  new KAction( i18n("Delete"), "knotesdelete", 0, this, SLOT(slotKill()), actionCollection(), "delete_note" );

  m_menu = static_cast<KPopupMenu*>(factory->container( "note_view", this ));
  m_notemenu = static_cast<KPopupMenu*>(factory->container( "note_context", this ));
  Q_ASSERT( m_menu );
  Q_ASSERT( m_notemenu );
  */
  m_menu = new KPopupMenu(this);
  m_notemenu = new KPopupMenu(this);
  blockUpdating = false;
  KAction* newAction = new KAction( i18n("New Note"), "filenew", 0, this, SLOT( newNote() ),
				    actionCollection());
  newAction->plug( m_menu );
  newAction->plug( m_notemenu );

  KAction* hideAction = new KAction( i18n("Hide all selected"), "fileclose", 0, this, SLOT( slotClose() ),
				     actionCollection() );
  hideAction->plug( m_notemenu );
  KAction* deleteAction = new KAction ( i18n("Delete all selected"), "knotesdelete", 0, this, SLOT( slotDelete() ),
					actionCollection() );
  deleteAction->plug( m_notemenu );

  /*
  connect( newAction, SIGNAL( activated() ), this, SLOT( newNote() ) );
  connect( hideAction, SIGNAL( activated() ), this, SLOT( slotClose() ) );
  connect( deleteAction, SIGNAL( activated() ), this, SLOT( slotDelete() ) );
  */
 QBoxLayout *topLayout = new QVBoxLayout(this);

  QBoxLayout *topBar = new QHBoxLayout;
  topLayout->addLayout(topBar);

  QLabel *title = new QLabel(i18n("Notes View"),this);
  title->setFrameStyle(QFrame::Panel|QFrame::Raised);
  topBar->addWidget(title,1);

  mIconView = new NotesIconView( this, this );
  topLayout->addWidget(mIconView,1);

  connect( mIconView, SIGNAL( executed( QIconViewItem* ) ),
	   this, SLOT( slotNoteActivated( QIconViewItem* ) ) );
  connect( mIconView, SIGNAL( contextMenuRequested ( QIconViewItem*, const QPoint& ) ),
	   this, SLOT( slotPopupNoteMenu( QIconViewItem*, const QPoint& ) ) );

  connect( this, SIGNAL( noteNewOrUpdated( const Note& ) ),
	   KOGroupware::instance(), SLOT( slotNoteNewOrUpdated( const Note& ) ) );
  connect( this, SIGNAL( noteDeleted( const Note& ) ),
	   KOGroupware::instance(), SLOT( slotNoteDeleted( const Note& ) ) );
  mOpenNotes.setAutoDelete( true );
  connect( KOGroupware::instance(), SIGNAL( notesUpdated() ),
	   this, SLOT( updateView() ) );
  connect( KOGroupware::instance(), SIGNAL( notesSync(bool) ),
	   this, SLOT( slotSync(bool) ) );
}

KONotesView::~KONotesView()
{
}

void KONotesView::readSettings()
{
  kdDebug() << "KONotesView::readSettings()" << endl;

  KConfig *config = kapp->config();

  config->setGroup("Views");
}

void KONotesView::writeSettings(KConfig *config)
{
  kdDebug() << "KONotesView::writeSettings()" << endl;

  config->setGroup("Views");
}


void KONotesView::updateView()
{
  kdDebug() << "KONotesView::updateView()" << endl;
  if (blockUpdating) return;
  mIconView->clear();

  QValueList<Note> notes;
  if( KOGroupware::instance() ) notes = KOGroupware::instance()->notes();
  // Put for each Event a KOTodoViewItem in the list view. Don't rely on a
  // specific order of events. That means that we have to generate parent items
  // recursively for proper hierarchical display of Todos.
  /*
  mTodoMap.clear();
  Todo *todo;
  for(todo = todoList.first(); todo; todo = todoList.next()) {
    if (!mTodoMap.contains(todo)) {
      insertTodoItem(todo);
    }
  }
  */

  for( QValueList<Note>::ConstIterator it = notes.begin(); it != notes.end(); ++it ) {
      new NotesIconViewItem( mIconView, (*it) );      
  }

  for( KNote* knote = mOpenNotes.first(); knote != 0; ) {
    bool found = false;
    KNote* tmpNote = knote;
    knote = mOpenNotes.next();
    QValueList<Note>::ConstIterator it;
    for( it = notes.begin(); it != notes.end(); ++it ) {
      if( (*it).id == tmpNote->noteId() ) {
	found = true;
	break;
      }
    }
    if( found ) {
      tmpNote->setNote( *it );
    } else {
      mOpenNotes.remove(tmpNote);
    }
  }

  // Restore opened/closed state
  processSelectionChange();
}

void KONotesView::slotNoteActivated( QIconViewItem* item )
{
  if( !item ) return;
  NotesIconViewItem* nvi = static_cast<NotesIconViewItem*>(item);
  for( KNote* n = mOpenNotes.first(); n != 0; n = mOpenNotes.next() ) {
    if( n->noteId() == nvi->note().id ) {
      n->show();
      n->raise();
      return;
    }
  }
  KNote* note = new KNote( nvi->mNote, this, 0 );
  mOpenNotes.append( note );
  note->show();
}

void KONotesView::newNote()
{
  Note note;
  note.id = CalFormat::createUniqueId();
  KNote* knote = new KNote( note, this, 0 );
  knote->show();
  mOpenNotes.append( knote );
  (void)new NotesIconViewItem( mIconView, note );
  // Defer saving the note until is has been edited
  //emit noteNewOrUpdated( note );
}

void KONotesView::slotPopupNoteMenu( QIconViewItem* item, const QPoint& pos )
{
  if( item ) {
    kdDebug() << "Context menu over " << item->text() << endl;
    m_notemenu->exec( pos );
  } else {
    kdDebug() << "Context menu over nothing" << endl;
    m_menu->exec( pos );
  }
}

void KONotesView::slotDelete()
{
  if ( KMessageBox::warningYesNo( this,
				  i18n("Do you really want to delete all selected notes?"),
				  i18n("Delete Note(s)") ) == KMessageBox::Yes )
    {
      blockUpdating = true;
      QPtrList<NotesIconViewItem> icons;
      for( QIconViewItem* item = mIconView->firstItem(); item != 0;  ) {
	NotesIconViewItem* nvi = static_cast<NotesIconViewItem*>(item);
	item = item->nextItem();
	if( nvi->isSelected() ) {
	  icons.append(nvi);
	}
      }
      for( NotesIconViewItem* nvi = icons.first(); nvi;  ) {
	NotesIconViewItem* del = nvi;
	nvi = icons.next();
	deleteNote( del->note() );
      }
      blockUpdating = false;
      updateView();
    }
}
KNote * KONotesView::getKNote( const QString & noteID )
{
  for( KNote* n = mOpenNotes.first(); n != 0; n = mOpenNotes.next() ) {
    if( n->noteId() == noteID ) {
      return n;
    }
  }
  return 0;
}
void KONotesView::slotClose()
{
  for( QIconViewItem* item = mIconView->firstItem(); item != 0;  ) {
    NotesIconViewItem* nvi = static_cast<NotesIconViewItem*>(item);
    item = item->nextItem();
    if( nvi->isSelected() ) {
      KNote* kn = getKNote( nvi->note().id );
      if (kn) kn->hide();
    }
  }
}

void KONotesView::updateNote( const Note& note)
{
  if (blockUpdating) return;
  for( QIconViewItem* item = mIconView->firstItem(); item != 0; item = item->nextItem() ) {
    NotesIconViewItem* nvi = static_cast<NotesIconViewItem*>(item);
    if( nvi->note().id == note.id ) {
      nvi->setNote( note );
      emit noteNewOrUpdated( note );
      return;
    }
  }
  (void)new NotesIconViewItem( mIconView, note );
  emit noteNewOrUpdated( note );
}

void KONotesView::deleteNote( const Note& note )
{
  
  for( QIconViewItem* item = mIconView->firstItem(); item != 0; item = item->nextItem() ) {
    NotesIconViewItem* nvi = static_cast<NotesIconViewItem*>(item);
    if( nvi->note().id == note.id ) {
      QString id = note.id;
      // we need a real copy, because the one we have a 
      // reference to is about to be gone :)
      Note mynote = note; 
      delete nvi;
      mOpenNotes.remove(getKNote( id ));
      emit noteDeleted( mynote );
      return;
    }
  }
}

void KONotesView::slotSync( bool start )
{
  for( QPtrListIterator<KNote> it(mOpenNotes); it.current(); ++it ) {
    it.current()->setReadOnly(start);
  }
}

void KONotesView::processSelectionChange()
{
//  kdDebug() << "KOTodoView::processSelectionChange()" << endl;
}


void KONotesView::updateConfig()
{
  // TODO: to be implemented.
}

QPtrList<Incidence> KONotesView::selectedIncidences()
{
  QPtrList<Incidence> selected;

/*
  KOProjectViewItem *item = (KOProjectViewItem *)(mTodoListView->selectedItem());
  if (item) selected.append(item->event());
*/

  return selected;
}

DateList KONotesView::selectedDates()
{
  DateList selected;
  return selected;
}

void KONotesView::changeEventDisplay(Event *, int)
{
  updateView();
}

void KONotesView::showDates(const QDate &, const QDate &)
{
  updateView();
}

void KONotesView::showDates(const QDateTime &, const QDateTime &)
{
  updateView();
}

void KONotesView::showEvents(QPtrList<Event>)
{
  kdDebug() << "KOProjectView::selectEvents(): not yet implemented" << endl;
}
