/*
    This file is part of libkcal.
    Copyright (c) 1998 Preston Brwon
    Copyright (c) 2001,2002 Cornelius Schumacher <schumacher@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <qapplication.h>
#include <qclipboard.h>

#include <kiconloader.h>
#include <kdebug.h>
#include <kmessagebox.h>
#include <klocale.h>

#include "vcaldrag.h"
#include "icaldrag.h"
#include "calendar.h"
#include "vcalformat.h"
#include "icalformat.h"
#include "calendarlocal.h"

#include "dndfactory.h"

using namespace KCal;

DndFactory::DndFactory( Calendar *cal ) :
  mCalendar( cal )
{
}

ICalDrag *DndFactory::createDrag(Event *selectedEv, QWidget *owner)
{
  CalendarLocal cal;
  cal.setTimeZone( mCalendar->getTimeZoneStr() );
  Event *ev = new Event( *selectedEv );
  cal.addEvent(ev);
  ICalDrag *icd = new ICalDrag(&cal, owner);
  icd->setPixmap( BarIcon( "appointment" ) );

  return icd;
}

ICalDrag *DndFactory::createDragTodo(Todo *selectedEv, QWidget *owner)
{
  CalendarLocal cal;
  cal.setTimeZone( mCalendar->getTimeZoneStr() );
  Todo *ev = new Todo( *selectedEv );
  cal.addTodo(ev);
  ICalDrag *icd = new ICalDrag(&cal, owner);
  icd->setPixmap( BarIcon( "todo" ) );

  return icd;
}

Event *DndFactory::createDrop(QDropEvent *de)
{
  kdDebug(5800) << "DndFactory::createDrop()" << endl;

  CalendarLocal cal;
  cal.setTimeZone( mCalendar->getTimeZoneStr() );

  if ( ICalDrag::decode( de, &cal ) || VCalDrag::decode( de, &cal ) ) {
    de->accept();

    QPtrList<Event> events = cal.events();
    if ( !events.isEmpty() ) {
      Event *event = new Event( *events.first() );
      return event;
    }
  }

  return 0;
}

Todo *DndFactory::createDropTodo(QDropEvent *de)
{
  kdDebug(5800) << "VCalFormat::createDropTodo()" << endl;

  CalendarLocal cal;
  cal.setTimeZone( mCalendar->getTimeZoneStr() );

  if ( ICalDrag::decode( de, &cal ) || VCalDrag::decode( de, &cal ) ) {
    de->accept();

    QPtrList<Todo> todos = cal.todos();
    if ( !todos.isEmpty() ) {
      Todo *todo = new Todo( *todos.first() );
      return todo;
    }
  }

  return 0;
}


void DndFactory::cutEvent(Event *selectedEv)
{
  if (copyEvent(selectedEv)) {
    mCalendar->deleteEvent(selectedEv);
  }
}

bool DndFactory::copyEvent( Event *selectedEv )
{
  QClipboard *cb = QApplication::clipboard();

  CalendarLocal cal;
  cal.setTimeZone( mCalendar->getTimeZoneStr() );
  Event *ev = new Event( *selectedEv );
  cal.addEvent(ev);
  cb->setData( new ICalDrag( &cal ) );

  return true;
}

Event *DndFactory::pasteEvent(const QDate &newDate, const QTime *newTime)
{
//  kdDebug(5800) << "DnDFactory::pasteEvent()" << endl;

  CalendarLocal cal;

  Event *anEvent = 0;

  QClipboard *cb = QApplication::clipboard();

  if ( !ICalDrag::decode( cb->data(), &cal ) &&
       !VCalDrag::decode( cb->data(), &cal ) ) {
    kdDebug(5800) << "Can't parse clipboard" << endl;
    return 0;
  }

  QPtrList<Event> evList = cal.events();
  Event *ev = evList.first();
  if ( ev ) {
    anEvent = new Event( *ev );

    anEvent->recreate();

    int daysOffset = anEvent->dtEnd().date().dayOfYear() -
      anEvent->dtStart().date().dayOfYear();

    if ( newTime ) {
      anEvent->setDtStart( QDateTime( newDate, *newTime ) );
    } else {
      anEvent->setDtStart( QDateTime( newDate, anEvent->dtStart().time() ) );
    }

    anEvent->setDtEnd( QDateTime( newDate.addDays( daysOffset ),
				  anEvent->dtEnd().time() ) );
    mCalendar->addEvent( anEvent );
  } else {
    QPtrList<Todo> toList = cal.todos();
    Todo *to = toList.first();
    if (to) {
      //anTodo = new Todo(*to);
      kdDebug(5800) << "Trying to paste a Todo." << endl;
      // TODO: check, if todos can be pasted
      //    Todo *aTodo = VTodoToEvent(curVO);
      //    mCalendar->addTodo(aTodo);
    } else {
      kdDebug(5800) << "unknown event type in paste!!!" << endl;
    }
  }

  return anEvent;
}
