/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGHIGHLIGHTPLUGIN_H
#define SKGHIGHLIGHTPLUGIN_H
/** @file
 * A plugin to highlight objects.
*
* @author Stephane MANKOWSKI
 */
#include "skginterfaceplugin.h"

class QAction;

/**
 * A plugin to highlight objects
 */
class SKGHighlightPlugin : public SKGInterfacePlugin
{
    Q_OBJECT
    Q_INTERFACES(SKGInterfacePlugin)

public:
    /**
     * Default Constructor
     */
    explicit SKGHighlightPlugin(QWidget* iWidget, QObject* iParent, const QVariantList& iArg);

    /**
     * Default Destructor
     */
    virtual ~SKGHighlightPlugin();

    /**
     * Called to initialise the plugin
     * @param iDocument the main document
     * @param iArgument the arguments
     * @return true if the plugin is compatible with the document
     */
    virtual bool setupActions(SKGDocument* iDocument, const QStringList& iArgument) Q_DECL_OVERRIDE;

    /**
     * Must be modified to refresh widgets after a modification.
     */
    virtual void refresh() Q_DECL_OVERRIDE;

    /**
     * The title of the plugin.
     * @return The title of the plugin
     */
    virtual QString title() const Q_DECL_OVERRIDE;

    /**
     * The icon of the plugin.
     * @return The icon of the plugin
     */
    virtual QString icon() const Q_DECL_OVERRIDE;

    /**
     * The toolTip of the plugin.
     * @return The toolTip of the plugin
     */
    virtual QString toolTip() const Q_DECL_OVERRIDE;

    /**
     * Must be implemented to set the position of the plugin.
     * @return integer value between 0 and 999 (default = 999)
     */
    virtual int getOrder() const Q_DECL_OVERRIDE;

private Q_SLOTS:
    void onSwitchHighLight();

    void onSwitchClose();

private:
    Q_DISABLE_COPY(SKGHighlightPlugin)

    SKGDocument* m_currentDocument;

    QAction* m_switchHighLight;

    QAction* m_switchClose;
};

#endif  // SKGHIGHLIGHTPLUGIN_H
