#include "editwidget.h"

bool isValueTrue(QString val)
{
  QString v(val.upper());

  if (v=="FALSE" || v=="0" || v=="NO" || v=="NULL" || v.isEmpty())
    return false;

  return true;
}

int hexdigit2int(char dig)
{
  switch (dig)
    {
      case '0' : return 0;
      case '1' : return 1;
      case '2' : return 2;
      case '3' : return 3;
      case '4' : return 4;
      case '5' : return 5;
      case '6' : return 6;
      case '7' : return 7;
      case '8' : return 8;
      case '9' : return 9;
      case 'A' : return 10;
      case 'B' : return 11;
      case 'C' : return 12;
      case 'D' : return 13;
      case 'E' : return 14;
      case 'F' : return 15;
    }

  return -1;
}

int hex2int(QString hex, int pos)
{
  char hex2[5];
  strcpy(hex2,(const char*)(hex.upper()).mid(pos,2));
  int i1 = hexdigit2int(hex2[0]);
  int i2 = hexdigit2int(hex2[1]);

  if ( (i1<0) || (i2<0) )
    return -1;

  return i1 * 16 + i2;
}

QString getNrEntry(QString src, int nr)
{
  int cnt = 0;
  unsigned int i;
  for (i=0; (i<src.length()) && (cnt!=nr*2-1); i++)
      if (src.mid(i,1)=="\"")
        cnt++;

  QString dst = src.right(src.length()-i);
  return dst.left(dst.find('"'));
}


EditWidget::EditWidget( PropWidget **pw, QWidget *parent, const char *name )
   : QWidget( parent, name )
{
  propwidget = pw;
  setMinimumSize(100,100);
  activeItem = 0;
  pressedButton = 0;
  stepX = stepY = 1;
  steprX = steprY = 1;
  numItems = -1;
  actNr = 0;
  copyBuffer = 0;
  for (int i = 0; i<MAX_WIDGETS; i++)
    Items[i] = 0;
}

void EditWidget::resizeEvent( QResizeEvent * )
{
}

void EditWidget::insert_item()
{
  if (numItems>=MAX_WIDGETS)
    return;

  dlgInsertItem *it = new dlgInsertItem((QWidget*)parent()->parent()->parent());
  if (!it->exec())
    {
      delete it;
      return;
    }

  bool created = false;

  int nr = it->getSelected();

  if (nr==0)
    {
      anItem *item = new anItem(this,1,it->getName());
      activeItem = item;
      item->setText("PushButton");
      created = true;
    }

  if (nr==1)
    {
      anItem *item = new anItem(this,2,it->getName());
      activeItem = item;
      item->setText("LineEdit");
      created = true;
    }

  if (nr==2)
    {
      anItem *item = new anItem(this,3,it->getName());
      activeItem = item;
      item->setText("Label");
      created = true;
    }

  if (nr==3)
    {
      anItem *item = new anItem(this,4,it->getName());
      activeItem = item;
      item->setText("1999");
      created = true;
    }

  if (nr==4)
    {
      anItem *item = new anItem(this,5,it->getName());
      activeItem = item;
      item->setText("CheckBox");
      created = true;
    }

  if (nr==5)
    {
      anItem *item = new anItem(this,6,it->getName());
      activeItem = item;
      item->setText("RadioButton");
      created = true;
    }

  if (created)
    {
      activeItem->createItem();
      activeItem->resizeItem(it->getX(), it->getY(), it->getW(), it->getH());
      Items[++numItems] = activeItem;
      actNr = numItems;
      (*propwidget)->refillList();
    }

//  delete it;
}

void EditWidget::paste_item()
{
  if (!copyBuffer)
    return;

  activeItem = new anItem(this, copyBuffer);
  activeItem->createItem();
  activeItem->rebuildFromProps();
  Items[++numItems] = activeItem;
  actNr = numItems;
  (*propwidget)->refillList();
}

void EditWidget::selectNext()
{
  if (actNr < numItems)
    actNr++;
  else
    actNr = 0;

  activeItem = Items[actNr];
  (*propwidget)->refillList();
}

void EditWidget::selectPrev()
{
  if (actNr > 0)
    actNr--;
  else
    actNr = numItems;

  activeItem = Items[actNr];
  (*propwidget)->refillList();
}

void EditWidget::cut_item()
{
  if ((!activeItem) || (numItems<=-1))
    return;

  int m=-1;
  for (int i=0; (i<=numItems) && (m==-1); i++)
    {
      if (Items[i] == activeItem)
        m = i;
    }

  if (m==-1)
    return;

  for (int n = m; n<=numItems-1; n++)
    {
      Items[n] = Items[n+1];
    }

  Items[numItems] = 0;

  delete activeItem;

  numItems--;
  activeItem = Items[0];
  actNr = numItems;
  (*propwidget)->refillList();
  copyBuffer = 0;
}

void EditWidget::mouseMoveEvent( QMouseEvent *e )
{
  if (!activeItem)
    return;

  if (pressedButton == LeftButton)
    activeItem->resizeItem((int)((e->pos().x() - pressedX + wasX)/stepX)*stepX ,
                           (int)((e->pos().y() - pressedY + wasY)/stepY)*stepY, activeItem->W(), activeItem->H());

  if (pressedButton == MidButton)
    activeItem->resizeItem((int)(e->pos().x()/stepX)*stepX ,
                           (int)(e->pos().y()/stepY)*stepY, activeItem->W(), activeItem->H());

  if (pressedButton == RightButton)
    activeItem->resizeItem(activeItem->X(), activeItem->Y(),
                           ((int)(e->pos().x() - pressedX + wasW)/steprX)*steprX,
                           ((int)(e->pos().y() - pressedY + wasH)/steprY)*steprY);

}

void EditWidget::mousePressEvent( QMouseEvent *e )
{
  pressedButton = e->button();
  pressedX = e->pos().x();
  pressedY = e->pos().y();

  if (activeItem)
  {
    wasX = activeItem->X();
    wasY = activeItem->Y();
    wasW = activeItem->W();
    wasH = activeItem->H();
  }

  grabMouse(crossCursor);

  getPropWidget()->refillList();
  mouseMoveEvent(e);
}

void EditWidget::mouseReleaseEvent( QMouseEvent *e )
{
  releaseMouse();
  getPropWidget()->refillList();
}


void EditWidget::setActItem (anItem *i)
{
  activeItem = i;

  int n;
  for (n = 0; (n <= numItems) && (Items[n]!=activeItem); n++)
    ;

  if (Items[n] == activeItem)
    actNr = n;

}




dlgInsertItem::dlgInsertItem(QWidget *parent)
  : QDialog(parent,klocale->translate("Insert item"), TRUE)
{
  setMinimumSize(300,280);
  setMaximumSize(300,280);

  QPushButton *ok, *cancel;
  ok = new QPushButton( klocale->translate( "Ok" ), this );
  ok->setGeometry( 10,240, 100,30 );
  connect( ok, SIGNAL(clicked()), SLOT(accept()) );
  cancel = new QPushButton( klocale->translate( "Cancel" ), this );
  cancel->setGeometry( 190,240, 100,30 );
  connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

  QLabel *lab1 = new QLabel(klocale->translate("Type of object to insert"),this);
  lab1->setGeometry( 10,5,280,25 );

  lbox = new QListBox(this);
  lbox-> setGeometry(10,30,280,80);
  lbox->insertItem( "QPushButton" );
  lbox->insertItem( "QLineEdit" );
  lbox->insertItem( "QLabel" );
  lbox->insertItem( "QLCDNumber" );
  lbox->insertItem( "QCheckBox" );
  lbox->insertItem( "QRadioButton" );

  QLabel *lab2 = new QLabel(klocale->translate("X"),this);
  lab2->setGeometry(  10,160,50, 25 );

  QLabel *lab3 = new QLabel(klocale->translate("Y"),this);
  lab3->setGeometry(  10,200,50, 25 );

  QLabel *lab4 = new QLabel(klocale->translate("W"),this);
  lab4->setGeometry( 160,160,40, 25 );

  QLabel *lab5 = new QLabel(klocale->translate("H"),this);
  lab5->setGeometry( 160,200,40, 25 );

  QLabel *lab6 = new QLabel(klocale->translate("Name"),this);
  lab6->setGeometry(  10,120,50, 25 );

  led1 = new QLineEdit(this);
  led1->setGeometry( 60, 160, 90, 25 );
  led1->setText("10");

  led2 = new QLineEdit(this);
  led2->setGeometry( 60, 200, 90, 25 );
  led2->setText("10");

  led3 = new QLineEdit(this);
  led3->setGeometry( 200, 160, 90, 25 );
  led3->setText("100");

  led4 = new QLineEdit(this);
  led4->setGeometry( 200, 200, 90, 25 );
  led4->setText("25");

  led5 = new QLineEdit(this);
  led5->setGeometry( 60,  120, 230, 25 );
  led5->setText("anItem");

}






anItem::anItem( EditWidget *parent, int type, QString Name )
{
  Parent = parent;
  theitem1 = 0;
  theitem2 = 0;
  theitem3 = 0;
  theitem4 = 0;
  theitem5 = 0;
  theitem6 = 0;

  setShow(true);
  resizeItem(10,10,100,25);
  setName(Name);

  nrOfProps = 17;
  Type = type;

  props[0] .group = GR_GENERAL; props[0] .allowed = ALLOW_STRING;  props[0] .prop = klocale->translate("Name");
  props[1] .group = GR_ORIENT;  props[1] .allowed = ALLOW_INT;     props[1] .prop = klocale->translate("X");
  props[2] .group = GR_ORIENT;  props[2] .allowed = ALLOW_INT;     props[2] .prop = klocale->translate("Y");
  props[3] .group = GR_ORIENT;  props[3] .allowed = ALLOW_INT;     props[3] .prop = klocale->translate("Width");
  props[4] .group = GR_ORIENT;  props[4] .allowed = ALLOW_INT;     props[4] .prop = klocale->translate("Height");
  props[5] .group = GR_GENERAL; props[5] .allowed = ALLOW_BOOL;    props[5] .prop = klocale->translate("isShow");
  props[6] .group = GR_GENERAL; props[6] .allowed = ALLOW_BOOL;    props[6] .prop = klocale->translate("isEnabled");     props[6] .value = "TRUE";
  props[7] .group = GR_STYLE;   props[7] .allowed = ALLOW_FILE;    props[7] .prop = klocale->translate("BgPixmap");
  props[8] .group = GR_STYLE;   props[8] .allowed = ALLOW_COLOR;   props[8] .prop = klocale->translate("BgColor");

  props[9] .group = GR_STYLE;   props[9] .allowed = ALLOW_INT;     props[9] .prop = klocale->translate("MinWidth");   props[9].value = "0";

  props[10].group = GR_STYLE;   props[10].allowed = ALLOW_STRING | ALLOW_FILE;
                                                                   props[10].prop = klocale->translate("MaskPixmap");
  props[11].group = GR_STYLE;   props[11].allowed = ALLOW_FONT;    props[11].prop = klocale->translate("Font");
  props[12].group = GR_STYLE;   props[12].allowed = ALLOW_INT;     props[12].prop = klocale->translate("MinHeight");  props[12].value = "0";
  props[13].group = GR_STYLE;   props[13].allowed = ALLOW_INT;     props[13].prop = klocale->translate("MaxWidth");
  props[14].group = GR_STYLE;   props[14].allowed = ALLOW_STRING;  props[14].prop = klocale->translate("MouseCursor");
  props[15].group = GR_GENERAL; props[15].allowed = ALLOW_STRING;  props[15].prop = klocale->translate("Text");
  props[16].group = GR_STYLE;   props[16].allowed = ALLOW_INT;     props[16].prop = klocale->translate("MaxHeight");

  switch (Type)
    {
      case 1:
        props[17].group = GR_GENERAL;   props[17].allowed = ALLOW_FILE;    props[17].prop = klocale->translate("Pixmap");          props[17].value = "";
        props[18].group = GR_GENERAL;   props[18].allowed = ALLOW_BOOL;    props[18].prop = klocale->translate("isToggleButton");  props[18].value = "FALSE";
        props[19].group = GR_GENERAL;   props[19].allowed = ALLOW_BOOL;    props[19].prop = klocale->translate("isMenuButton");    props[19].value = "FALSE";
        props[20].group = GR_GENERAL;   props[20].allowed = ALLOW_BOOL;    props[20].prop = klocale->translate("isAutoDefault");   props[20].value = "FALSE";
        props[21].group = GR_GENERAL;   props[21].allowed = ALLOW_BOOL;    props[21].prop = klocale->translate("isDefault");       props[21].value = "FALSE";
        props[22].group = GR_GENERAL;   props[22].allowed = ALLOW_BOOL;    props[22].prop = klocale->translate("isDown");          props[22].value = "FALSE";
        props[23].group = GR_GENERAL;   props[23].allowed = ALLOW_BOOL;    props[23].prop = klocale->translate("isAutoResize");    props[23].value = "FALSE";
        props[24].group = GR_GENERAL;   props[24].allowed = ALLOW_BOOL;    props[24].prop = klocale->translate("isAutoRepeat");    props[24].value = "FALSE";
        nrOfProps = 25;
        break;
      case 2:
      case 3:
        props[17].group = GR_GENERAL;   props[17].allowed = ALLOW_FILE;    props[17].prop = klocale->translate("Pixmap");
        props[18].group = GR_GENERAL;   props[18].allowed = ALLOW_BOOL;    props[18].prop = klocale->translate("isAutoResize");
        props[19].group = GR_GENERAL;   props[19].allowed = ALLOW_BOOL;    props[19].prop = klocale->translate("isWordBrake");     props[19].value = "FALSE";
        nrOfProps = 20;
        break;
      case 4:
        props[17].group = GR_GENERAL;   props[17].allowed = ALLOW_FILE;    props[17].prop = klocale->translate("Pixmap");
        props[18].group = GR_GENERAL;   props[18].allowed = ALLOW_BOOL;    props[18].prop = klocale->translate("isAutoResize");
        nrOfProps = 19;
        break;
      case 5:
      case 6:
        props[17].group = GR_GENERAL;   props[17].allowed = ALLOW_FILE;    props[17].prop = klocale->translate("Pixmap");
        props[18].group = GR_GENERAL;   props[18].allowed = ALLOW_BOOL;    props[18].prop = klocale->translate("isAutoResize");
        props[19].group = GR_GENERAL;   props[19].allowed = ALLOW_BOOL;    props[19].prop = klocale->translate("isDown");
        nrOfProps = 20;
        break;
    }

  nrOfProps++;
}

anItem::anItem( EditWidget *parent, anItem *itm )
{
  Parent = parent;
  theitem1 = 0;
  theitem2 = 0;
  theitem3 = 0;
  theitem4 = 0;
  theitem5 = 0;
  theitem6 = 0;

  Type = itm->Type;

  nrOfProps = itm->nrOfProps;

  for (int i = 0; i<=nrOfProps; i++)
    {
      props[i].value   = itm->props[i].value;
      props[i].prop    = itm->props[i].prop;
      props[i].group   = itm->props[i].group;
      props[i].allowed = itm->props[i].allowed;
    }

  setShow(itm->bShow);
  setName(itm->name);
}

anItem::~anItem()
{
  if (theitem1) delete theitem1;
  if (theitem2) delete theitem2;
  if (theitem3) delete theitem3;
  if (theitem4) delete theitem4;
  if (theitem5) delete theitem5;
  if (theitem6) delete theitem6;
}

void anItem::createItem()
{
  if (theitem1)
    delete theitem1;

  if (theitem2)
    delete theitem2;

  if (theitem3)
    delete theitem3;

  if (theitem4)
    delete theitem4;

  if (theitem5)
    delete theitem5;

  if (theitem6)
    delete theitem6;

  switch (Type)
    {
      case 1:
        theitem1 = new QPushButton(getText(), Parent);
        theitem1->setGeometry(X(),Y(),W(),H());
        break;
      case 2:
        theitem2 = new QLineEdit(Parent);
        theitem2->setText(getText());
        theitem2->setGeometry(X(),Y(),W(),H());
        break;
      case 3:
        theitem3 = new QLabel(Parent);
        theitem3->setText(getText());
        theitem3->setFrameStyle(QFrame::Panel | QFrame::Plain);
        theitem3->setGeometry(X(),Y(),W(),H());
        break;
      case 4:
        theitem4 = new QLCDNumber(4,Parent);
        theitem4->display(1999);
        theitem4->setGeometry(X(),Y(),W(),H());
        break;
      case 5:
        theitem5 = new QCheckBox(getText(), Parent);
        theitem5->setGeometry(X(),Y(),W(),H());
        break;
      case 6:
        theitem6 = new QRadioButton(getText(),Parent);
        theitem6->setGeometry(X(),Y(),W(),H());
        break;
    }

  redoShow();
}

void anItem::resizeItem(int X, int Y, int W, int H)
{

  QWidget *item = getItemsWidget();
  if (!item)
    return;

  item->setGeometry(X,Y,W,H);

  setX(item->x()); setY(item->y()); setW(item->width()); setH(item->height());

  redoShow();
}

void anItem::redoShow()
{
  QWidget *item = getItemsWidget();
  if (!item)
    return;

  if (isShow()) item->show(); else item->hide();
}

void anItem::setText(QString txt)
{
  text = txt;
  setPropVal(15,txt);

  switch (Type)
  {
    case 1:
      if (theitem1)
        theitem1->setText(text);
      break;
    case 2:
      if (theitem2)
        theitem2->setText(text);
      break;
    case 3:
      if (theitem3)
        theitem3->setText(text);
      break;
    case 4:
      if (theitem4)
        theitem4->display(text.toInt());
      break;
    case 5:
      if (theitem5)
        theitem5->setText(text);
      break;
    case 6:
      if (theitem6)
        theitem6->setText(text);
      break;
  }
}

QString anItem::descr(int nr)
{
   int i;

   if (nr == -1)
     i = Type;
   else
     i = nr;

   switch (i)
     {
       case 1:
         return "QPushButton";
       case 2:
         return "QLineEdit";
       case 3:
         return "QLabel";
       case 4:
         return "QLCDNumber";
       case 5:
         return "QCheckBox";
       case 6:
         return "QRadioButton";
     }

  return "";
}

QWidget *anItem::getItemsWidget()
{
  if (Type == 1) return (QWidget*)theitem1; else
  if (Type == 2) return (QWidget*)theitem2; else
  if (Type == 3) return (QWidget*)theitem3; else
  if (Type == 4) return (QWidget*)theitem4; else
  if (Type == 5) return (QWidget*)theitem5; else
  if (Type == 6) return (QWidget*)theitem6; else
    return 0;
}

void anItem::rebuildFromProps()
{
  QWidget *item = getItemsWidget();
  if (!item)
    return;

  setName(props[0].value);

  resizeItem(props[1].value.toInt(),
             props[2].value.toInt(),
             props[3].value.toInt(),
             props[4].value.toInt());

  setShow(isValueTrue(props[5].value));

  setText(props[15].value);

  item->setMinimumWidth(props[9].value.toInt());
  item->setMinimumHeight(props[12].value.toInt());

  if (!props[13].value.isEmpty())
    item->setMaximumWidth(props[13].value.toInt());

  if (!props[16].value.isEmpty())
    item->setMaximumHeight(props[16].value.toInt());

  item->setEnabled ( isValueTrue( props[6].value ) );

  if (!props[7].value.isEmpty())
    item->setBackgroundPixmap( QPixmap( props[7].value ) );
  else
    item->setBackgroundPixmap( QPixmap() );

  if (!props[10].value.isEmpty())
    item->setMask( QBitmap( props[10].value ) );
  else
    item->setMask( QBitmap() );

  int r,g,b;

  QString fnt1 = getNrEntry(props[11].value, 1);
  int fnt2 = getNrEntry(props[11].value, 2).toInt();
  int fnt3 = getNrEntry(props[11].value, 3).toInt();
  bool fnt4 = isValueTrue( getNrEntry(props[11].value, 4) );

  if (props[11].value.length())
    item->setFont ( QFont (fnt1, fnt2, fnt3, fnt4) );

  if ( props[8].value.length()==8 )
    {
       r = hex2int(props[8].value,2);
       g = hex2int(props[8].value,4);
       b = hex2int(props[8].value,6);
       if ( (r>=0) && (g>=0) && (b>=0) )
         item->setPalette( QPalette (QColor( r,g,b )) );
       else
         {
           item->setPalette( QPalette (QColor( 255,255,255 )) );
           props[8].value = "0xffffff";
         }

    }

  switch (Type)
    {
      case 1:
        if (!props[17].value.isEmpty())
           theitem1->setPixmap( QPixmap( props[17].value ) );
        else
           theitem1->setText(props[15].value);
        theitem1->setToggleButton( isValueTrue( props[18].value ) );
        theitem1->setIsMenuButton( isValueTrue( props[19].value ) );
        theitem1->setAutoDefault ( isValueTrue( props[20].value ) );
        theitem1->setDefault     ( isValueTrue( props[21].value ) );
        theitem1->setDown        ( isValueTrue( props[22].value ) );
        theitem1->setAutoResize  ( isValueTrue( props[23].value ) );

        break;
      case 2:
        break;
      case 3:
        if (!props[17].value.isEmpty())
           theitem3->setPixmap( QPixmap( props[17].value ) );
        else
           theitem3->setText(props[15].value);
        theitem3->setAutoResize  ( isValueTrue( props[17].value ) );
        if (isValueTrue( props[19].value ))
          theitem3->setAlignment ( theitem3->alignment() | WordBreak );
        else
          theitem3->setAlignment ( theitem3->alignment() & !WordBreak );

        break;
      case 4:
        break;
      case 5:
        if (!props[17].value.isEmpty())
           theitem5->setPixmap( QPixmap( props[17].value ) );
        else
           theitem5->setText(props[15].value);
        theitem5->setAutoResize  ( isValueTrue( props[17].value ) );
        theitem5->setDown        ( isValueTrue( props[18].value ) );
        break;
      case 6:
        if (!props[17].value.isEmpty())
           theitem6->setPixmap( QPixmap( props[17].value ) );
        else
           theitem6->setText(props[15].value);
        theitem6->setAutoResize  ( isValueTrue( props[17].value ) );
        theitem6->setDown        ( isValueTrue( props[18].value ) );
        break;
    }
}













