/////////////////////////////////////////////////////////////////////////////
//
// KPlugin object
//
// Time-stamp: <97/05/06 04:03:34 vels>
// Copyright (c) VDOnet Corp. 1996
//
/////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "kplugin.h"
#include "kplugin.moc"
#include "kplugmng.h"

// Constructor
KPlugin::KPlugin() :
  m_inputMIMETypes(NULL),
  m_outputMIMETypes(NULL),
  m_options(NULL)
{
}

// Destructor
KPlugin::~KPlugin()
{
  if (m_inputMIMETypes)
    delete m_inputMIMETypes;

  if (m_outputMIMETypes)
    delete m_outputMIMETypes;

  if (m_options)
    delete m_options;
}

// Start working
int KPlugin::start()
{
  warning("KPlugin::run() not implemented");
  return -1;
}

// Stop working
void KPlugin::stop()
{
  warning("KPlugin::stop() not implemented");
  return;
}

// New data arrived
int KPlugin::callInputMemberFunction(int, void *)
{
  warning("KPlugin::callInputMemberFunction() not implemented");
  return -1;
}

// Plugin has finished working
void KPlugin::finished()
{
  if (!m_mng)
  {
    warning("KPlugin::finished() no plugin manager");
    return;
  }

  // Who is finished ?
  switch (type())
  {
  case Input:
    // Tell output plugin that input has finished working
    m_mng->outputPlugin()->inputFinished();
    break;

  case Output:
    // Tell manager that chain has finished working
    m_mng->chainFinished();
    break;

  default:
    warning("KPlugin::finished() wrong plugin type");
    break;
  }
}

// Input plugin has finished working
void KPlugin::inputFinished()
{
  // Output plugin has finished working too
  finished();
}


// Pass data forward in chain
int KPlugin::output(const char *mimeType, void *data)
{
  if (!m_mng)
  {
    warning("KPlugin::output() no plugin manager");
    return -1;
  }

  // Get next plugin in chain from manager
  KPlugin *next = m_mng->next(this);
  if (!next)
  {
    warning("KPlugin::output() broken chain");
    return -1;
  }

  // Find out index of appropriate input handler
  int index = next->inputMIMETypes()->find(mimeType);
  if (index < 0)
  {
    warning("KPlugin::output() can't find input MIME type '%s'", mimeType);
    return -1;
  }
  
  // Pass output data to it
  return next->callInputMemberFunction(index, data);
}


// Set plugin option
int KPlugin::set(const char *option, void *arg)
{
  if (!m_options)
  {
    warning("KPlugin::set(): no options defined");
    return -1;
  }

  int index;
  if ((index=m_options->find(option)) < 0)
  {
    warning("KPlugin::set(): options '%s' not found", option);
    return -1;
  }

  return callOptionMemberFunction(index*2, arg);
}

// Get plugin option
int KPlugin::get(const char *option, void *arg)
{
  if (!m_options)
  {
    warning("KPlugin::get(): no options defined");
    return -1;
  }

  int index;
  if ((index=m_options->find(option)) < 0)
  {
    warning("KPlugin::get(): options '%s' not found", option);
    return -1;
  }

  return callOptionMemberFunction(index*2 + 1, arg);
}

// Call member function to set/get option
int KPlugin::callOptionMemberFunction(int, void *)
{
  warning("KPlugin::callOptionMemberFunction() not implemented");
  return -1;
}

// Return list of registered options
QStrList *KPlugin::options(void)
{
  return m_options;
}

// Register new option
void KPlugin::registerOption(const char *option)
{
  // If we didn't create the list yet - do it now
  if (!m_options)
  {
    m_options = new QStrIList();
    CHECK_PTR(m_options);
  }

  m_options->append(option);
}


// Register new input MIME type
void KPlugin::registerInputMIMEType(const char *type)
{
  // If we didn't create the list yet - do it now
  if (!m_inputMIMETypes)
  {
    m_inputMIMETypes = new QStrList(FALSE);
    CHECK_PTR(m_inputMIMETypes);
  }

  m_inputMIMETypes->append(type);
}

// Register new output MIME type
void KPlugin::registerOutputMIMEType(const char *type)
{
  // If we didn't create the list yet - do it now
  if (!m_outputMIMETypes)
  {
    m_outputMIMETypes = new QStrList(FALSE);
    CHECK_PTR(m_outputMIMETypes);
  }

  m_outputMIMETypes->append(type);
}

// Return list of registered input MIME types
QStrList *KPlugin::inputMIMETypes(void)
{
  return m_inputMIMETypes;
}
 
// Return list of registered output MIME types
QStrList *KPlugin::outputMIMETypes(void)
{
  return m_outputMIMETypes;
}
