/////////////////////////////////////////////////////////////////////////////
//
// STDOUT plugin
//
// Time-stamp: <97/05/05 17:36:06 vels>
// Copyright (c) VDOnet Corp. 1996
//
/////////////////////////////////////////////////////////////////////////////
  
#ifndef _STDOUTPLUG_H_
#define _STDOUTPLUG_H_

#include "kplugin.h"

/// StdoutPlugin: Text output plugin.
/** 
  Plugin type: output.

  Description:
    This plugin prints text to standart output.
  
  Input MIME types:
    MIME type             Description
    -------------------------------------------------------------------
    text/plain            ASCII text.

  Options:
    Name            Type                Description
    -------------------------------------------------------------------
    "tty_width"     int                 Width of terminal (to break lines)
  */
class StdoutPlugin : public KPlugin
{
  Q_OBJECT

public:
  /// Constructor
  /** 
    Constructs StdoutPlugin
    */
  StdoutPlugin();
  ~StdoutPlugin();

protected:
  virtual int callOptionMemberFunction(int index, void *arg);
  virtual int callInputMemberFunction(int index, void *arg);

  int  setWidth(void *);
  int  getWidth(void *);
  
private:
  int textInput(void *);

private:
  int  m_width;

  // Array of pointers to actions - used in callOptionMemberFunction()
  typedef int (StdoutPlugin::*MemberFunction)(void *);
  MemberFunction *m_option;

  // Array of pointers to input handlers - used in callInputMemberFunction()
  MemberFunction *m_input;
};



/// Create new plugin instance.
/** 
  C function used by application to access this plugin.
  The application must call dlopen("full_path_to_plugin"). And then 
  dlsym(handle, "initInstance). Then each call to initInstance() will
  create and return new copy of the plugin object.
  */
extern "C" KPlugin *initInstance()
{
  return (KPlugin *)(new StdoutPlugin);
}

#endif // _STDOUTPLUG_H_
