/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include <stdio.h>
#include <unistd.h>
#include <qtc/qtc.h>

int filter (qt_QObject *o,qt_QEvent *e);

int main(int argc,char **argv)
{
    qt_QApplication *app;
    qt_QWidget *p1;
    qt_EventFilter *evf;
    
    printf ("This program will print info about events received\n");
    printf ("by the main widget.\n");
    printf ("Detailed information will be provided for keypress events\n");
    sleep(2);
    /* Create an application */
    app=qt_new_QApplication(argc,argv);
    
    /* A widget, so it gets events*/
    
    p1=qt_new_QWidget (0,"Main dialog",0);
    qt_QWidget_setGeometry (p1,100,100,300,300);
    
    evf=qt_new_EventFilter((qt_QObject *)p1,filter);
    
    /* Enter the event loop */
    qt_QWidget_show ((qt_QWidget *)p1);
    qt_QApplication_setMainWidget(app,(qt_QWidget *)p1);
    qt_QApplication_exec(app);
    
    /* Avoid warnings ;-) */
    exit (0);
}

int filter (qt_QObject *o,qt_QEvent *e)
{
    qt_QKeyEvent *k;
    int type;
    printf ("Received event:\n");
    type=qt_QEvent_type(e);
    switch (type)
    {
    case 0:
        printf ("Type = None\n");break;
    case 1:
        printf ("Type = Timer\n");break;
    case 2:
        printf ("Type = MouseButtonPress\n");break;
    case 3:
        printf ("Type = MouseButtonRelease\n");break;
    case 4:
        printf ("Type = MouseButtonDblClick\n");break;
    case 5:
        printf ("Type = MouseMove\n");break;
    case 6:
        printf ("Type = KeyPress\n");
        printf ("Detailed info:\n");
        k=(qt_QKeyEvent *)e;
        printf ("key:%d\n",qt_QKeyEvent_key(k));
        printf ("ascii:%d\n",qt_QKeyEvent_ascii(k));
        printf ("state:%d\n\n",qt_QKeyEvent_state(k));
        break;
    case 7:
        printf ("Type = KeyRelease\n");break;
    case 8:
        printf ("Type = FocusIn\n");break;
    case 21:
        printf ("Type = FocusRestore\n");break;
    case 9:
        printf ("Type = FocusOut\n");break;
    case 10:
        printf ("Type = EventEnter\n");break;
    case 11:
        printf ("Type = EventLeave\n");break;
    case 12:
        printf ("Type = EventPaint\n");break;
    case 13:
        printf ("Type = Eventmove\n");break;
    case 14:
        printf ("Type = EventResize\n");break;
    case 15:
        printf ("Type = EventCreate\n");break;
    case 16:
        printf ("Type = EventDestroy\n");break;
    case 17:
        printf ("Type = EventShow\n");break;
    case 18:
        printf ("Type = EventHide\n");break;
    case 19:
        printf ("Type = EventClose\n");break;
    case 20:
        printf ("Type = EventQuit\n");break;
    case 30:
        printf ("Type = EventAccel\n");break;
    case 40:
        printf ("Type = EventClipboard\n");break;
    case 50:
        printf ("Type = SockAct\n");break;
    case 60:
        printf ("Type = DragMove\n");break;
    case 61:
        printf ("Type = DragLeave\n");break;
    case 62:
        printf ("Type = Drop\n");break;
    case 1000:
        printf ("Type = EventUser\n");break;
    }
    return 0;
}
