#include <stdio.h>

#include <qlabel.h>

#include <kstdaccel.h>
#include <kiconloader.h>
#include <kmenubar.h>
#include <kapp.h>
#include <kaction.h>

#include "ksimpleapp.moc"

KSimpleApp::KSimpleApp (const char *name) :
  KTMainWindow (name)
{
  KAction *reposition = 
    new KAction ("&Reposition Text", QIconSet(BarIcon ("idea")),
		 CTRL+Key_R, this, SLOT (slotRepositionText()),
		 this);
  KAction *quit =
    new KAction ("&Quit", KStdAccel::quit(), kapp,
		 SLOT (closeAllWindows()), this);

  QPopupMenu *filemenu = new QPopupMenu;
  reposition->plug (filemenu);
  filemenu->insertSeparator();
  quit->plug (filemenu);
			
  menuBar()->insertItem ("&File", filemenu);

  reposition->plug(toolBar());

  //Chapter 2, Exercise 1
  const int linedid = 1;
  toolBar()->insertLined ("Initial text", linedid,
			  SIGNAL(returnPressed()), this,
			  SLOT (slotEnterPressed()), true);
  toolBar()->setItemAutoSized (linedid);

  statusBar()->message ("Ready!");

  text = new QLabel ("Hello!", this);
  text->setBackgroundColor (Qt::white);
  alignment [0] = QLabel::AlignLeft | QLabel::AlignVCenter;
  alignment [1] = QLabel::AlignHCenter | QLabel::AlignVCenter;
  alignment [2] = QLabel::AlignRight | QLabel::AlignVCenter;
  indexalignment = 0;
  
  text->setAlignment (alignment [indexalignment]);
  setView (text);
  
}

//Chapter 2, Exercise 1
void
KSimpleApp::slotEnterPressed()
{
  //You would process the Enter-key press here.
  printf ("Enter key pressed.\n");
}

void
KSimpleApp::slotRepositionText ()
{
  indexalignment = (indexalignment+1)%3;
  text->setAlignment (alignment[indexalignment]);

  statusBar()->message ("Repositioned text in content area", 1000);
}
