/*
    SPDX-FileCopyrightText: 2015 Martin Gräßlin <mgraesslin@kde.org>
    SPDX-FileCopyrightText: 2015 Marco Martin <mart@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/
#ifndef KWAYLAND_SERVER_BLUR_INTERFACE_H
#define KWAYLAND_SERVER_BLUR_INTERFACE_H

#include "global.h"
#include "resource.h"

#include <QObject>

#include <KWayland/Server/kwaylandserver_export.h>

namespace KWayland
{
namespace Server
{
class Display;

/**
 * @brief Represents the Global for org_kde_kwin_blur_manager interface.
 *
 * This class creates BlurInterfaces and attaches them to SurfaceInterfaces.
 *
 * @see BlurInterface
 * @see SurfaceInterface
 * @since 5.5
 **/
class KWAYLANDSERVER_EXPORT BlurManagerInterface : public Global
{
    Q_OBJECT
public:
    ~BlurManagerInterface() override;

private:
    explicit BlurManagerInterface(Display *display, QObject *parent = nullptr);
    friend class Display;
    class Private;
};

/**
 * @brief Represents the Resource for the org_kde_kwin_blur interface.
 *
 * Instances of this class are only generated by the BlurManagerInterface.
 * The BlurInterface gets attached to a SurfaceInterface and can be assessed
 * from there using @link SurfaceInterface::blur() @endlink. Please note that
 * the BlurInterface is only available on the SurfaceInterface after it has been
 * committed.
 *
 * @see BlurManagerInterface
 * @see SurfaceInterface
 * @since 5.5
 **/
class KWAYLANDSERVER_EXPORT BlurInterface : public Resource
{
    Q_OBJECT
public:
    ~BlurInterface() override;

    /**
     * @returns The region or the SurfaceInterface which should be blurred, null Region implies complete surface.
     **/
    QRegion region();

private:
    explicit BlurInterface(BlurManagerInterface *parent, wl_resource *parentResource);
    friend class BlurManagerInterface;

    class Private;
    Private *d_func() const;
};

}
}

#endif
