/************************************************************************
 * kinst - KDE Application Installer - gnomeconfig.cpp                  *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/stat.h>
#include <libgen.h>
#include <qdir.h>
#include <qstring.h>
#include <ksimpleconfig.h>
#include <qmessagebox.h>

#include "gnomeconfig.h"
#include "stringfunc.h"

#ifndef EOL
#define EOL 10
#endif

#ifndef GNOMELNKDIR
// #define GNOMELNKDIR "/etc/X11/applnk"
#define GNOMELNKDIR "/usr/share/gnome/apps"
#endif

tGNOMEConfig::tGNOMEConfig()
{
  options = new tKIFOptions;

  GNOMELNKfile = NULL;
}

tGNOMEConfig::~tGNOMEConfig()
{
  delete options;
}

void tGNOMEConfig::setOptions(tKIFOptions* newoptions)
{
  *options = *newoptions;
}

bool tGNOMEConfig::DeLocalized(const char* dir, const char* localized,
			     QString* delocalized)
{
  *delocalized = GNOMELNKDIR;
  *delocalized += "/Applications"; // That's it for now

  return(1);

  /*
  QString filename;
  QString string;
  QDir d(dir);
  const QFileInfoList* list = d.entryInfoList();
  QFileInfoListIterator it(*list);
  QFileInfo* fi;
  KSimpleConfig* config;
  bool result;

#ifdef _DEBUG_
  printf("gnomeconfig:  DeLocalized: in: %s\n", dir);
#endif

  d.setFilter(QDir::Dirs);

  filename = dir;
  filename += "/.directory";
  config = new KSimpleConfig(filename, true);
  config->setGroup("KDE Desktop Entry");
  string = "Name[";
  string += klocale->language();
  string += "]";
  *delocalized = 
    config->readEntry(string);
  delete config;
  if(qstrcmp(localized, *delocalized) == 0)
    {
      result = true;
      *delocalized = dir;
    }
  else result = false;

  while( (fi=it.current()) )
    {
      if(d.isReadable() && (result == false)
	 && (qstrcmp(fi->fileName().data(), "."))
	 && (qstrcmp(fi->fileName().data(), ".."))
	 && (fi->isDir()))
	{
	  string = dir;
	  string += "/";
	  string += fi->fileName().data();
	  result = DeLocalized(string, localized, delocalized);
	}
      ++it;
    }

  return(result);

  */
}

int tGNOMEConfig::DetermineGNOMELNK(int extnr)
{
  QString GNOMELNKPath;
  char ProgramName[KIFOPTIONS_FIELD_LENGTH];

  if(extnr < 0)
    {
      strncpy(ProgramName, options->ProgramName, KIFOPTIONS_FIELD_LENGTH);
    }
  else
    {
      strncpy(ProgramName, options->ProgramName2[extnr],
	      KIFOPTIONS_FIELD_LENGTH);
    }

  if(DeLocalized(GNOMELNKDIR, options->DefaultMenuEntry,
		 &GNOMELNKPath) == false)
    {
      GNOMELNKPath = GNOMELNKDIR;
      GNOMELNKPath += "/";
      GNOMELNKPath += options->DefaultMenuEntry;
      GNOMELNKPath += "/";
      GNOMELNKPath += ProgramName;
      GNOMELNKPath += ".desktop";
    }
  else
    {
      GNOMELNKPath += "/";
      GNOMELNKPath += ProgramName;
      GNOMELNKPath += ".desktop";
    }

#ifdef _DEBUG_
  char GNOMELNKPath2[FILENAME_MAX];
  qstrncpy(GNOMELNKPath2, GNOMELNKPath, FILENAME_MAX);
  printf("GNOME Entry filename : %s\n", GNOMELNKPath2);
#endif

  GNOMELNKfilename = GNOMELNKPath;

  return(1);
}

int tGNOMEConfig::OpenGNOMELNK()
{
  char GNOMELNKfilename2[FILENAME_MAX];
  /* char command[65535]; */

  qstrncpy(GNOMELNKfilename2, GNOMELNKfilename, FILENAME_MAX);

  mkdir(dirname(GNOMELNKfilename2), 0755);

  /*
  if(GNOMELNKfile == NULL)
    GNOMELNKfile = fopen(GNOMELNKfilename, "r"); else return(2);
  if(GNOMELNKfile != NULL)
    {
      fclose(GNOMELNKfile);
      return(3);
    }
  */

  /*
  strcpy(command, "mkdir -p ");
  _strncat(command, GNOMELNKDIR, 65535);
  _strncat(command, "/Applications", 65535); // for now
  system(command);
  */

  GNOMELNKfile = fopen(GNOMELNKfilename, "w+");
  if(GNOMELNKfile == NULL) return(0);

  return(1);
}

int tGNOMEConfig::WriteGNOMELNK(int extnr)
{
  // char copy;
  char towrite[2048];
  // char* extensionfilename;
  // FILE* extensionfile;
  int err;
  char ProgramName[KIFOPTIONS_FIELD_LENGTH];
  char IconFile[KIFOPTIONS_FIELD_LENGTH];
  char ExecBinary[KIFOPTIONS_FIELD_LENGTH];
  char KDELNKAdditions[KIFOPTIONS_FIELD_LENGTH];

  if(extnr < 0)
    {
      strncpy(ProgramName, options->ProgramName, KIFOPTIONS_FIELD_LENGTH);
      strncpy(IconFile, options->IconFile, KIFOPTIONS_FIELD_LENGTH);
      strncpy(ExecBinary, options->ExecBinary, KIFOPTIONS_FIELD_LENGTH);
      strncpy(KDELNKAdditions, options->KDELNKAdditions,
	      KIFOPTIONS_FIELD_LENGTH);
    }
  else
    {
      strncpy(ProgramName, options->ProgramName2[extnr],
	      KIFOPTIONS_FIELD_LENGTH);
      strncpy(IconFile, options->IconFile2[extnr], KIFOPTIONS_FIELD_LENGTH);
      strncpy(ExecBinary, options->ExecBinary2[extnr],
	      KIFOPTIONS_FIELD_LENGTH);
      strncpy(KDELNKAdditions, options->KDELNKAdditions2[extnr],
	      KIFOPTIONS_FIELD_LENGTH);
    }

  err = 1;

  if(GNOMELNKfile == NULL) /*return(4);*/ return(1);

#ifdef _DEBUG_
#ifndef _SHOW_
  // #define _SHOW_
#endif
#endif

  strcpy(towrite, "[Desktop Entry]");
#ifdef _SHOW_
  printf("gnomeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, GNOMELNKfile);
  err = fputc(EOL, GNOMELNKfile);

  strcpy(towrite, "Type=Application");
#ifdef _SHOW_
  printf("gnomeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, GNOMELNKfile);
  err = fputc(EOL, GNOMELNKfile);

  strcpy(towrite, "Icon=");
#ifdef _SHOW_
  printf("gnomeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, GNOMELNKfile);

  strncpy(towrite, options->DefaultInstallPath, 2048);
  if(options->
     DefaultInstallPath[strlen(options->DefaultInstallPath) - 1] != '/')
    _strncat(towrite, "/", 2048);
  _strncat(towrite, IconFile, 2048);
#ifdef _SHOW_
  printf("gnomeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, GNOMELNKfile);
  err = fputc(EOL, GNOMELNKfile);

  strcpy(towrite, "Exec=");
#ifdef _SHOW_
  printf("gnomeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, GNOMELNKfile);

  strcpy(towrite, options->DefaultInstallPath);
  if(options->
     DefaultInstallPath[strlen(options->DefaultInstallPath) - 1] != '/')
    _strncat(towrite, "/", 2048);
  _strncat(towrite, ExecBinary, 2048);
  _strncat(towrite, " \%f", 2048);
#ifdef _SHOW_
  printf("gnomeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, GNOMELNKfile);
  err = fputc(EOL, GNOMELNKfile);

  strcpy(towrite, "Name=");
#ifdef _SHOW_
  printf("gnomeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, GNOMELNKfile);

  strcpy(towrite, ProgramName);
#ifdef _SHOW_
  printf("gnomeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, GNOMELNKfile);
  err = fputc(EOL, GNOMELNKfile);

  strcpy(towrite, "Path=");
#ifdef _SHOW_
  printf("gnomeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, GNOMELNKfile);

  strcpy(towrite, options->DefaultInstallPath);
#ifdef _SHOW_
  printf("gnomeconfig: Writing %s\n",towrite);
#endif
  err = fputs(towrite, GNOMELNKfile);
  err = fputc(EOL, GNOMELNKfile);

  if(err < 0) /*return(2);*/ return(1);

  // Add custom extensions out of an
  // extension file from the installed distribution

  /*

  if(strlen(KDELNKAdditions) > 0)
    {
      extensionfilename = towrite;
      strcpy(extensionfilename, options->DefaultInstallPath);
      if(options->
        DefaultInstallPath[strlen(options->DefaultInstallPath) - 1] != '/')
      _strncat(extensionfilename, "/", 2048);
      _strncat(extensionfilename, KDELNKAdditions, 2048);

#ifdef _DEBUG_
      printf("gnomeconfig: Adding %s\n", extensionfilename);
#endif

      extensionfile = fopen(extensionfilename, "r");

      if(extensionfile == NULL) return(5);

      while(!feof(extensionfile))
        {
          copy = fgetc(extensionfile);
          err = fputc(copy, GNOMELNKfile);
        }

      if(extensionfile != NULL) fclose(extensionfile);

      if(err < 1) return(2);
    }

  */ // Maybe this will be adapted to GNOME later

  return(1);
}

void tGNOMEConfig::CloseGNOMELNK()
{
  if (!(GNOMELNKfile == NULL)) fclose(GNOMELNKfile);

  GNOMELNKfile = NULL;
}

void tGNOMEConfig::RestartPanel()
{
  // Try to restart the GNOME panel now. No error checking.

  // Does not work yet
}

int tGNOMEConfig::isGNOMEinstalled()
{
  FILE* dummy;
  char dummyfilename[FILENAME_MAX];

  strncpy(dummyfilename, GNOMELNKDIR, FILENAME_MAX);
  _strncat(dummyfilename, "/testdummy", FILENAME_MAX);

  dummy = NULL;
  dummy = fopen(dummyfilename, "w");
  if(dummy == NULL) return(0);

  fclose(dummy);
  remove(dummyfilename);

#ifdef _DEBUG_
  printf("gnomeconfig: GNOME found\n");
#endif

  return(1);
}
