/************************************************************************
 * kinst - KDE Application Installer - gui.h                            *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _GUI_H
#define _GUI_H

#include <stdlib.h>
#include <stdio.h>
#include <libgen.h>

#include <qdialog.h>
#include <qpushbt.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qpixmap.h>
#include <qframe.h>
#include <qstring.h>
#include <qcheckbox.h>
#include <qmessagebox.h>
#include <qwidget.h>

#include <kapp.h>
#include <kmainwindow.h>
#include <kprogress.h>
#include <kfiledialog.h>
#include <krun.h>

#include "locale.h"
#include "install.h"
#include "readfile.h"
#include "kdeconfig.h"
#include "gnomeconfig.h"
#include "scriptrun.h"
#include "libraries.h"
#include "kiss.h"
#include "kmenutree.h"
#include "yesnodlg.h"
#include "rpmdep.h"
#include "stringfunc.h"
#include "../config.h"

class kinstMainWidget:public KMainWindow
{
  Q_OBJECT
private:
  char _KIF_Source_Directory[FILENAME_MAX];
  int StepNr;
  // Main screen
  // -----------
  QPixmap* SetupPicture;
  QLabel* SetupPictureLabel;
  QPushButton* NextButton;
  QPushButton* PreviousButton;
  QPushButton* ExitButton;
  QPushButton* AboutButton;
  QFrame* Separation;
  QFrame* Frame;
  QLabel* TitleLabel;
  QLabel* InfoLabel;
  QLabel* DestFolderLabel;
  QLabel* DestGroupLabel;
  QLineEdit* DestFolderLineEdit;
  QLineEdit* DestGroupLineEdit;
  QPushButton* DestFolderButton;
  QPushButton* DestGroupButton;
  KFileDialog* DestFolderDialog;
  QMultiLineEdit* MultiLineEdit;
  QPushButton* URLViewButton;
  QCheckBox* Install1_check;
  QCheckBox* Install2_check;
  QCheckBox* Install3_check;
  QCheckBox* Install4_check;
  QCheckBox* Install5_check;
  QCheckBox* Install6_check;
  QString DestDir;
  QString DestGroup;
  QRect* r;
  KProgress* ProgressBar;
  KProgress* FileProgress;
  QLabel* ProcessingFile_label;
  tKIFReader* KIFReader;
  tKIFInstall* KIFInstall;
  tKDEConfig* KDEConfig;
  tGNOMEConfig* GNOMEConfig;
  tScriptRun* ScriptRun;
  tInstSharedLibraries *SharedLibs;
  tYesNoDlg* YesNoDlg;
  tKISS* KISS;
  tKMenuTreeDlg* KMenuTreeDlg;
  tRPMDepDlg* RPMDepDlg;

  void newContent(int nr);

private slots:
  void PreviousPressed();
  void NextPressed();
  void AboutPressed();
  void DestFolderButtonPressed();
  void DestGroupButtonPressed();
  void OpenTheURL();
  int StartInstallation();

protected:
  void closeEvent(QCloseEvent *e);
  void resizeEvent(QResizeEvent*);

public:
  void setTotalSteps(int steps);
  void setStatus(int percent, char* text);

  kinstMainWidget();
  int kinstMainWidgetKIFinit(char *infofilename);
};

void setTotalSteps(int steps, void* object);
void setStatus(int percent, char* text, void* object);

#endif


