/************************************************************************
 * kinst - KDE Application Installer - kiss.cpp                         *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <qstring.h>

#include "kiss.h"
#include "stringfunc.h"

#ifndef EOL
#define EOL 10
#endif

#ifndef EXCLUDE_FROM_KISS
#define EXCLUDE_FROM_KISS "KINST_ADDITIONAL"
#endif

#ifndef STD_AUTHOR
#define STD_AUTHOR "unknown"
#endif

tKISS::tKISS(char* SourceFileDir)
{
  options = new tKIFOptions;

  _SourceFileDir = SourceFileDir;
}

tKISS::~tKISS()
{
  delete options;
}

void tKISS::setOptions(tKIFOptions* newoptions)
{
  memcpy(options, newoptions, sizeof(tKIFOptions));
}

int tKISS::AddToKISS(const char* _dirprefix, const char* kdelnkfilename,
		     int extnr)
{
  QString command;
  char tempfilename[FILENAME_MAX];
  char tempfilename2[FILENAME_MAX];
  char readline[65535];
  char shortpackagename[65535];
  char tagfilename[FILENAME_MAX];
  char version[4];
  int err;
  int i;
  int w;
  FILE* tempfile;
  FILE* tempfile2;
  char dirprefix[FILENAME_MAX];

  strncpy(dirprefix, _dirprefix, FILENAME_MAX);

  int VersionMaj;
  int VersionMin;
  int VersionRel;
  char SourceFile[KIFOPTIONS_FIELD_LENGTH];
  char ProgramName[KIFOPTIONS_FIELD_LENGTH];
  char CheckPriorFile[KIFOPTIONS_FIELD_LENGTH];

  if(extnr < 0)
    {
      VersionMaj = options->VersionMaj;
      VersionMin = options->VersionMin;
      VersionRel = options->VersionRel;
      strncpy(SourceFile, options->SourceFile, KIFOPTIONS_FIELD_LENGTH);
      strncpy(ProgramName, options->ProgramName, KIFOPTIONS_FIELD_LENGTH);
      strncpy(CheckPriorFile, options->CheckPriorFile,
	      KIFOPTIONS_FIELD_LENGTH);
    }
  else
    {
      VersionMaj = options->VersionMaj2[extnr];
      VersionMin = options->VersionMin2[extnr];
      VersionRel = options->VersionRel2[extnr];
      strncpy(SourceFile, options->SourceFile2[extnr],
	      KIFOPTIONS_FIELD_LENGTH);
      strncpy(ProgramName, options->ProgramName2[extnr],
	      KIFOPTIONS_FIELD_LENGTH);
      strncpy(CheckPriorFile, options->CheckPriorFile2[extnr],
	      KIFOPTIONS_FIELD_LENGTH);
    }

  // Check for kiss
  err = system("kiss > /dev/null");
  if((err == 127) || (err == -1)) return(0);

  if(strcasecmp(options->SourceFileType, "TGZ") != 0)
    {
#ifdef _DEBUG_
      printf("kiss:  Wrong source file type (%s)\n", options->SourceFileType);
#endif
      return(2);
    }

  tmpnam(tempfilename);
  tmpnam(tempfilename2);

  if(dirprefix[strlen(dirprefix)-1] != '/') strcat(dirprefix, "/");

  command = "tar tfz \"";
  command += _SourceFileDir;
  command += "/";
  command += SourceFile;
  command += "\" > ";
  command += tempfilename;

  err = system(command);

  if((err == 127) || (err == -1)) return(0);

  tempfile = NULL;
  tempfile = fopen(tempfilename, "r");
  if(tempfile == NULL) return(0);

  tempfile2 = NULL;
  tempfile2 = fopen(tempfilename2, "w");
  if(tempfile2 == NULL) return(0);

  fputs("name", tempfile2);
  fputc(EOL, tempfile2);
  fputs(ProgramName, tempfile2);
  fputc(EOL, tempfile2);

  fputs("section", tempfile2);
  fputc(EOL, tempfile2);
  fputs(options->DefaultMenuEntry, tempfile2);
  fputc(EOL, tempfile2);

  fputs("version", tempfile2);
  fputc(EOL, tempfile2);
  sprintf(version, "%i", VersionMaj);
  fputs(version, tempfile2);
  fputs(".", tempfile2);
  sprintf(version, "%i", VersionMin);
  fputs(version, tempfile2);
  fputs(".", tempfile2);
  sprintf(version, "%i", VersionRel);
  fputs(version, tempfile2);
  fputc(EOL, tempfile2);

  fputc(EOL, tempfile2);

  while(!feof(tempfile))
    {
      fgets(readline, 65535, tempfile);
      if(feof(tempfile)) strcpy(readline, "");
      if((strstr(readline, EXCLUDE_FROM_KISS) == NULL)
	 && (strlen(readline) != 0))
	{
	  fputs(dirprefix, tempfile2);
	  fputs(readline, tempfile2);
	  fputc(EOL, tempfile2);
	}
    }

  fputs(kdelnkfilename, tempfile2);
  fputc(EOL, tempfile2);

  // Version Tag
  sprintf(tagfilename, "%s%s.ver.%i.%i.%i", dirprefix,
	  CheckPriorFile, VersionMaj, VersionMin, VersionRel);
  fputs(tagfilename, tempfile2);
  fputc(EOL, tempfile2);

  i = 0;
  w = 0;

  while(ProgramName[i] != 0)
    {
      if(ProgramName[i] != ' ')
	{
	  shortpackagename[w] = ProgramName[i];
	  w++;
	}
      i++;
    }
  shortpackagename[w] = 0;

  command = "kiss -e ";
  command += shortpackagename;
  command += " < ";
  command += tempfilename2;

  if(tempfile != NULL) fclose(tempfile);
  if(tempfile2 != NULL) fclose(tempfile2);

  remove(tempfilename);

  err = system(command);

  remove(tempfilename2);

  if((err == 127) || (err == -1)) return(0);

  return(1);
}

int tKISS::DeleteFromKISS(int extnr)
{
  QString command;
  int i, w, err;
  char shortpackagename[65535];

  // Check for kiss
  err = system("kiss > /dev/null");
  if((err == 127) || (err == -1)) return(0);

  i = 0;
  w = 0;

  if(extnr < 0)
    while(options->ProgramName[i] != 0)
      {
	if(options->ProgramName[i] != ' ')
	  {
	    shortpackagename[w] = options->ProgramName[i];
	    w++;
	  }
	i++;
      }
  else
    while(options->ProgramName2[extnr][i] != 0)
      {
	if(options->ProgramName2[extnr][i] != ' ')
	  {
	    shortpackagename[w] = options->ProgramName2[extnr][i];
	    w++;
	  }
	i++;
      }
  shortpackagename[w] = 0;

  command = "kiss -d ";
  command += shortpackagename;

  char test[65535];
  qstrncpy(test, command, 65535);
  printf("KISS:  Command: %s\n", test);

  err = system(command);

  if((err == 127) || (err == -1)) return(0);

  return(1);
}

