/************************************************************************
 * kinst - KDE Application Installer - kmenutree.h                      *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

/*

Parts of this code are taken from Troll-Tech's dirview Qt example.

*/

#ifndef _KMENUTREE_H
#define _KMENUTREE_H

#include <stdlib.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qlistview.h>
#include <qstring.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qfile.h>

class tKMenuDir: public QListViewItem
{
public:
    tKMenuDir(QListView* parent);
    tKMenuDir(QListView* parent, const char* filename);
    tKMenuDir(tKMenuDir* parent, const char* filename);

    QString text(int column) const;

    QString fullName();

    void setOpen(bool);
    void setup();

    void setBaseDir(QString basedir);

    void dirPath(char* dir, int length);

private:
    bool baseset;
    QString startdir;
    QString dirpath;
    QFile f;
    tKMenuDir *p;
    bool readable;
};

class tKMenuTreeDlg:public QDialog
{
  Q_OBJECT
 private:
  char ChosenMenu[FILENAME_MAX];
  QListView* KMenu;
  tKMenuDir* KMenuDir;
  QLabel* Label;
  QPushButton* ok_button;
  QPushButton* cancel_button;
 private slots:
  void ok_pressed();
  void cancel_pressed();
 protected:
  void resizeEvent(QResizeEvent*);
  void closeEvent(QCloseEvent *e);
 public:
  void getMenuName(char* menuname);
  tKMenuTreeDlg(QWidget *parent, const char *name);
};

#endif


