/************************************************************************
 * kinst - KDE Application Installer - package.cpp                      *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "package.h"
#include "stringfunc.h"

#ifndef KIF_ENTRY
#define KIF_ENTRY 0
#endif

int tKIFPackage::ReadOffsetTable(void)
{
  int i;

  sourcefile = fopen(sourcefilename, "r");
  if(sourcefile == NULL) return(0);

  for(i = 0;i < 10;i++)
    {
      fread(&(tab[i]), sizeof(tab[i]), 1, sourcefile);
      if(tab[i].lastentry == 1) i = 10;
    }

  if(sourcefile != NULL) fclose(sourcefile);
  sourcefile = NULL;

  return(1);
}

int tKIFPackage::UnpackFile(tPosTableEntry entry, char* where)
{
  char c;
  char s[FILENAME_MAX];
  long int i;

  sourcefile = fopen(sourcefilename, "r");
  if(sourcefile == NULL) return(2);

  strncpy(s, where, FILENAME_MAX);
  _strncat(s, "/", FILENAME_MAX);
  _strncat(s, entry.filename, FILENAME_MAX);

#ifdef _DEBUG_
  printf("package: Spawning %s\n", s);
#endif

  destfile = fopen(s, "w");
  if(destfile == NULL) return(3);

  fsetpos(sourcefile, &entry.startoffset);

  for(i = entry.startoffset;i <= entry.endoffset;i++)
    {
      c = fgetc(sourcefile);
      fputc(c, destfile);
    }

  if(sourcefile != NULL) fclose(sourcefile);
  sourcefile = NULL;
  if(destfile != NULL) fclose(destfile);
  destfile = NULL;

  if(entry.executable == 1)
    {
      chmod(s, S_IXUSR);
#ifdef _DEBUG_
      printf("package: Marked %s executable\n", s);
#endif
    }

  return(1);
}

int tKIFPackage::UnpackAllFiles(char* dir)
{
  int i, unp_err;

  unp_err = ReadOffsetTable();

  if(unp_err == 0) return(2);

  for(i = 0;i < 10;i++)
    {
      unp_err = UnpackFile(tab[i], dir);
      if(tab[i].lastentry == 1) i = 10;
      if(unp_err != 1) i = 10;
    }

  return(unp_err);
}

void tKIFPackage::getTempKIF(char* tempKIF)
{
  strncpy(tempKIF, tab[KIF_ENTRY].filename, FILENAME_MAX);
}

tKIFPackage::tKIFPackage(char* package)
{
  strncpy(sourcefilename, package, FILENAME_MAX);

  sourcefile = NULL;
  destfile = NULL;

#ifdef _DEBUG_
  printf("package: PackageFilename: %s\n", sourcefilename);
#endif
}

tKIFPackage::~tKIFPackage()
{
  if(sourcefile != NULL) fclose(sourcefile);
  if(destfile != NULL) fclose(destfile);
}
