/************************************************************************
 * kinst - KDE Application Installer - rpmdep.cpp                       *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <qmessagebox.h>

#include "rpmdep.h"

#include "stringfunc.h"

// Meta Object Compiler code inclusion
#include "rpmdep.moc"

#include "rpmlogo.xpm"

tRPMDepDlg::tRPMDepDlg(QWidget *parent, const char *name)
  : QDialog(parent, name, true)
{
  char tempname[FILENAME_MAX];

  setCaption(_i18n("kinst - RPM dependencies"));
  setMinimumSize(430, 180);

  msg = new QLabel(this);
  msg->setAlignment(AlignVCenter | AlignHCenter);
  RPM = new QLabel(this);
  RPM->setAlignment(AlignVCenter | AlignHCenter);
  Location = new QLabel(this);
  Location->setAlignment(AlignVCenter | AlignHCenter);
  pixmap_label = new QLabel(this);
  pixmap_label->setPixmap(rpmlogo_xpm);
  pixmap_label->setAlignment(AlignVCenter | AlignHCenter);

  OK_button = new QPushButton(this);
  OK_button->setText(_i18n("OK"));
  OK_button->show();
  connect(OK_button, SIGNAL(clicked()), SLOT(OK_Pressed()));

  Cancel_button = new QPushButton(this);
  Cancel_button->setText(_i18n("Cancel"));
  Cancel_button->show();
  connect(Cancel_button, SIGNAL(clicked()), SLOT(Cancel_Pressed()));

  // fileman = new KFM();

  tmpnam(tempname);
  RecentRPMName = tempname;
}

void tRPMDepDlg::setOptions(tKIFOptions par)
{
  memcpy(&params, &par, sizeof(tKIFOptions));
}

void tRPMDepDlg::startCyclus(int extnr)
{
  char i;
  char depcount;

  if(strcasecmp(params.SourceFileType, "RPM") != 0) return;

  nr = extnr;

  actRPM = 0;

  if(nr < 0) depcount = params.RPMDepCount;
  else depcount = params.RPMDepCount2[nr];

  for(i = 0;i < depcount;i++)
    {
      if(nr < 0)
	{
	  if(checkRPM(params.RPMDepName[i]))
	    {
	      msg->setText(_i18n("kinst has detected the existence of needed\nadditional software. However, you may decide to have it\ndownloaded as well."));
	      RPM->setText(params.RPMDepFullName[i]);
	      Location->setText(params.RPMDepLocation[i]);
	    }
	  else
	    {
	      msg->setText(_i18n("This software package needs additional software\nwhich can be downloaded by kinst"));
	      RPM->setText(params.RPMDepFullName[i]);
	      Location->setText(params.RPMDepLocation[i]);
	    }
	}
      if(nr >= 0)
	{
	  if(checkRPM(params.RPMDepName2[nr][i]))
	    {
	      msg->setText(_i18n("kinst has detected the existence of needed\nadditional software. However, you may decide to have it\ndownloaded as well."));
	      RPM->setText(params.RPMDepFullName2[nr][i]);
	      Location->setText(params.RPMDepLocation2[nr][i]);
	    }
	  else
	    {
	      msg->setText(_i18n("This software package needs additional software\nwhich can be downloaded by kinst"));
	      RPM->setText(params.RPMDepFullName2[nr][i]);
	      Location->setText(params.RPMDepLocation2[nr][i]);
	    }
	}
      show();
    }
}

void tRPMDepDlg::resizeEvent(QResizeEvent*)
{
  pixmap_label->setGeometry(10, 10, 65, height()-50);

  msg->setGeometry(pixmap_label->width()+10, 10,
		   width()-pixmap_label->width()-20,
		   height()-110);

  RPM->setGeometry(pixmap_label->width()+10, msg->y()+msg->height(),
		   width()-pixmap_label->width()-20, 25);

  Location->setGeometry(pixmap_label->width()+10, RPM->y()+RPM->height(),
			width()-pixmap_label->width()-20, 25);

  OK_button->setGeometry(10, height()-40,
			 90,
			 30);

  Cancel_button->setGeometry(width()-100,
			     height()-40,
			     90,
			     30);
}

void tRPMDepDlg::OK_Pressed()
{
  int err;

  if(nr < 0) err = downloadRPM(params.RPMDepLocation[actRPM]);
  else err = downloadRPM(params.RPMDepLocation2[actRPM][nr]);

  if(!err) {
    QMessageBox::warning(NULL, _i18n("kinst - RPM dependencies"),
			 _i18n("Error while downloading the desired RPM."));
    hide();
    actRPM++;
    return;
  }

  err = installRPM();

  if(!err) {
    QMessageBox::warning(NULL, _i18n("kinst - RPM dependencies"),
			 _i18n("Error while installing the desired RPM."));
    hide();
    actRPM++;
    return;
  }

  actRPM++;
  hide();
}

void tRPMDepDlg::Cancel_Pressed()
{
  actRPM++;

  hide();
}

int tRPMDepDlg::downloadRPM(char* location)
{
  if(!KIO::NetAccess::download(location, RecentRPMName)) return(0);

  return(1);
}

int tRPMDepDlg::installRPM()
{
  char command[65535];
  FILE* log;

  log = NULL;

  strcpy(command, "rpm -U ");
  _strncat(command, RecentRPMName, 65535);

  log = popen(command, "r");
  if(log == NULL) return(0);

  // Does it say something? Yes -> Error!
  if(fgetc(log) != EOF) { pclose(log); remove(RecentRPMName); return(0); }

  pclose(log);

  remove(RecentRPMName);

  return(1);
}

int tRPMDepDlg::checkRPM(char* name)
{
  char command[65535];
  unsigned long int i;
  FILE* log;

  log = NULL;

  strcpy(command, "rpm -q ");
  _strncat(command, name, 65535);

  log = popen(command, "r");
  if(log == NULL) return(0);

  // Compare output with given name
  for(i = 0;i < strlen(name);i++)
    if(fgetc(log) != name[i]) { pclose(log); return(0); }

  pclose(log);

  return(1);
}

