/************************************************************************
 * kcreateinst - part of kinst package - createdlg.cpp                  *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "createdlg.h"

#ifndef MIN_WIDTH
#define MIN_WIDTH 400
#endif

#ifndef MIN_HEIGHT
#define MIN_HEIGHT 120
#endif

// MOC
#include "createdlg.moc"

kcreateinstCreateDlg::kcreateinstCreateDlg(QWidget *parent, const char *name)
  : QDialog(parent, name, true)
{
  // General properties
  setCaption(_i18n("kcreateinst - Start Creation"));
  resize(MIN_WIDTH, MIN_HEIGHT);
  setMinimumWidth(MIN_WIDTH);
  setMinimumHeight(MIN_HEIGHT);

  // Create FileSelector
  FileSelector = new KFileDialog(getenv("HOME"), "*", this, "FileSelector",
				 true);
  FileSelector->hide();

  // Create params
  origparams = new tParams;
  newparams = new tParams;

  // Create targetfolder_edit
  targetfolder_edit = new QLineEdit(this);
  targetfolder_edit->setText("");
  targetfolder_edit->show();

  // Create cancel_button
  cancel_button = new QPushButton(this);
  cancel_button->setText(_i18n("Cancel"));
  cancel_button->show();
  connect(cancel_button, SIGNAL(clicked()), SLOT(cancel_pressed()));

  // Create START button
  start_button = new QPushButton(this);
  start_button->setText(_i18n("Start"));
  start_button->show();
  connect(start_button, SIGNAL(clicked()), SLOT(start_pressed()));

  // Create targetfolderlabel_label
  targetfolder_label = new QLabel(this);
  targetfolder_label->setText(_i18n("Target Folder"));
  targetfolder_label->show();

  // Create targetfolder_button
  targetfolder_button = new QPushButton(this);
  targetfolder_button->setText(_i18n("Browse"));
  targetfolder_button->show();
  connect(targetfolder_button, SIGNAL(clicked()), SLOT(Browse1Pressed()));

  // Create onefile_check
  onefile_check = new QCheckBox(this);
  onefile_check->setText(_i18n("One-File Package"));
  onefile_check->setChecked(false);
  onefile_check->show();
  connect(onefile_check, SIGNAL(clicked()), SLOT(onefile_clicked()));

  // Create selfextract_check
  selfextract_check = new QCheckBox(this);
  selfextract_check->setText(_i18n("Self-Extracting Installer"));
  selfextract_check->setChecked(false);
  selfextract_check->setEnabled(false);
  selfextract_check->show();
}

void kcreateinstCreateDlg::resizeEvent(QResizeEvent*)
{
  // Resize onefile_check
  onefile_check->setGeometry(10,
			     10,
			     (width()-20)/2,
			     15);

  // Resize selfextract_check
  selfextract_check->setGeometry(onefile_check->x()+onefile_check->width()+
				 10,
				 10,
				 (width()-20)/2,
				 15);

  // Resize targetfolder_label
  targetfolder_label->setGeometry(10,
				  selfextract_check->y()+
				  selfextract_check->height()+10,
				  width()-90,
				  15);

  // Resize targetfolder_edit
  targetfolder_edit->setGeometry(10,
				 targetfolder_label->y()+
				 targetfolder_label->height()+2,
				 width()-90,
				 20);

  // Resize cancel_button
  cancel_button->setGeometry(width()-100,
			     height()-35,
			     90,
			     30);

  // Resize START button
  start_button->setGeometry(10,
			    height()-35,
			    90,
			    30);

  // Resize targetfolder_button
  targetfolder_button->setGeometry(targetfolder_edit->x()+
				   targetfolder_edit->width()+5,
				   targetfolder_edit->y()-2,
				   width()-targetfolder_edit->width()-25,
				   24);
}

void kcreateinstCreateDlg::closeEvent(QCloseEvent *e)
{
  e->ignore();
}

void kcreateinstCreateDlg::getCreatePrefs(tParams* actprefs,
					  int* start_pressed)
{
  origparams->targetpath = actprefs->targetpath;
  newparams->targetpath = actprefs->targetpath;
  origparams->onefilepack = actprefs->onefilepack;
  origparams->selfextracting = actprefs->selfextracting;
  newparams->onefilepack = actprefs->onefilepack;
  newparams->selfextracting = actprefs->selfextracting;

  targetfolder_edit->setText(newparams->targetpath);

  if(newparams->selfextracting)
    {
      onefile_check->setChecked(true);
      selfextract_check->setEnabled(true);
      selfextract_check->setChecked(true);
    }
  else
    {
      selfextract_check->setChecked(false);
      selfextract_check->setEnabled(false);
    }

  if(newparams->onefilepack)
    {
      onefile_check->setChecked(true);
      selfextract_check->setEnabled(true);
    }
  else onefile_check->setChecked(false);

  show();

  actprefs->targetpath = origparams->targetpath;
  actprefs->onefilepack = origparams->onefilepack;
  actprefs->selfextracting = origparams->selfextracting;

  *start_pressed = start_requested;
}

void kcreateinstCreateDlg::Browse1Pressed()
{
  QString String;
  String = FileSelector->getExistingDirectory(getenv("HOME"), this, "");
  if(qstrlen(String) > 0)
    {
      newparams->targetpath = String;
      targetfolder_edit->setText(String);
    }

  FileSelector->hide();
}

void kcreateinstCreateDlg::start_pressed()
{
  newparams->targetpath = targetfolder_edit->text();
  if(onefile_check->isChecked()) newparams->onefilepack = 1;
  else newparams->onefilepack = 0;
  if(selfextract_check->isChecked()) newparams->selfextracting = 1;
  else newparams->selfextracting = 0;

  origparams->targetpath = newparams->targetpath;
  origparams->onefilepack = newparams->onefilepack;
  origparams->selfextracting = newparams->selfextracting;

  start_requested = 1;

  hide();
}

void kcreateinstCreateDlg::cancel_pressed()
{
  start_requested = 0;

  hide();
}

void kcreateinstCreateDlg::onefile_clicked()
{
  if(!onefile_check->isChecked())
    {
      selfextract_check->setChecked(false);
      selfextract_check->setEnabled(false);
    }
  else
    {
      selfextract_check->setEnabled(true);
      selfextract_check->setChecked(false);
    }
}
