/************************************************************************
 * kcreateinst - part of kinst package - createinst.cpp                 *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "createinst.h"

#ifndef KIF_MAGIC
#define KIF_MAGIC "[KDE Install Information]"
#endif

#ifndef EOL
#define EOL 10
#endif

int CreateInstallation(tParams* params)
{
  QString String;
  QString String2;

  QString filename;
  QString KIFrawfilename;

  char cptractpackage[2];

  char cptrversion[4];

  FILE* f;

  int i;
  int w;

  int actpackage;

  char cptrnumoffiles[3];

  String2 = "mkdir -p \"";
  String2 += params->targetpath;
  String2 += "\"";

  if(system(String2) != 0) return(13); // err13 Create targetdir error

  filename = params->targetpath;
  filename += "/";
  filename += params->KIFOptions.ProgramName; /* or something else... */
  filename += ".kif";

  f = 0;
  f = fopen(filename,"w");
  if(f == 0) {
    fprintf(stderr, _i18n("I/O error while opening/creating KIF file\n"));
    return(2); // err2 I/O error while opening/creating KIF file
  }

  /* get kif-file written */

  String = KIF_MAGIC;
  fputs(String, f);
  fputc(EOL, f);

  String = "PROGRAMNAME";
  String += "=";
  String += params->KIFOptions.ProgramName;
  fputs(String, f);
  fputc(EOL, f);

  String = "CHECKPRIORFILE";
  String += "=";
  String += params->KIFOptions.CheckPriorFile;
  fputs(String, f);
  fputc(EOL, f);

  String = "CHECKPRIORRPM";
  String += "=";
  String += params->KIFOptions.CheckPriorRPM;
  fputs(String, f);
  fputc(EOL, f);

  String = "SOURCEFILETYPE";
  String += "=";
  String += params->KIFOptions.SourceFileType;
  fputs(String, f);
  fputc(EOL, f);

  String = params->KIFOptions.SourceFile;
  String2 = "";
  i = qstrlen(String) - 1;
  while(i >= 0) {
    if(String[i] == '/')
      {
	i++;
	for(w = 0;i <= (signed int) qstrlen(String);w++)
	  {
	    String2 += String[i];
	    i++;
	  }
	i = 0;
      }
    i--;
  }
  String = "SOURCEFILE";
  String += "=";
  String += String2;
  fputs(String, f);
  fputc(EOL, f);

  String = params->KIFOptions.ReadMeFile;
  String2 = "";
  i = qstrlen(String) - 1;
  while(i >= 0) {
    if(String[i] == '/')
      {
	i++;
	for(w = 0;i <= (signed int) qstrlen(String);w++)
	  {
	    String2 += String[i];
	    i++;
	  }
	i = 0;
      }
    i--;
  }
  String = "READMEFILE";
  String += "=";
  String += String2;
  fputs(String, f);
  fputc(EOL, f);

  String = params->KIFOptions.GraphicsFile;
  String2 = "";
  i = qstrlen(String) - 1;
  while(i >= 0) {
    if(String[i] == '/')
      {
	i++;
	for(w = 0;i <= (signed int) qstrlen(String);w++)
	  {
	    String2 += String[i];
	    i++;
	  }
	i = 0;
      }
    i--;
  }
  String = "GRAPHICSFILE";
  String += "=";
  String += String2;
  fputs(String, f);
  fputc(EOL, f);

  String = "ICONFILE";
  String += "=";
  String += params->KIFOptions.IconFile;
  fputs(String, f);
  fputc(EOL, f);

  String = "EXECBINARY";
  String += "=";
  String += params->KIFOptions.ExecBinary;
  fputs(String, f);
  fputc(EOL, f);

  String = "KDELNKADDITIONS";
  String += "=";
  String += params->KIFOptions.KDELNKAdditions;
  fputs(String, f);
  fputc(EOL, f);

  String = "DEFAULTINSTALLPATH";
  String += "=";
  String += params->KIFOptions.DefaultInstallPath;
  fputs(String, f);
  fputc(EOL, f);
  
  String = "RELOCATABLEPACKAGE";
  String += "=";
  String += params->KIFOptions.RelocatablePackage;
  fputs(String, f);
  fputc(EOL, f);

  String = "DEFAULTMENUENTRY";
  String += "=";
  String += params->KIFOptions.DefaultMenuEntry;
  fputs(String, f);
  fputc(EOL, f);

  String = params->KIFOptions.PreInstallScript;
  String2 = "";
  i = qstrlen(String) - 1;
  while(i >= 0) {
    if(String[i] == '/')
      {
	i++;
	for(w = 0;i <= (signed int) qstrlen(String);w++)
	  {
	    String2 += String[i];
	    i++;
	  }
	i = 0;
      }
    i--;
  }
  String = "PREINSTALLSCRIPT";
  String += "=";
  String += String2;
  fputs(String, f);
  fputc(EOL, f);

  String = "DONEINSTALLSCRIPT";
  String += "=";
  String += params->KIFOptions.DoneInstallScript;
  fputs(String, f);
  fputc(EOL, f);

  String = "RECOMMENDREBOOT";
  String += "=";
  String += params->KIFOptions.RecommendReboot;
  fputs(String, f);
  fputc(EOL, f);

  String = "LIBRARYDIR";
  String += "=";
  String += params->KIFOptions.LibraryDir;
  fputs(String, f);
  fputc(EOL, f);

  String = "URL";
  String += "=";
  String += params->KIFOptions.URL;
  fputs(String, f);
  fputc(EOL, f);

  String = "VERSIONMAJ";
  String += "=";
  sprintf(cptrversion, "%i", params->KIFOptions.VersionMaj);
  String += cptrversion;
  fputs(String, f);
  fputc(EOL, f);

  String = "VERSIONMIN";
  String += "=";
  sprintf(cptrversion, "%i", params->KIFOptions.VersionMin);
  String += cptrversion;
  fputs(String, f);
  fputc(EOL, f);

  String = "VERSIONREL";
  String += "=";
  sprintf(cptrversion, "%i", params->KIFOptions.VersionRel);
  String += cptrversion;
  fputs(String, f);
  fputc(EOL, f);

  for(actpackage = 0;actpackage < MAX_ADDITIONAL_PACKAGES;actpackage++)
    {
      if(strlen(params->KIFOptions.ProgramName2[actpackage]) > 0)
	{
	  sprintf(cptractpackage, "%i", actpackage + 2);

	  String = "PROGRAMNAME";
	  String += cptractpackage;
	  String += "=";
	  String += params->KIFOptions.ProgramName2[actpackage];
	  fputs(String, f);
	  fputc(EOL, f);

	  String = "CHECKPRIORFILE";
	  String += cptractpackage;
	  String += "=";
	  String += params->KIFOptions.CheckPriorFile2[actpackage];
	  fputs(String, f);
	  fputc(EOL, f);

	  String = "CHECKPRIORRPM";
	  String += cptractpackage;
	  String += "=";
	  String += params->KIFOptions.CheckPriorRPM2[actpackage];
	  fputs(String, f);
	  fputc(EOL, f);

	  String = params->KIFOptions.SourceFile2[actpackage];
	  String2 = "";
	  i = qstrlen(String) - 1;
	  while(i >= 0) {
	    if(String[i] == '/')
	      {
		i++;
		for(w = 0;i <= (signed int) qstrlen(String);w++)
		  {
		    String2 += String[i];
		    i++;
		  }
		i = 0;
	      }
	    i--;
	  }
	  String = "SOURCEFILE";
	  String += cptractpackage;
	  String += "=";
	  String += String2;
	  fputs(String, f);
	  fputc(EOL, f);

	  String = "ICONFILE";
	  String += cptractpackage;
	  String += "=";
	  String += params->KIFOptions.IconFile2[actpackage];
	  fputs(String, f);
	  fputc(EOL, f);

	  String = "EXECBINARY";
	  String += cptractpackage;
	  String += "=";
	  String += params->KIFOptions.ExecBinary2[actpackage];
	  fputs(String, f);
	  fputc(EOL, f);

	  String = "KDELNKADDITIONS";
	  String += cptractpackage;
	  String += "=";
	  String += params->KIFOptions.KDELNKAdditions2[actpackage];
	  fputs(String, f);
	  fputc(EOL, f);

	  String = params->KIFOptions.PreInstallScript2[actpackage];
	  String2 = "";
	  i = qstrlen(String) - 1;
	  while(i >= 0) {
	    if(String[i] == '/')
	      {
		i++;
		for(w = 0;i <= (signed int) qstrlen(String);w++)
		  {
		    String2 += String[i];
		    i++;
		  }
		i = 0;
	      }
	    i--;
	  }
	  String = "PREINSTALLSCRIPT";
	  String += cptractpackage;
	  String += "=";
	  String += String2;
	  fputs(String, f);
	  fputc(EOL, f);

	  String = "DONEINSTALLSCRIPT";
	  String += cptractpackage;
	  String += "=";
	  String += params->KIFOptions.DoneInstallScript2[actpackage];
	  fputs(String, f);
	  fputc(EOL, f);

	  String = "LIBRARYDIR";
	  String += cptractpackage;
	  String += "=";
	  String += params->KIFOptions.LibraryDir2[actpackage];
	  fputs(String, f);
	  fputc(EOL, f);

	  String = "VERSIONMAJ";
	  String += cptractpackage;
	  String += "=";
	  sprintf(cptrversion, "%i",
		  params->KIFOptions.VersionMaj2[actpackage]);
	  String += cptrversion;
	  fputs(String, f);
	  fputc(EOL, f);

	  String = "VERSIONMIN";
	  String += cptractpackage;
	  String += "=";
	  sprintf(cptrversion, "%i",
		  params->KIFOptions.VersionMin2[actpackage]);
	  String += cptrversion;
	  fputs(String, f);
	  fputc(EOL, f);

	  String = "VERSIONREL";
	  String += cptractpackage;
	  String += "=";
	  sprintf(cptrversion, "%i",
		  params->KIFOptions.VersionRel2[actpackage]);
	  String += cptrversion;
	  fputs(String, f);
	  fputc(EOL, f);
	}
    }

  if(f != NULL) 
    if(fclose(f) != 0) printf("Warning: KIF file could not be closed!\n");

  /* collect the files */

  // Get SourceFile
  String2 = "cp \"";
  String2 += params->KIFOptions.SourceFile;
  String2 += "\" \"";
  String2 += params->targetpath;
  String2 += "\"";

  if(system(String2) != 0) return(2); // err3 collect Sourcefile error

  for(actpackage = 0;actpackage < MAX_ADDITIONAL_PACKAGES;actpackage++)
    {
      if(strlen(params->KIFOptions.ProgramName2[actpackage]) > 0)
	{
	  String2 = "cp \"";
	  String2 += params->KIFOptions.SourceFile2[actpackage];
	  String2 += "\" \"";
	  String2 += params->targetpath;
	  String2 += "\"";

	  if(system(String2) != 0) return(2); // err3 collect Sourcefile error
	}
    }

  // Get ReadmeFile
  if(strlen(params->KIFOptions.ReadMeFile) != 0) {
    String2 = "cp \"";
    String2 += params->KIFOptions.ReadMeFile;
    String2 += "\" \"";
    String2 += params->targetpath;
    String2 += "\"";

    if(system(String2) != 0) return(3); // err4 collect ReadMeFile error
  }

  // Get Graphicsfile
  if(strlen(params->KIFOptions.GraphicsFile) != 0) {
    String2 = "cp \"";
    String2 += params->KIFOptions.GraphicsFile;
    String2 += "\" \"";
    String2 += params->targetpath;
    String2 += "\"";

    if(system(String2) != 0) return(4); // err5 collect GraphicsFile error
  }

  // Get PreInstallScript
  if(strlen(params->KIFOptions.PreInstallScript) != 0) {
    String2 = "cp \"";
    String2 += params->KIFOptions.PreInstallScript;
    String2 += "\" \"";
    String2 += params->targetpath;
    String2 += "\"";

    if(system(String2) != 0) return(4); // err6 collect PreInstallScript error
  }

  if(system(String2) != 0) return(2); // err3 collect Sourcefile error

  for(actpackage = 0;actpackage < MAX_ADDITIONAL_PACKAGES;actpackage++)
    {
      if(strlen(params->KIFOptions.ProgramName2[actpackage]) > 0)
	{
	  if(strlen(params->KIFOptions.PreInstallScript2[actpackage]) != 0) {
	    String2 = "cp \"";
	    String2 += params->KIFOptions.PreInstallScript2[actpackage];
	    String2 += "\" \"";
	    String2 += params->targetpath;
	    String2 += "\"";

	    if(system(String2) != 0)
	      return(4); // err6 collect PreInstallScript error
	  }
	}
    }

  if(system(String2) != 0) return(2); // err3 collect Sourcefile error

  // Proceed?
  if(!params->onefilepack) return(1);

  /* The packaging part */

  KIFrawfilename = params->KIFOptions.ProgramName;
  KIFrawfilename += ".kif";

  // Convert everything to filename only format
  String = params->KIFOptions.SourceFile;
  String2 = "";
  i = qstrlen(String) - 1;
  while(i >= 0) {
    if(String[i] == '/')
      {
	i++;
	for(w = 0;i <= (signed int) qstrlen(String);w++)
	  {
	    String2 += String[i];
	    i++;
	  }
	i = 0;
      }
    i--;
  }
  qstrcpy(params->KIFOptions.SourceFile, String2);
  for(actpackage = 0;actpackage < MAX_ADDITIONAL_PACKAGES;actpackage++)
    {
      if(strlen(params->KIFOptions.ProgramName2[actpackage]) > 0)
	{
	  String = params->KIFOptions.SourceFile2[actpackage];
	  String2 = "";
	  i = qstrlen(String) - 1;
	  while(i >= 0) {
	    if(String[i] == '/')
	      {
		i++;
		for(w = 0;i <= (signed int) qstrlen(String);w++)
		  {
		    String2 += String[i];
		    i++;
		  }
		i = 0;
	      }
	    i--;
	  }
	  qstrcpy(params->KIFOptions.SourceFile2[actpackage], String2);
	}
    }

  String = params->KIFOptions.ReadMeFile;
  String2 = "";
  i = qstrlen(String) - 1;
  while(i >= 0) {
    if(String[i] == '/')
      {
	i++;
	for(w = 0;i <= (signed int) qstrlen(String);w++)
	  {
	    String2 += String[i];
	    i++;
	  }
	i = 0;
      }
    i--;
  }
  qstrcpy(params->KIFOptions.ReadMeFile, String2);

  String = params->KIFOptions.GraphicsFile;
  String2 = "";
  i = qstrlen(String) - 1;
  while(i >= 0) {
    if(String[i] == '/')
      {
	i++;
	for(w = 0;i <= (signed int) qstrlen(String);w++)
	  {
	    String2 += String[i];
	    i++;
	  }
	i = 0;
      }
    i--;
  }
  qstrcpy(params->KIFOptions.GraphicsFile, String2);

  String = params->KIFOptions.PreInstallScript;
  String2 = "";
  i = qstrlen(String) - 1;
  while(i >= 0) {
    if(String[i] == '/')
      {
	i++;
	for(w = 0;i <= (signed int) qstrlen(String);w++)
	  {
	    String2 += String[i];
	    i++;
	  }
	i = 0;
      }
    i--;
  }
  qstrcpy(params->KIFOptions.PreInstallScript, String2);
  for(actpackage = 0;actpackage < MAX_ADDITIONAL_PACKAGES;actpackage++)
    {
      if(strlen(params->KIFOptions.ProgramName2[actpackage]) > 0)
	{
	  String = params->KIFOptions.PreInstallScript2[actpackage];
	  String2 = "";
	  i = qstrlen(String) - 1;
	  while(i >= 0) {
	    if(String[i] == '/')
	      {
		i++;
		for(w = 0;i <= (signed int) qstrlen(String);w++)
		  {
		    String2 += String[i];
		    i++;
		  }
		i = 0;
	      }
	    i--;
	  }
	  qstrcpy(params->KIFOptions.PreInstallScript2[actpackage], String2);
	}
    }

  i = 0;

  String = params->kipackpath;
  String += " ";
  String += "\"";
  String += params->KIFOptions.ProgramName;
  String += ".kip";
  String += "\"";
  String += " ";

  if(qstrlen(KIFrawfilename) > 0) i++;
  if(qstrlen(params->KIFOptions.SourceFile) > 0) i++;
  for(actpackage = 0;actpackage < MAX_ADDITIONAL_PACKAGES;actpackage++)
    {
      if(strlen(params->KIFOptions.ProgramName2[actpackage]) > 0)
	  if(qstrlen(params->KIFOptions.SourceFile2[actpackage]) > 0) i++;
    }
  if(qstrlen(params->KIFOptions.GraphicsFile) > 0) i++;
  if(qstrlen(params->KIFOptions.ReadMeFile) > 0) i++;
  if(qstrlen(params->KIFOptions.PreInstallScript) > 0) i++;
  for(actpackage = 0;actpackage < MAX_ADDITIONAL_PACKAGES;actpackage++)
    {
      if(strlen(params->KIFOptions.PreInstallScript2[actpackage]) > 0)
	  if(qstrlen(params->KIFOptions.PreInstallScript2[actpackage]) > 0)
	    i++;
    }

  sprintf(cptrnumoffiles, "%i", i);
  String += cptrnumoffiles;
  String += " ";

  if(qstrlen(KIFrawfilename) > 0)
    {
      String += "\"";
      String += KIFrawfilename;
      String += "\" 0 ";
    }
  if(qstrlen(params->KIFOptions.SourceFile) > 0)
    {
      String += "\"";
      String += params->KIFOptions.SourceFile;
      String += "\" 0 ";
    }
  for(actpackage = 0;actpackage < MAX_ADDITIONAL_PACKAGES;actpackage++)
    {
      if(strlen(params->KIFOptions.SourceFile2[actpackage]) > 0)
	  if(qstrlen(params->KIFOptions.SourceFile2[actpackage]) > 0)
	    {
	      String += "\"";
	      String += params->KIFOptions.SourceFile2[actpackage];
	      String += "\" 0 ";
	    }
    }
  if(strlen(params->KIFOptions.GraphicsFile) > 0)
    {
      String += "\"";
      String += params->KIFOptions.GraphicsFile;
      String += "\" 0 ";
    }
  if(strlen(params->KIFOptions.ReadMeFile) > 0)
    {
      String += "\"";
      String += params->KIFOptions.ReadMeFile;
      String += "\" 0 ";
    }
  if(strlen(params->KIFOptions.PreInstallScript) > 0)
    {
      String += "\"";
      String += params->KIFOptions.PreInstallScript;
      String += "\" 1 ";
    }
  for(actpackage = 0;actpackage < MAX_ADDITIONAL_PACKAGES;actpackage++)
    {
      if(strlen(params->KIFOptions.PreInstallScript2[actpackage]) > 0)
	  if(qstrlen(params->KIFOptions.PreInstallScript2[actpackage]) > 0)
	    {
	      String += "\"";
	      String += params->KIFOptions.PreInstallScript2[actpackage];
	      String += "\" 0 ";
	    }
    }

  chdir(params->targetpath);

  if(system(String) != 0) return(7); // err7 Packing to one file error

  /* Get the GMOs */
  String = "cp -f ";
  String += params->kinstlocalepath;
  String += "/*.gmo .";

  if(system(String) != 0) return(8); // err8 Collecting locale error

  /* Get kinst */
  String = "cp -f \"";
  String += params->kinstpath;
  String += "\" .";

  if(system(String) != 0) return(9); // err9 Collecting kinst error

  /* Ready the kip file */
  String = "mv -f \"";
  String += params->KIFOptions.ProgramName;
  String += ".kip\" package.kip";

  if(system(String) != 0) return(10); // err10 Prepare kip file error

  // Proceed?
  if(!params->selfextracting) return(1);

  /* use kiselfextract */
  String = params->selfextractpath;
  String += " -p *.gmo package.kip kinst > \"";
  String += params->KIFOptions.ProgramName;
  String += ".setupexe\"";

  if(system(String) != 0) return(11); // err11 Creating sfx installer error

  /* Make it executable */
  String = "chmod a+x \"";
  String += params->KIFOptions.ProgramName;
  String += ".setupexe\"";

  if(system(String) != 0) return(12); // err12 Mark installer executable error

  return(1);
}
