/************************************************************************
 * kcreateinst - part of kinst package - dirview.cpp                    *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

/*

Parts of this code are taken from Troll-Tech's dirview Qt example.

*/

#include "dirview.h"

kcreateinstDirectory::kcreateinstDirectory(kcreateinstDirectory* parent,
					   const char* filename)
  : QListViewItem(parent), f(filename)
{
  p = parent;
  readable = TRUE;
  baseset = false;

  dirpath = fullName();
}


kcreateinstDirectory::kcreateinstDirectory(QListView* parent)
  : QListViewItem(parent), f("/")
{
  p = 0;
  readable = TRUE;
  baseset = false;
  startdir = "";
}

kcreateinstDirectory::kcreateinstDirectory(QListView* parent,
					   const char* filename)
  : QListViewItem(parent), f(filename)
{
  p = 0;
  readable = TRUE;
  baseset = false;
  startdir = "";
}

void kcreateinstDirectory::setOpen(bool o)
{
  if ( o && !childCount() ) {
	QString s( fullName() );
	if(baseset) s = startdir;
	QDir thisDir( s );
	dirpath = s;
	if ( !thisDir.isReadable() ) {
	    readable = FALSE;
	    return;
	}

	const QFileInfoList * files = thisDir.entryInfoList();
	if ( files ) {
	    QFileInfoListIterator it( *files );
	    QFileInfo * f;
	    while( (f=it.current()) != 0 ) {
		++it;
		if ( f->fileName() == "." || f->fileName() == ".." )
		    ; // nothing
		else if ( f->isSymLink() )
		    new QListViewItem( this, (const char *)f->fileName(),
				       f->absFilePath(), 0 );
		else if ( f->isDir() )
		    new kcreateinstDirectory( this, f->fileName() );
		else
		    new QListViewItem( this, (const char *)f->fileName(),
				       f->absFilePath(), 0 );
	    }
	}
    }
    QListViewItem::setOpen( o );
}

void kcreateinstDirectory::setup()
{
    setExpandable(TRUE);
    QListViewItem::setup();
}

void kcreateinstDirectory::setBaseDir(QString basedir)
{
  baseset = true;
  startdir = basedir;
}

void kcreateinstDirectory::dirPath(char* dir, int length)
{
  qstrncpy(dir, dirpath, length);
}

QString kcreateinstDirectory::fullName()
{
    QString s;
    if ( p ) {
	s = p->fullName();
	s.append( f.name() );
	s.append( "/" );
    } else {
	s = startdir + "/";
    }
    return s;
}

QString kcreateinstDirectory::text(int column) const
{
  if ( column == 0 )
    return f.name();
  else if ( readable )
    return "Directory";
  else
    return "Unreadable Directory";
}
