/************************************************************************
 * kcreateinst - part of kinst package - multipack.cpp                  *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "multipack.h"

#ifndef MIN_WIDTH
#define MIN_WIDTH 520
#endif

#ifndef MIN_HEIGHT
#define MIN_HEIGHT 500
#endif

#ifndef EOL
#define EOL 10
#endif

// MOC
#include "multipack.moc"

tMultiPackDlg::tMultiPackDlg(QWidget *parent, const char *name)
  : QDialog(parent, name, true)
{

#include "start.xpm"

  // General properties
  setCaption(_i18n("kcreateinst - MultiPackage"));
  resize(MIN_WIDTH, MIN_HEIGHT);
  setMinimumWidth(MIN_WIDTH);
  setMinimumHeight(MIN_HEIGHT);

  // Create params
  params = new tParams();
  origparams = new tParams();

  // Create Pixmaps
  QPixmap start_picture(start_xpm);

  // Create Separation
  Separation = new QFrame(this);
  Separation->setFrameStyle(QFrame::VLine|QFrame::Sunken);
  Separation->show();

  // Create Separation2
  Separation2 = new QFrame(this);
  Separation2->setFrameStyle(QFrame::HLine|QFrame::Sunken);
  Separation2->show();

  // Create actpackage_frame
  actpackage_frame = new QFrame(this);
  actpackage_frame->setFrameStyle(QFrame::Sunken|QFrame::Box);
  actpackage_frame->show();

  // Create actpackage_lcd
  actpackage_lcd = new QLCDNumber(this);
  actpackage_lcd->setNumDigits(1);
  actpackage_lcd->display(1);
  actpackage_lcd->show();

  QFont font;
  font.setBold(true);
  font.setPointSize(15);

  // Create programname_label
  programname_label = new QLabel(this);
  programname_label->setText(_i18n("Program Name"));
  programname_label->setFont(font);
  programname_label->setAlignment(AlignCenter);
  programname_label->show();

  // Create sourcefilename_label
  sourcefilename_label = new QLabel(this);
  sourcefilename_label->setText(_i18n("Source File Package"));
  sourcefilename_label->show();

  // Create checkpriorfile_label
  checkpriorfile_label = new QLabel(this);
  checkpriorfile_label->setText(_i18n("Prev. installation detection by file"));
  checkpriorfile_label->show();

  // Create checkpriorrpm_label
  checkpriorrpm_label = new QLabel(this);
  checkpriorrpm_label->setText(_i18n("Prev. installation detection by RPM"));
  checkpriorrpm_label->show();

  // Create iconfile_label
  iconfile_label = new QLabel(this);
  iconfile_label->setText(_i18n("Icon"));
  iconfile_label->show();

  // Create execbinary_label
  execbinary_label = new QLabel(this);
  execbinary_label->setText(_i18n("Executable"));
  execbinary_label->show();

  // Create kdelnkadditions_label
  kdelnkadditions_label = new QLabel(this);
  kdelnkadditions_label->setText(_i18n("KDELNK Additions"));
  kdelnkadditions_label->show();

  // Create preinstallscript_label
  preinstallscript_label = new QLabel(this);
  preinstallscript_label->setText(_i18n("Pre-Install Script"));
  preinstallscript_label->show();

  // Create doneinstallscript_label
  doneinstallscript_label = new QLabel(this);
  doneinstallscript_label->setText(_i18n("Done Install Script"));
  doneinstallscript_label->show();

  // Create librarydir_label
  librarydir_label = new QLabel(this);
  librarydir_label->setText(_i18n("Shared Libraries Dir"));
  librarydir_label->show();

  // Create version_label
  version_label = new QLabel(this);
  version_label->setText(_i18n("Version"));
  version_label->setFont(font);
  version_label->setAlignment(AlignCenter);
  version_label->show();

  // Create programname_edit
  programname_edit = new QLineEdit(this);
  programname_edit->clear();
  programname_edit->show();

  // Create sourcefilename_edit
  sourcefilename_edit = new QLineEdit(this);
  sourcefilename_edit->clear();
  sourcefilename_edit->show();

  // Create checkpriorfile_edit
  checkpriorfile_edit = new QLineEdit(this);
  checkpriorfile_edit->clear();
  checkpriorfile_edit->show();

  // Create checkpriorrpm_edit
  checkpriorrpm_edit = new QLineEdit(this);
  checkpriorrpm_edit->clear();
  checkpriorrpm_edit->show();

  // Create iconfile_edit
  iconfile_edit = new QLineEdit(this);
  iconfile_edit->clear();
  iconfile_edit->show();

  // Create execbinary_edit
  execbinary_edit = new QLineEdit(this);
  execbinary_edit->clear();
  execbinary_edit->show();

  // Create kdelnkadditions_edit
  kdelnkadditions_edit = new QLineEdit(this);
  kdelnkadditions_edit->clear();
  kdelnkadditions_edit->show();

  // Create preinstallscript_edit
  preinstallscript_edit = new QLineEdit(this);
  preinstallscript_edit->clear();
  preinstallscript_edit->show();

  // Create doneinstallscript_edit
  doneinstallscript_edit = new QLineEdit(this);
  doneinstallscript_edit->clear();
  doneinstallscript_edit->show();

  // Create librarydir_edit
  librarydir_edit = new QLineEdit(this);
  librarydir_edit->clear();
  librarydir_edit->show();

  // Create input validator
  versionval = new QIntValidator(this);
  versionval->setRange(0, 127);

  // Create versionmaj_edit
  versionmaj_edit = new QLineEdit(this);
  versionmaj_edit->clear();
  versionmaj_edit->setValidator(versionval);
  versionmaj_edit->setMaxLength(3);
  versionmaj_edit->show();

  // Create versionmin_edit
  versionmin_edit = new QLineEdit(this);
  versionmin_edit->clear();
  versionmin_edit->setValidator(versionval);
  versionmin_edit->setMaxLength(3);
  versionmin_edit->show();

  // Create versionrel_edit
  versionrel_edit = new QLineEdit(this);
  versionrel_edit->clear();
  versionrel_edit->setValidator(versionval);
  versionrel_edit->setMaxLength(3);
  versionrel_edit->show();

  // Create sourcefilename_button
  sourcefilename_button = new QPushButton(this);
  sourcefilename_button->setText(_i18n("Browse"));
  sourcefilename_button->show();
  connect(sourcefilename_button, SIGNAL(clicked()), SLOT(Browse1Pressed()));

  // Create preinstallscript_button
  preinstallscript_button = new QPushButton(this);
  preinstallscript_button->setText(_i18n("Browse"));
  preinstallscript_button->show();
  connect(preinstallscript_button, SIGNAL(clicked()), SLOT(Browse2Pressed()));

  // Create iconfile_button
  iconfile_button = new QPushButton(this);
  iconfile_button->setText(_i18n("Browse"));
  iconfile_button->show();
  connect(iconfile_button, SIGNAL(clicked()), SLOT(Browse5Pressed()));

  // Create execbinary_button
  execbinary_button = new QPushButton(this);
  execbinary_button->setText(_i18n("Browse"));
  execbinary_button->show();
  connect(execbinary_button, SIGNAL(clicked()), SLOT(Browse3Pressed()));

  // Create kdelnkadditions_button
  kdelnkadditions_button = new QPushButton(this);
  kdelnkadditions_button->setText(_i18n("Browse"));
  kdelnkadditions_button->show();
  connect(kdelnkadditions_button, SIGNAL(clicked()), SLOT(Browse6Pressed()));

  // Create doneinstallscript_button
  doneinstallscript_button = new QPushButton(this);
  doneinstallscript_button->setText(_i18n("Browse"));
  doneinstallscript_button->show();
  connect(doneinstallscript_button, SIGNAL(clicked()), SLOT(Browse4Pressed()));

  // Create librarydir_button
  librarydir_button = new QPushButton(this);
  librarydir_button->setText(_i18n("Browse"));
  librarydir_button->show();
  connect(librarydir_button, SIGNAL(clicked()), SLOT(Browse7Pressed()));

  // Create compose_button
  compose_button = new QPushButton(this);
  compose_button->setPixmap(start_picture);
  compose_button->show();
  connect(compose_button, SIGNAL(clicked()), SLOT(compose_pressed()));

  // Create next_button
  next_button = new QPushButton(this);
  next_button->setText(_i18n("Next >>"));
  next_button->show();
  connect(next_button, SIGNAL(clicked()), SLOT(next_pressed()));

  // Create out_label
  out_label = new QLabel(this);
  out_label->setText(_i18n("Outside your package"));
  out_label->setFont(font);
  out_label->setAlignment(AlignCenter);
  out_label->show();

  // Create in_label
  in_label = new QLabel(this);
  in_label->setText(_i18n("Inside your package"));
  in_label->setFont(font);
  in_label->setAlignment(AlignCenter);
  in_label->show();

  // Create back_button
  back_button = new QPushButton(this);
  back_button->setText(_i18n("<< Back"));
  back_button->show();
  connect(back_button, SIGNAL(clicked()), SLOT(back_pressed()));

  // Create cancel_button
  cancel_button = new QPushButton(this);
  cancel_button->setText(_i18n("Cancel"));
  cancel_button->show();
  connect(cancel_button, SIGNAL(clicked()), SLOT(cancel_pressed()));

  // Create ok button
  ok_button = new QPushButton(this);
  ok_button->setText(_i18n("OK"));
  ok_button->show();
  connect(ok_button, SIGNAL(clicked()), SLOT(ok_pressed()));

  // Create Help button
  help_button = new QPushButton(this);
  help_button->setText(_i18n("Help"));
  help_button->show();
  connect(help_button, SIGNAL(clicked()), SLOT(help_pressed()));

  // Create File Selection Dialog
  FileSelector = new KFileDialog(getenv("HOME"), "*", this, "FileSelector",
				 false);
  FileSelector->hide();

  // Create TGZViewer Dialog
  TGZViewer = new tTGZViewDlg(this, "TGZViewer");
  TGZViewer->hide();

  actpackage = 0;
}

void tMultiPackDlg::resizeEvent(QResizeEvent*)
{
  // Resize Separation
  Separation->setGeometry(width()/2,
			  10,
			  3,
			  height()-150);

  // Resize Separation2
  Separation2->setGeometry(10,
			   Separation->y()+Separation->height()+5,
			   width()-20,
			   3);

  // Resize actpackage_frame
  actpackage_frame->setGeometry(Separation2->x(),
				Separation2->y()+Separation2->height()+5,
				180,
				height()-Separation2->y()-50);

  // Resize actpackage_lcd
  actpackage_lcd->setGeometry(actpackage_frame->x()+5,
			      actpackage_frame->y()+5,
			      actpackage_frame->width()-10,
			      actpackage_frame->height()-45);

  // Resize back_button
  back_button->setGeometry(actpackage_frame->x()+5,
			   actpackage_lcd->y()+actpackage_lcd->height()+5,
			   (actpackage_frame->width()-10)/2,
			   actpackage_frame->height()-actpackage_lcd->height()-
			   15);

  // Resize next_button
  next_button->setGeometry(back_button->x()+back_button->width(),
			   actpackage_lcd->y()+actpackage_lcd->height()+5,
			   (actpackage_frame->width()-10)/2,
			   actpackage_frame->height()-actpackage_lcd->height()-
			   15);

  // Resize programname_label
  programname_label->setGeometry(actpackage_frame->x()+
				 actpackage_frame->width()+10,
				 actpackage_frame->y()+5,
				 width()-actpackage_frame->width()-150,
				 20);

  // Resize programname_edit
  programname_edit->setGeometry(programname_label->x(),
				programname_label->y()+
				programname_label->height()+15,
				width()-actpackage_frame->width()-150,
				20);

  // Resize version_label
  version_label->setGeometry(programname_label->x()+
			     programname_label->width()+5,
			     programname_label->y(),
			     width()-actpackage_frame->width()-
			     programname_label->width()-30,
			     20);

  // Resize versionmaj_edit
  versionmaj_edit->setGeometry(version_label->x(),
			       programname_edit->y(),
			       (version_label->width()-15)/3,
			       20);

  // Resize versionmin_edit
  versionmin_edit->setGeometry(versionmaj_edit->x()+versionmaj_edit->width()+5,
			       programname_edit->y(),
			       (version_label->width()-15)/3,
			       20);

  // Resize versionrel_edit
  versionrel_edit->setGeometry(versionmin_edit->x()+versionmin_edit->width()+5,
			       programname_edit->y(),
			       (version_label->width()-15)/3,
			       20);

  // Resize out_label
  out_label->setGeometry(10,
			 10,
			 width()-Separation->x()-20,
			 20);

  // Resize in_label
  in_label->setGeometry(Separation->x()+10,
			10,
			width()-Separation->x()-20,
			20);

  // Resize sourcefilename_label
  sourcefilename_label->setGeometry(10,
				    out_label->y()+out_label->height()+10,
				    width()-Separation->x()-15,
				    15);

  // Resize sourcefilename_edit
  sourcefilename_edit->setGeometry(10,
				   sourcefilename_label->y()+
				   sourcefilename_label->height()+
				   2,
				   width()-Separation->x()-110,
				   20);

  // Resize sourcefilename_button
  sourcefilename_button->setGeometry(sourcefilename_edit->x()+
				     sourcefilename_edit->width()+5,
				     sourcefilename_edit->y()-2,
				     60,
				     24);

  // Resize checkpriorfile_label
  checkpriorfile_label->setGeometry(10,
				    sourcefilename_edit->y()+
				    sourcefilename_edit->height()+10,
				    width()-Separation->x()-15,
				    15);

  // Resize checkpriorfile_edit
  checkpriorfile_edit->setGeometry(10,
				   checkpriorfile_label->y()+
				   checkpriorfile_label->height()+2,
				   width()-Separation->x()-15,
				   20);

  // Resize checkpriorrpm_label
  checkpriorrpm_label->setGeometry(10,
				   checkpriorfile_edit->y()+
				   checkpriorfile_edit->height()+10,
				   width()-Separation->x()-15,
				   15);

  // Resize checkpriorrpm_edit
  checkpriorrpm_edit->setGeometry(10,
				  checkpriorrpm_label->y()+
				  checkpriorrpm_label->height()+2,
				  width()-Separation->x()-15,
				  20);

  // Resize preinstallscript_label
  preinstallscript_label->setGeometry(10,
				      checkpriorrpm_edit->y()+
				      checkpriorrpm_edit->height()+10,
				      width()-Separation->x()-15,
				      15);

  // Resize preinstallscript_edit
  preinstallscript_edit->setGeometry(10,
				     preinstallscript_label->y()+
				     preinstallscript_label->height()+2,
				     width()-Separation->x()-80,
				     20);

  // Resize preinstallscript_button
  preinstallscript_button->setGeometry(preinstallscript_edit->x()+
				       preinstallscript_edit->width()+5,
				       preinstallscript_edit->y()-2,
				       60,
				       24);

  // Resize execbinary_label
  execbinary_label->setGeometry(Separation->x()+5,
				in_label->y()+in_label->height()+10,
				width()-Separation->x()-15,
				15);

  // Resize execbinary_edit
  execbinary_edit->setGeometry(execbinary_label->x(),
			       execbinary_label->y()+
			       execbinary_label->height()+2,
			       width()-Separation->x()-80,
			       20);

  // Resize execbinary_button
  execbinary_button->setGeometry(execbinary_edit->x()+
				 execbinary_edit->width()+5,
				 execbinary_edit->y()-2,
				 60,
				 24);

  // Resize doneinstallscript_label
  doneinstallscript_label->setGeometry(Separation->x()+5,
				       execbinary_edit->y()+
				       execbinary_edit->height()+10,
				       width()-Separation->x()-15,
				       15);

  // Resize doneinstallscript_edit
  doneinstallscript_edit->setGeometry(doneinstallscript_label->x(),
				      doneinstallscript_label->y()+
				      doneinstallscript_label->height()+2,
				      width()-Separation->x()-80,
				      20);

  // Resize doneinstallscript_button
  doneinstallscript_button->setGeometry(doneinstallscript_edit->x()+
					doneinstallscript_edit->width()+5,
					doneinstallscript_edit->y()-2,
					60,
					24);

  // Resize iconfile_label
  iconfile_label->setGeometry(Separation->x()+5,
			      doneinstallscript_edit->y()+
			      doneinstallscript_edit->height()+10,
			      width()-Separation->x()-15,
			      15);

  // Resize iconfile_edit
  iconfile_edit->setGeometry(iconfile_label->x(),
			     iconfile_label->y()+
			     iconfile_label->height()+2,
			     width()-Separation->x()-80,
			     20);

  // Resize iconfile_button
  iconfile_button->setGeometry(iconfile_edit->x()+
			       iconfile_edit->width()+5,
			       iconfile_edit->y()-2,
			       60,
			       24);

  // Resize kdelnkadditions_label
  kdelnkadditions_label->setGeometry(Separation->x()+5,
				     iconfile_edit->y()+
				     iconfile_edit->height()+10,
				     width()-Separation->x()-15,
				     15);

  // Resize kdelnkadditions_edit
  kdelnkadditions_edit->setGeometry(kdelnkadditions_label->x(),
				    kdelnkadditions_label->y()+
				    kdelnkadditions_label->height()+2,
				    width()-Separation->x()-80,
				    20);

  // Resize kdelnkadditions_button
  kdelnkadditions_button->setGeometry(kdelnkadditions_edit->x()+
				      kdelnkadditions_edit->width()+5,
				      kdelnkadditions_edit->y()-2,
				      60,
				      24);

  // Resize librarydir_label
  librarydir_label->setGeometry(Separation->x()+5,
				kdelnkadditions_edit->y()+
				kdelnkadditions_edit->height()+10,
				width()-Separation->x()-15,
				15);

  // Resize librarydir_edit
  librarydir_edit->setGeometry(librarydir_label->x(),
			       librarydir_label->y()+
			       librarydir_label->height()+2,
			       width()-Separation->x()-80,
			       20);

  // Resize librarydir_button
  librarydir_button->setGeometry(librarydir_edit->x()+
				 librarydir_edit->width()+5,
				 librarydir_edit->y()-2,
				 60,
				 24);

  // Resize compose_button
  compose_button->setGeometry(sourcefilename_button->x()+
			      sourcefilename_button->width()+5,
			      sourcefilename_edit->y()-2,
			      25,
			      24);

  // Resize OK button
  ok_button->setGeometry(10,
			 height()-35,
			 90,
			 30);

  // Resize help_button
  help_button->setGeometry(width()-100,
			   height()-35,
			   90,
			   30);

  // Resize cancel_button
  cancel_button->setGeometry((width()/2)-45,
			     height()-35,
			     90,
			     30);
}

void tMultiPackDlg::closeEvent(QCloseEvent *e)
{
  e->ignore();
}

void tMultiPackDlg::Browse1Pressed()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", this,
					 _i18n("Choose a file"));
  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.SourceFile2[actpackage], String, 1024);
      sourcefilename_edit->setText(String);
    }

  FileSelector->hide();
}

void tMultiPackDlg::Browse2Pressed()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", this,
					 _i18n("Choose a file"));
  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.PreInstallScript2[actpackage], String, 1024);
      preinstallscript_edit->setText(String);
    }

  FileSelector->hide();
}

void tMultiPackDlg::Browse3Pressed()
{
  QString String;
  String = TGZViewer->getFilePath(sourcefilename_edit->text());

  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.ExecBinary2[actpackage], String, 1024);
      execbinary_edit->setText(String);
    }

  TGZViewer->hide();
}

void tMultiPackDlg::Browse4Pressed()
{
  QString String;
  String = TGZViewer->getFilePath(sourcefilename_edit->text());

  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.DoneInstallScript2[actpackage],
	       String, 1024);
      doneinstallscript_edit->setText(String);
    }

  TGZViewer->hide();
}

void tMultiPackDlg::Browse5Pressed()
{
  QString String;
  String = TGZViewer->getFilePath(sourcefilename_edit->text());

  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.IconFile2[actpackage], String, 1024);
      iconfile_edit->setText(String);
    }

  TGZViewer->hide();
}

void tMultiPackDlg::Browse6Pressed()
{
  QString String;
  String = TGZViewer->getFilePath(sourcefilename_edit->text());

  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.KDELNKAdditions2[actpackage], String, 1024);
      kdelnkadditions_edit->setText(String);
    }

  TGZViewer->hide();
}

void tMultiPackDlg::Browse7Pressed()
{
  QString String;
  String = TGZViewer->getFilePath(sourcefilename_edit->text());

  if(qstrlen(String) > 0)
    {
      qstrncpy(params->KIFOptions.LibraryDir2[actpackage], String, 1024);
      librarydir_edit->setText(String);
    }

  TGZViewer->hide();
}

void tMultiPackDlg::compose_pressed()
{
  QString newTGZ;

  // Create TGZComposeDlg
  TGZComposeDlg = new tTGZComposeDlg(this, "TGZComposeDlg");
  TGZComposeDlg->hide();

  newTGZ = TGZComposeDlg->ComposeTGZ();

  delete TGZComposeDlg;

  if(qstrlen(newTGZ) > 0)
    {
      sourcefilename_edit->setText(newTGZ);
      qstrncpy(params->KIFOptions.SourceFile2[actpackage], newTGZ, 1024);
    }
}

void tMultiPackDlg::next_pressed()
{
  char cptr_version[4];

  strncpy(params->KIFOptions.ProgramName2[actpackage],
	  programname_edit->text(), 1024);
  strncpy(params->KIFOptions.CheckPriorFile2[actpackage],
	  checkpriorfile_edit->text(), 1024);
  strncpy(params->KIFOptions.CheckPriorRPM2[actpackage],
	  checkpriorrpm_edit->text(), 1024);
  strncpy(params->KIFOptions.SourceFile2[actpackage],
	  sourcefilename_edit->text(), 1024);
  strncpy(params->KIFOptions.IconFile2[actpackage],
	  iconfile_edit->text(), 1024);
  strncpy(params->KIFOptions.ExecBinary2[actpackage],
	  execbinary_edit->text(), 1024);
  strncpy(params->KIFOptions.KDELNKAdditions2[actpackage],
	  kdelnkadditions_edit->text(), 1024);
  strncpy(params->KIFOptions.PreInstallScript2[actpackage],
	  preinstallscript_edit->text(), 1024);
  strncpy(params->KIFOptions.DoneInstallScript2[actpackage],
	  doneinstallscript_edit->text(), 1024);
  strncpy(params->KIFOptions.LibraryDir2[actpackage],
	  librarydir_edit->text(), 1024);
  params->KIFOptions.VersionMaj2[actpackage] =
    atoi(versionmaj_edit->text());
  params->KIFOptions.VersionMin2[actpackage] =
    atoi(versionmin_edit->text());
  params->KIFOptions.VersionRel2[actpackage] =
    atoi(versionrel_edit->text());

  if(actpackage < MAX_ADDITIONAL_PACKAGES - 1)
    actpackage++;

  actpackage_lcd->display(actpackage + 1);

  programname_edit->setText(params->KIFOptions.ProgramName2[actpackage]);
  checkpriorfile_edit->setText(params->KIFOptions.CheckPriorFile2[actpackage]);
  checkpriorrpm_edit->setText(params->KIFOptions.CheckPriorRPM2[actpackage]);
  sourcefilename_edit->setText(params->KIFOptions.SourceFile2[actpackage]);
  iconfile_edit->setText(params->KIFOptions.IconFile2[actpackage]);
  execbinary_edit->setText(params->KIFOptions.ExecBinary2[actpackage]);
  kdelnkadditions_edit->
    setText(params->KIFOptions.KDELNKAdditions2[actpackage]);
  preinstallscript_edit->
    setText(params->KIFOptions.PreInstallScript2[actpackage]);
  doneinstallscript_edit->
    setText(params->KIFOptions.DoneInstallScript2[actpackage]);
  librarydir_edit->setText(params->KIFOptions.LibraryDir2[actpackage]);
  sprintf(cptr_version, "%i", params->KIFOptions.VersionMaj2[actpackage]);
  versionmaj_edit->setText(cptr_version);
  sprintf(cptr_version, "%i", params->KIFOptions.VersionMin2[actpackage]);
  versionmin_edit->setText(cptr_version);
  sprintf(cptr_version, "%i", params->KIFOptions.VersionRel2[actpackage]);
  versionrel_edit->setText(cptr_version);
}

void tMultiPackDlg::back_pressed()
{
  char cptr_version[4];

  strncpy(params->KIFOptions.ProgramName2[actpackage],
	  programname_edit->text(), 1024);
  strncpy(params->KIFOptions.CheckPriorFile2[actpackage],
	  checkpriorfile_edit->text(), 1024);
  strncpy(params->KIFOptions.CheckPriorRPM2[actpackage],
	  checkpriorrpm_edit->text(), 1024);
  strncpy(params->KIFOptions.SourceFile2[actpackage],
	  sourcefilename_edit->text(), 1024);
  strncpy(params->KIFOptions.IconFile2[actpackage],
	  iconfile_edit->text(), 1024);
  strncpy(params->KIFOptions.ExecBinary2[actpackage],
	  execbinary_edit->text(), 1024);
  strncpy(params->KIFOptions.KDELNKAdditions2[actpackage],
	  kdelnkadditions_edit->text(), 1024);
  strncpy(params->KIFOptions.PreInstallScript2[actpackage],
	  preinstallscript_edit->text(), 1024);
  strncpy(params->KIFOptions.DoneInstallScript2[actpackage],
	  doneinstallscript_edit->text(), 1024);
  strncpy(params->KIFOptions.LibraryDir2[actpackage],
	  librarydir_edit->text(), 1024);
  params->KIFOptions.VersionMaj2[actpackage] =
    atoi(versionmaj_edit->text());
  params->KIFOptions.VersionMin2[actpackage] =
    atoi(versionmin_edit->text());
  params->KIFOptions.VersionRel2[actpackage] =
    atoi(versionrel_edit->text());

  if(actpackage > 0)
    actpackage--;

  actpackage_lcd->display(actpackage + 1);

  programname_edit->setText(params->KIFOptions.ProgramName2[actpackage]);
  checkpriorfile_edit->setText(params->KIFOptions.CheckPriorFile2[actpackage]);
  checkpriorrpm_edit->setText(params->KIFOptions.CheckPriorRPM2[actpackage]);
  sourcefilename_edit->setText(params->KIFOptions.SourceFile2[actpackage]);
  iconfile_edit->setText(params->KIFOptions.IconFile2[actpackage]);
  execbinary_edit->setText(params->KIFOptions.ExecBinary2[actpackage]);
  kdelnkadditions_edit->
    setText(params->KIFOptions.KDELNKAdditions2[actpackage]);
  preinstallscript_edit->
    setText(params->KIFOptions.PreInstallScript2[actpackage]);
  doneinstallscript_edit->
    setText(params->KIFOptions.DoneInstallScript2[actpackage]);
  librarydir_edit->setText(params->KIFOptions.LibraryDir2[actpackage]);
  sprintf(cptr_version, "%i", params->KIFOptions.VersionMaj2[actpackage]);
  versionmaj_edit->setText(cptr_version);
  sprintf(cptr_version, "%i", params->KIFOptions.VersionMin2[actpackage]);
  versionmin_edit->setText(cptr_version);
  sprintf(cptr_version, "%i", params->KIFOptions.VersionRel2[actpackage]);
  versionrel_edit->setText(cptr_version);
}

void tMultiPackDlg::ok_pressed()
{
  int i;

  strncpy(params->KIFOptions.ProgramName2[actpackage],
	  programname_edit->text(), 1024);
  strncpy(params->KIFOptions.CheckPriorFile2[actpackage],
	  checkpriorfile_edit->text(), 1024);
  strncpy(params->KIFOptions.CheckPriorRPM2[actpackage],
	  checkpriorrpm_edit->text(), 1024);
  strncpy(params->KIFOptions.SourceFile2[actpackage],
	  sourcefilename_edit->text(), 1024);
  strncpy(params->KIFOptions.IconFile2[actpackage],
	  iconfile_edit->text(), 1024);
  strncpy(params->KIFOptions.ExecBinary2[actpackage],
	  execbinary_edit->text(), 1024);
  strncpy(params->KIFOptions.KDELNKAdditions2[actpackage],
	  kdelnkadditions_edit->text(), 1024);
  strncpy(params->KIFOptions.PreInstallScript2[actpackage],
	  preinstallscript_edit->text(), 1024);
  strncpy(params->KIFOptions.DoneInstallScript2[actpackage],
	  doneinstallscript_edit->text(), 1024);
  strncpy(params->KIFOptions.LibraryDir2[actpackage],
	  librarydir_edit->text(), 1024);
  params->KIFOptions.VersionMaj2[actpackage] =
    atoi(versionmaj_edit->text());
  params->KIFOptions.VersionMin2[actpackage] =
    atoi(versionmin_edit->text());
  params->KIFOptions.VersionRel2[actpackage] =
    atoi(versionrel_edit->text());

  for(i = 0;i < MAX_ADDITIONAL_PACKAGES;i++)
    {
      strcpy(origparams->KIFOptions.ProgramName2[i],
	     params->KIFOptions.ProgramName2[i]);
      strcpy(origparams->KIFOptions.CheckPriorFile2[i],
	     params->KIFOptions.CheckPriorFile2[i]);
      strcpy(origparams->KIFOptions.CheckPriorRPM2[i],
	     params->KIFOptions.CheckPriorRPM2[i]);
      strcpy(origparams->KIFOptions.SourceFile2[i],
	     params->KIFOptions.SourceFile2[i]);
      strcpy(origparams->KIFOptions.IconFile2[i],
	     params->KIFOptions.IconFile2[i]);
      strcpy(origparams->KIFOptions.ExecBinary2[i],
	     params->KIFOptions.ExecBinary2[i]);
      strcpy(origparams->KIFOptions.KDELNKAdditions2[i],
	     params->KIFOptions.KDELNKAdditions2[i]);
      strcpy(origparams->KIFOptions.PreInstallScript2[i],
	     params->KIFOptions.PreInstallScript2[i]);
      strcpy(origparams->KIFOptions.DoneInstallScript2[i],
	     params->KIFOptions.DoneInstallScript2[i]);
      strcpy(origparams->KIFOptions.LibraryDir2[i],
	     params->KIFOptions.LibraryDir2[i]);
      origparams->KIFOptions.VersionMaj2[i] =
	params->KIFOptions.VersionMaj2[i];
      origparams->KIFOptions.VersionMin2[i] =
	params->KIFOptions.VersionMin2[i];
      origparams->KIFOptions.VersionRel2[i] =
	params->KIFOptions.VersionRel2[i];
    }

  hide();
}

void tMultiPackDlg::cancel_pressed()
{
  hide();
}

void tMultiPackDlg::help_pressed()
{
  kapp->invokeHTMLHelp("kcreateinst/index.html", "");
}

void tMultiPackDlg::showdlg(tParams* given_params)
{
  int i;
  char cptr_version[4];

  actpackage = 0;
  actpackage_lcd->display(actpackage + 1);

  for(i = 0;i < MAX_ADDITIONAL_PACKAGES;i++)
    {
      strcpy(params->KIFOptions.ProgramName2[i],
	     given_params->KIFOptions.ProgramName2[i]);
      strcpy(params->KIFOptions.CheckPriorFile2[i],
	     given_params->KIFOptions.CheckPriorFile2[i]);
      strcpy(params->KIFOptions.CheckPriorRPM2[i],
	     given_params->KIFOptions.CheckPriorRPM2[i]);
      strcpy(params->KIFOptions.SourceFile2[i],
	     given_params->KIFOptions.SourceFile2[i]);
      strcpy(params->KIFOptions.IconFile2[i],
	     given_params->KIFOptions.IconFile2[i]);
      strcpy(params->KIFOptions.ExecBinary2[i],
	     given_params->KIFOptions.ExecBinary2[i]);
      strcpy(params->KIFOptions.KDELNKAdditions2[i],
	     given_params->KIFOptions.KDELNKAdditions2[i]);
      strcpy(params->KIFOptions.PreInstallScript2[i],
	     given_params->KIFOptions.PreInstallScript2[i]);
      strcpy(params->KIFOptions.DoneInstallScript2[i],
	     given_params->KIFOptions.DoneInstallScript2[i]);
      strcpy(params->KIFOptions.LibraryDir2[i],
	     given_params->KIFOptions.LibraryDir2[i]);
      params->KIFOptions.VersionMaj2[i] =
	given_params->KIFOptions.VersionMaj2[i];
      params->KIFOptions.VersionMin2[i] =
	given_params->KIFOptions.VersionMin2[i];
      params->KIFOptions.VersionRel2[i] =
	given_params->KIFOptions.VersionRel2[i];

      strcpy(origparams->KIFOptions.ProgramName2[i],
	     given_params->KIFOptions.ProgramName2[i]);
      strcpy(origparams->KIFOptions.CheckPriorFile2[i],
	     given_params->KIFOptions.CheckPriorFile2[i]);
      strcpy(origparams->KIFOptions.CheckPriorRPM2[i],
	     given_params->KIFOptions.CheckPriorRPM2[i]);
      strcpy(origparams->KIFOptions.SourceFile2[i],
	     given_params->KIFOptions.SourceFile2[i]);
      strcpy(origparams->KIFOptions.IconFile2[i],
	     given_params->KIFOptions.IconFile2[i]);
      strcpy(origparams->KIFOptions.ExecBinary2[i],
	     given_params->KIFOptions.ExecBinary2[i]);
      strcpy(origparams->KIFOptions.KDELNKAdditions2[i],
	     given_params->KIFOptions.KDELNKAdditions2[i]);
      strcpy(origparams->KIFOptions.PreInstallScript2[i],
	     given_params->KIFOptions.PreInstallScript2[i]);
      strcpy(origparams->KIFOptions.DoneInstallScript2[i],
	     given_params->KIFOptions.DoneInstallScript2[i]);
      strcpy(origparams->KIFOptions.LibraryDir2[i],
	     given_params->KIFOptions.LibraryDir2[i]);
      origparams->KIFOptions.VersionMaj2[i] =
	given_params->KIFOptions.VersionMaj2[i];
      origparams->KIFOptions.VersionMin2[i] =
	given_params->KIFOptions.VersionMin2[i];
      origparams->KIFOptions.VersionRel2[i] =
	given_params->KIFOptions.VersionRel2[i];
    }

  programname_edit->setText(params->KIFOptions.ProgramName2[actpackage]);
  checkpriorfile_edit->setText(params->KIFOptions.CheckPriorFile2[actpackage]);
  checkpriorrpm_edit->setText(params->KIFOptions.CheckPriorRPM2[actpackage]);
  sourcefilename_edit->setText(params->KIFOptions.SourceFile2[actpackage]);
  iconfile_edit->setText(params->KIFOptions.IconFile2[actpackage]);
  execbinary_edit->setText(params->KIFOptions.ExecBinary2[actpackage]);
  kdelnkadditions_edit->
    setText(params->KIFOptions.KDELNKAdditions2[actpackage]);
  preinstallscript_edit->
    setText(params->KIFOptions.PreInstallScript2[actpackage]);
  doneinstallscript_edit->
    setText(params->KIFOptions.DoneInstallScript2[actpackage]);
  librarydir_edit->setText(params->KIFOptions.LibraryDir2[actpackage]);
  sprintf(cptr_version, "%i", params->KIFOptions.VersionMaj2[actpackage]);
  versionmaj_edit->setText(cptr_version);
  sprintf(cptr_version, "%i", params->KIFOptions.VersionMin2[actpackage]);
  versionmin_edit->setText(cptr_version);
  sprintf(cptr_version, "%i", params->KIFOptions.VersionRel2[actpackage]);
  versionrel_edit->setText(cptr_version);

  show();

  for(i = 0;i < MAX_ADDITIONAL_PACKAGES;i++)
    {
      strcpy(given_params->KIFOptions.ProgramName2[i],
	     origparams->KIFOptions.ProgramName2[i]);
      strcpy(given_params->KIFOptions.CheckPriorFile2[i],
	     origparams->KIFOptions.CheckPriorFile2[i]);
      strcpy(given_params->KIFOptions.CheckPriorRPM2[i],
	     origparams->KIFOptions.CheckPriorRPM2[i]);
      strcpy(given_params->KIFOptions.SourceFile2[i],
	     origparams->KIFOptions.SourceFile2[i]);
      strcpy(given_params->KIFOptions.IconFile2[i],
	     origparams->KIFOptions.IconFile2[i]);
      strcpy(given_params->KIFOptions.ExecBinary2[i],
	     origparams->KIFOptions.ExecBinary2[i]);
      strcpy(given_params->KIFOptions.KDELNKAdditions2[i],
	     origparams->KIFOptions.KDELNKAdditions2[i]);
      strcpy(given_params->KIFOptions.PreInstallScript2[i],
	     origparams->KIFOptions.PreInstallScript2[i]);
      strcpy(given_params->KIFOptions.DoneInstallScript2[i],
	     origparams->KIFOptions.DoneInstallScript2[i]);
      strcpy(given_params->KIFOptions.LibraryDir2[i],
	     origparams->KIFOptions.LibraryDir2[i]);
      given_params->KIFOptions.VersionMaj2[i] =
	origparams->KIFOptions.VersionMaj2[i];
      given_params->KIFOptions.VersionMin2[i] =
	origparams->KIFOptions.VersionMin2[i];
      given_params->KIFOptions.VersionRel2[i] =
	origparams->KIFOptions.VersionRel2[i];
    }
}

