/************************************************************************
 * kiselfextract - part of kinst package - selfextract.cpp              *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <qapp.h>
#include <qdialog.h>
#include <qprogressbar.h>
#include <qlabel.h>
#include <qmessagebox.h>

#define SIGNATURE_LENGTH 3
#define SIGNATURE_COUNT 150

#ifndef WIDTH
#define WIDTH 300
#endif

#ifndef HEIGHT
#define HEIGHT 60
#endif

FILE* myself;
FILE* dest;
char myname[FILENAME_MAX];
char destname[FILENAME_MAX];

class tStatusDlg:public QDialog
{
private:
  QLabel* InfoLabel;
  QProgressBar* ProgressBar;
public:
  void setBarValue(int value);
  int getProgressTotal();
  tStatusDlg(QWidget* parent, const char* name);
};

tStatusDlg::tStatusDlg(QWidget* parent, const char* name)
  :QDialog(parent, name, false)
{
  // General properties
  setCaption("kinst selfextract");
  resize(WIDTH, HEIGHT);
  setMinimumWidth(WIDTH);
  setMaximumWidth(WIDTH);
  setMinimumHeight(HEIGHT);
  setMaximumHeight(HEIGHT);

  // Create InfoLabel
  InfoLabel = new QLabel(this);
  InfoLabel->setText("Preparing kinst installer ...");
  InfoLabel->setGeometry(10, 10, WIDTH - 20, 15);
  InfoLabel->show();

  // Create ProgressBar
  ProgressBar = new QProgressBar(15, this);
  ProgressBar->setProgress(0);
  ProgressBar->setGeometry(10, 30, WIDTH - 20, 20);
  ProgressBar->show();
}

void tStatusDlg::setBarValue(int value)
{
  ProgressBar->setProgress(value);
}

int tStatusDlg::getProgressTotal()
{
  return(ProgressBar->totalSteps());
}

void Help(void)
{
  printf("kiselfextract (kinst) - Copyright (C) 2000 Steffen Sobiech\n");
  printf("This program underlies the GPL and comes with NO WARRANTY\n\n");
  printf("Usage: [selfextractorname] [-h][--help]\n");
  printf("       [selfextractorname] [-p] [Files]\n\n");
  printf("       -h --help This help message\n");
  printf("       -p        Pack Mode\n");
  printf("                 In Pack Mode all files after -p are taken for\n");
  printf("                 the creation of a new selfextractor package.\n");
  printf("                 Output of the complete file is directet to stdout.\n");
  printf("                 Note: Up to now you should take an \"empty\" self-\n");
  printf("                       extractor to create a new package.\n");
  exit(0);
}

void Error(char* c)
{
  fprintf(stderr, "%s: Corrupt selfextractor package\n", c);
  exit(127);
}

// This function positions the stream right after the next signature
// Hope the dest file doesn`t contain it...
// returns 1 on success
int skip2sig(FILE* f)
{
  const int siglength = SIGNATURE_LENGTH;
  const int sigcount = SIGNATURE_COUNT;

  char signature[siglength];
  char c;
  int success;
  int i;
  int w;
  fpos_t origpos;

  signature[0] = 0;
  signature[1] = 255;
  signature[2] = 127;

  success = 0;

  fgetpos(f, &origpos);

  while((!success) && (!feof(f)))
    {
      success = 0;
      for(w = 0 ; w < sigcount ; w++)
	for(i = 0 ; i < siglength ; i++)
	  {
	    if(fread(&c, 1, 1, f) == 0) return(0);
	    if(signature[i] == c) success = 1;
	    else
	      {
		success = 0;
		if(i > 0) fseek(f, -1, SEEK_CUR);
		i = siglength;
		w = sigcount;
	      }
	  }
    }

  if(!success)
    {
      clearerr(f);
      fsetpos(f, &origpos);
      return(0);
    }
  
  return(1);
}

int putsig(FILE* f)
{
  const int siglength = SIGNATURE_LENGTH;
  const int sigcount = SIGNATURE_COUNT;

  char signature[siglength];
  int i;
  int w;

  signature[0] = 0;
  signature[1] = 255;
  signature[2] = 127;

  for(w = 0 ; w < sigcount ; w++)
    for(i = 0 ; i < siglength ; i++)
      if(fwrite(&(signature[i]), 1, 1, f) == 0) return(0);

  return(1);
}

int getFileName(char* s, FILE* f)
{
  if(fread(s, FILENAME_MAX, 1, f) == 0) return(0);
  return(1);
}

int putFileName(char* s, FILE* f)
{
  char s2put[FILENAME_MAX];

  if(strlen(s) > FILENAME_MAX) return(0);
  strcpy(s2put, s);

  if(fwrite(s2put, FILENAME_MAX, 1, f) == 0) return(0);

  return(1);
}

void PACK_MODE(int argc, char* argv[])
{
  int i;
  char c;

  myself = fopen(myname, "r");

  while(!feof(myself)) putchar(fgetc(myself));

  fclose(myself);

  for(i = 2 ; i < argc ; i++)
    {
      putsig(stdout);
      putFileName(argv[i], stdout);
      dest = 0;
      dest = fopen(argv[i], "r");
      if(dest == 0)
	{
	  fprintf(stderr, "%s: I/O error with %s", myname, argv[i]);
	  exit(127);
	}
      while(!feof(dest))
	{
	  c = fgetc(dest) ;
	  if(!feof(dest)) putchar(c);
	}
      fclose(dest);
    }

  exit(0);
}

int main(int argc, char* argv[])
{
  char destname_tmp[FILENAME_MAX];
  char tmpprefix[FILENAME_MAX];
  char s[1024];
  char lang[1024];
  char c;
  fpos_t filestart;
  fpos_t fileend;
  fpos_t actpos;
  int at_end;
  int kinst_installed;
  int actprogress;
  QApplication* a;
  tStatusDlg* StatusDlg;

  a = new QApplication(argc, argv);

  StatusDlg = new tStatusDlg(0, "main_window");

  a->setMainWidget(StatusDlg);

  at_end = 0;

  actprogress = 0;

  strcpy(myname, argv[0]);

  StatusDlg->setCaption(argv[0]);

  if(argc > 1)
    {
      if(strcmp(argv[1], "-p") == 0) PACK_MODE(argc, argv);
      if((strcmp(argv[1], "--help") == 0) || (strcmp(argv[1], "-h") == 0))
	Help();
    }

  StatusDlg->show();
  a->processEvents();
  a->processEvents();

  if(getuid() != 0)
    {
      printf("Warning: kinst needs root UID !\n");
      QMessageBox::warning(0, "kinst selfextract",
			   "Warning: kinst needs root UID !");
    }

  /* Extraction part */
  /* --------------- */
  tmpnam(tmpprefix);
  if(mkdir(tmpprefix, 0755) != 0)
    {
      fprintf(stderr, "%s: Could not create temporary directory %s\n",
	      myname, tmpprefix);
      exit(127);
    }

  StatusDlg->setBarValue(actprogress + 1);
  actprogress++;
  a->processEvents();
  a->processEvents();

  myself = fopen(myname, "r");

  while(!at_end)
    {
      a->processEvents();
      a->processEvents();
      if(!skip2sig(myself)) at_end = 1;
      if(!at_end)
	{
	  fgetpos(myself, &filestart);
	  if(!skip2sig(myself)) at_end = 1;
	  else 
	    fseek(myself, -(SIGNATURE_LENGTH * SIGNATURE_COUNT), SEEK_CUR);
	  fgetpos(myself, &fileend);
	  fsetpos(myself, &filestart);
	  strcpy(destname, tmpprefix);
	  strcat(destname, "/");
	  if(!getFileName(destname_tmp, myself)) Error(myname);
	  strcat(destname, destname_tmp);

#ifdef _DEBUG_
	  printf("%s: Extracting %s ...\n", myname, destname);
#endif

	  dest = 0;
	  dest = fopen(destname, "w");
	  if(dest == 0)
	    {
	      fprintf(stderr,
		      "%s: I/O error while creating %s\n", myname, destname);
	      exit(127);
	    }

	  fgetpos(myself, &actpos);

	  while(actpos != fileend)
	    {
	      c = fgetc(myself);
	      fputc(c, dest);
	      fgetpos(myself, &actpos);
	    }

	  fclose(dest);
	  fsetpos(myself, &filestart);

	  StatusDlg->setBarValue(actprogress + 1);
	  actprogress++;
	  a->processEvents();
	  a->processEvents();
	}
    }

  StatusDlg->setBarValue(StatusDlg->getProgressTotal() - 1);
  a->processEvents();
  a->processEvents();

  if(myself != 0) fclose(myself);

  /* kinst preparation part */
  /* ---------------------- */

  /* Stop if no KDEDIR set */
  if(strlen(getenv("KDEDIR")) == 0)
     {
       fprintf(stderr, "%s: No KDEDIR variable set. Program halted.\n", myname);
       QMessageBox::warning(0, "kinst selfextract",
			    "No KDEDIR variable set. Program halted.");

       exit(127);
     }

  kinst_installed = 0;

  strcpy(destname, getenv("KDEDIR"));
  strcat(destname, "/bin/kinst");

  dest = 0;
  dest = fopen(destname, "r");
  if(dest != 0)
    {
#ifdef _DEBUG_
      printf("%s: another (newer?) kinst is already installed.\n", myname);
#endif
      kinst_installed = 1;
      fclose(dest);
    }

  /* let's get the locale installed */
  /* is a language set? */
  if(getenv("LANG") != 0) {
    strcpy(s, getenv("LANG"));
    lang[0] = s[0];
    lang[1] = s[1];
    lang[2] = 0;
    if((strlen(lang) != 0) && (!kinst_installed))
      {
	strcpy(s, "cp -f ");
	strcat(s, tmpprefix);
	strcat(s, "/");
	strcat(s, lang);
	strcat(s, ".gmo ");
	strcat(s, getenv("KDEDIR"));
	strcat(s, "/share/locale/");
	strcat(s, lang);
	strcat(s, "/LC_MESSAGES/kinst.mo");

	system(s);
      }
  }

  StatusDlg->setBarValue(StatusDlg->getProgressTotal());
  a->processEvents();
  a->processEvents();

  /* It's time for kinst to come up */
  strcpy(s, tmpprefix);
  strcat(s, "/kinst");
  chmod(s, S_IXUSR || S_IRUSR || S_IWUSR);
  strcat(s, " -p ");
  strcat(s, tmpprefix);
  strcat(s, "/package.kip");

  StatusDlg->hide();
  a->processEvents();
  a->processEvents();

  system(s);

  /* Erase the temps */
  strcpy(s, "rm -f -r ");
  strcat(s, tmpprefix);
  
  system(s);

  return(0);
}
