//-*-Mode: C++;-*-
/*
  converter.h  -  description                              
  -------------------                                         
  begin                : Sat Jul 3 1999                                           
  copyright            : (C) 1999 by Rajko Albrecht                         
  email                : Rajko.Albrecht@informatik.tu-chemnitz.de
*/

/*
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
                                                                           */


#ifndef CONVERTER_H
#define CONVERTER_H

#include "stringlist.h"
#include <string>
#include "smart_pointer.h"

/**
  *Base class for converting strings into other text for instance ASCII into HTML
  *
  *@author Rajko Albrecht
  *@version $Id: converter.h,v 2.7 2000/03/18 13:26:03 ral Exp $
  */

class CConverter:virtual public refCounter {
public:
	/**
	 * Types of converter known
	 */
    enum ConvertTypes {HTML,LATEX};
    /** Constructor */
    CConverter();
    /**
     * creates a converter object
     * Returns an instance of a converter object. This is
     * the one and only way to get such object.
     *
     * @param type the type of converter to use
     * @return an instance of an converter or NULL if failure
     */
    static CConverter* get_converter(ConvertTypes type);
    virtual ~CConverter();
    const char*convert(const char*what);
    const char*get_original(){return source.c_str();}
    const char*get_result(){return dest.c_str();}
protected:
	std::string dest;
	std::string source;
    stringlist source_idents;
    stringlist target_idents;
    int count;
    virtual void avoid_new()=0;
};

#endif

