//-*-Mode: C++;-*-
/***************************************************************************
                          liste.h  -  description                              
                             -------------------                                         
    begin                : Sun Aug 1 1999                                           
    copyright            : (C) 1999 by Rajko Albrecht                         
    email                : Rajko.Albrecht@informatik.tu-chemnitz.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// $Id: liste.h,v 2.8 2001/04/08 11:00:52 ral Exp $

#include <vector>

#ifndef __liste_h_included
#define __liste_h_included

#ifdef WIN32
#pragma warning ( disable : 4786 )
template<class T,class A = std::allocator<T> > class my_vector : public std::vector<T,A>
#else
template<class T,class A = std::alloc > class my_vector : public std::vector<T,A>
#endif
{
protected:
    std::vector<T,A>::iterator _search_pos;
public:
    std::vector<T,A>::iterator find(const T&,std::vector<T,A>::iterator start_pos = 0);
    my_vector<T,A>():std::vector<T,A>(){_search_pos = 0;}
};

template<class T,class A> inline 
std::vector<T,A>::iterator my_vector<T,A>::find(const T&what,std::vector<T,A>::iterator start_pos)
{
    _search_pos = start_pos?start_pos:begin();
    for(;_search_pos<end();++_search_pos) {
        if (*_search_pos == what)
            return _search_pos;
    }
    return 0;
}

#endif
