/***************************************************************************
                          openetext.cpp  -  description
    begin                : Sat Dec 4 1999
    begin                : Tue Jul 25 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "gutenbrowser.h"
#include "openetext.h"
#include <stdlib.h>
#include <qtextstream.h>
#if defined(_WS_WIN_)
#include <windows.h>
#endif

OpenEtext::OpenEtext(QWidget *parent, QString name) : QDialog(parent,name,true)
{
    initDialog();

    connect( QPushButton_Cancel, SIGNAL(released()), SLOT(reject()) );
    connect( QListBox_1, SIGNAL(selected ( int)),this, SLOT(select_title(int)) );

    getTitles();
}

OpenEtext::~OpenEtext()
{
}

void OpenEtext::getTitles()
{
    config->setGroup( "Files" );

    s_numofFiles = config->readEntry("NumberOfFiles", "0");

  QLabel_1->setText( tr("Pick from these "+s_numofFiles+" etexts in your library:"));

    int  i_numofFiles = s_numofFiles.toInt();
    for (int i = 1; i <= i_numofFiles; i++) {
        QString temp;
        temp.setNum(i);
        config->setGroup( "Files" );
        QString ramble = config->readEntry(temp, "" );
        config->setGroup( "Titles" );
        title = config->readEntry(ramble, "");

        if( !title.isEmpty()) {
            QListBox_1->insertItem ( title, -1);
        }
    }
    setCursor(arrowCursor);
}

/*
 opens selected title */
void OpenEtext::OpenTitle()
{
    if( QListBox_1->currentItem() != -1)
        select_title(  QListBox_1->currentItem() );
    else {
        QString sMsg;
        sMsg = "You must select an Etext to open";
        QMessageBox::message( "Error",sMsg);
    }
}

void OpenEtext::select_title(int index )
{
    QString temp;
    temp.setNum( index + 1);
    const char * title;
    title = QListBox_1->text( index );
    openFileTitle = title;

    config->setGroup( "Files" );
    file = config->readEntry(temp, "");
    OpenEtext::accept();
}

void OpenEtext::open()
{
    setCursor( waitCursor );
    title = "";
    QString currDir="";
    QString filer;

    QString local ;
    local = (QDir::homeDirPath () +"/.gutenbrowser");
    QDir library( local);
    fileList = QFileDialog::getOpenFileNames(  "Text Files (*.txt)",local, this);
    QStringList::ConstIterator f;
    QString fileTemp;
//    setCursor( waitCursor );
    for (  f = fileList.begin(); f != fileList.end(); f++ ) {

        fileTemp = *f;
        fileTemp.right( fileTemp.length()-5);
        fileName = fileTemp;
        if( !fileName.isEmpty() ){
            filer = fileName;
        } else {
            QString sMsg;
            sMsg = "Error opening library filelist "+fileName;
        }

        if( filer.right(4) == ".txt" ||  filer.right(4) == ".TXT" ||  filer.right(4) == ".zip"  ||  filer.right(4) == ".ZIP" ) {
            QFileInfo zipFile( filer);
            QString s_fileName = zipFile.fileName();
            if( s_fileName.right(4) == ".zip") {
                  // unzip that sucker....
                s_fileName = s_fileName.left( s_fileName.length() - 4);
#if defined(_WS_X11_)
                QString cmd = "unzip -o " + filer + " -d " + local_library;
#endif
#if defined(_WS_WIN_)
                QString temp= QDir::convertSeparators(local_library);
                filer=QDir::convertSeparators( filer);
                QString cmd = temp+"unzip.exe -o " +filer/*newestLibraryFile  */+" -d " + temp;
#endif
                fileName = local_library + s_fileName + ".txt";

#if defined(_WS_X11_)//
                system( cmd);
#endif
#if defined(_WS_WIN_)
                WinExec( cmd, SW_HIDE );
#endif
            }
        }
        FindTitle();
        QListBox_1->clear();
        getTitles();
   } // end of for each file name....
//    setCursor(arrowCursor);
}

/*
find the title in the config file */
bool OpenEtext::FindTitle()
{
    config->setGroup( "Files" );
    QString s_numofFiles = config->readEntry("NumberOfFiles", "0");
    int  i_numofFiles = s_numofFiles.toInt();

    QFileInfo fi(fileName);
    name = fi.fileName();
#if defined(_WIN32)
//      QMessageBox::message("Hi", "Trying to open "+fileName +"\n");
//#if defined(_WS_WIN_)
//fileName = fileName.right( fileName.length() - 5);
#endif

#if defined(_WS_X11_)

    fileName = fileName.right( fileName.length() - 5);
#endif

    QFile indexLib( fileName);

    if ( indexLib.open( IO_ReadOnly) ) {
          // file opened successfully
        QTextStream indexStream( &indexLib );
        QString target = "Project Gutenberg Etext of";
        QString target2 = "Project Gutenberg Etext";
        QString indexLine;
        bool findCheck = FALSE;
        while ( !indexStream.eof() ) {
              // until end of file..
            indexLine = indexStream.readLine();

            int Titlenumber = indexLine.find(target, 0, TRUE);
            if( Titlenumber > -1) {
                findCheck = TRUE;
                title = indexLine.mid( Titlenumber + (target.length()) , indexLine.find("\r", 0, TRUE));
                title = title.left( title.find( "*",0, TRUE));
                title = title.stripWhiteSpace ();
                qDebug("Found the title 1 and it is/n %s", title.latin1());
//                              QListBox_1->insertItem ( title);
            } else if( findCheck == FALSE) {
                int Titlenumber = indexLine.find( target2, 0, TRUE);
                if( Titlenumber > -1) {
                    findCheck = TRUE;
                    title = indexLine.mid( Titlenumber + ( target2.length()) , indexLine.find("\r", 0, TRUE));
                    title = title.left( title.find( "*",0, TRUE));
                    title = title.stripWhiteSpace ();
                    qDebug("Found the title 2 and it is\n %s", title.latin1());
//                              QListBox_1->insertItem ( title);
                } else {
                    qDebug("Having trouble finding title.");
                    title = titleFromLibrary( fileName);
                    qDebug( "%s",title.latin1());
                    if( title.length() >3)
                        findCheck=TRUE;
                }
            }
        }

        if ( checkConf() == false && findCheck == TRUE) {
            config->setGroup( "Files");
            config->writeEntry("NumberOfFiles",i_numofFiles + 1 );
            QString interger;
            interger.setNum( i_numofFiles +1);
            config->writeEntry(interger, fileName);
            config->setGroup( "Titles" );
            config->writeEntry( fileName,title);
            config->write();
        }
    } else {
        QString sMsg;
        sMsg = "Error opening library file: "+fileName;
        printf( sMsg+"\n");
    }
    return true;
}

QString OpenEtext::titleFromLibrary( QString fileName)
{
    QFile indexLib( local_index);
    QString target;
    int find1 = fileName.findRev("/",-1,TRUE)  + 1;
    int find2 = fileName.findRev(".txt",-1,TRUE) - find1;
    target = fileName.mid( find1,  find2 );
    QString checker = target.right(1);
    bool ok;
    checker.toInt( &ok,10);
    if( ok) {
        target = target.left( target.length()-1);
        checker = target.right(1);
        ok = FALSE;
        checker.toInt( &ok,10);
        if( ok) {
            target = target.left( target.length()-1);
        }
    }
    if ( indexLib.open( IO_ReadOnly) ) {
          // file opened successfully
        QTextStream indexStream( &indexLib );
        QString indexLine;
        bool findCheck = FALSE;
        while ( !indexStream.atEnd() ) {                  // until end of file..
            indexLine = indexStream.readLine();

            if( indexLine.find( target,0,FALSE) > 0 ) {
                findCheck = TRUE;
                title = indexLine.mid( 26, indexLine.length() );
                title = title.stripWhiteSpace ();
                qDebug("Finally Found the title and it is\n %s", title.latin1());
//                              QListBox_1->insertItem ( title);
            }
        } //end while loop
    }
    else
        printf("Error opening library index\n");
    return title;
}

bool OpenEtext::checkConf()
{
    QString file = fileName;
    config->setGroup( "Files" );
    QString s_numofFiles = config->readEntry("NumberOfFiles", "0" );
    int  i_numofFiles = s_numofFiles.toInt();

    for (int i = 1; i <= i_numofFiles; i++) {
        QString temp;
        temp.setNum(i);
        config->setGroup( "Files");
        QString ramble = config->readEntry(temp, "" );

        if(ramble == file ) {
            return true;
        }
    }
    return false;
}



void OpenEtext::remove()
{
    setCursor( waitCursor );
    title_text = QListBox_1->text( QListBox_1->currentItem() );
    title_text=title_text.stripWhiteSpace();
    QString msg ="Do you really want to REMOVE\n " +title_text +"??\n";
    switch( QMessageBox::information( this, (tr("Remove Etext from the list?\nThis will not delete the file from the hard drive.")),
                                      (tr(msg)),
                                      (tr("&Yes")), (tr("&Cancel")), 0 )){
        case 0: // Yes clicked,
            removeSelection();
            QListBox_1->clear();
            getTitles();
            break;
        case 1: // Cancel
            break;
    };
    setCursor(arrowCursor);
}

void OpenEtext::removeSelection()
{
//config->read();
    config->setGroup( "Files" );
    s_numofFiles = config->readEntry("NumberOfFiles", "0");

    int  i_numofFiles = s_numofFiles.toInt();
    for (int i = 1; i <= i_numofFiles; i++) {
        QString fileNum;
        fileNum.setNum(i);
        config->setGroup( "Files" );
        QString s_filename = config->readEntry(fileNum, "" );
        config->setGroup( "Titles" );
        QString file_title = config->readEntry( s_filename, "");
//   QMessageBox::message("file_title",file_title);
        if(title_text == file_title ) {
            selFile = s_filename;
//  QMessageBox::message( "Note", selFile );
        }
    }
    remFile();
}

void OpenEtext::remFile()
{
    config->setGroup( "Files" );
    QString remFile;
    s_numofFiles = config->readEntry("NumberOfFiles", "0");
    int  i_numofFiles = s_numofFiles.toInt();
    for (int i = 1; i <= i_numofFiles; i++) {
        QString fileNum;
        fileNum.setNum(i);
        config->setGroup( "Files" );
        QString s_filename = config->readEntry(fileNum, "" );

        if( s_filename == selFile) {

            for(int fg = i_numofFiles - i; fg < i_numofFiles ; fg++  ) {
                QString fileNum2;
                fileNum2.setNum( fg + 1);
                QString s_filename2 = config->readEntry(fileNum2, "" );

                if (!s_filename2.isEmpty()) {
                    config->writeEntry(fileNum, s_filename2 );
                }
            }
        }
    }
    config->writeEntry("NumberOfFiles", i_numofFiles - 1 );
    config->write();
    QString local_fileToRemove;
    QString strDir;
    strDir = "/gutenbrowserrc";
    QString newRc;
    QFile rcFile(strDir);
    if ( rcFile.open(IO_ReadWrite) )  { // file opened successfully
        QTextStream rcStream( &rcFile );
        QString rcLine;

        while ( !rcStream.eof() )   { // until end of file..
            rcLine = rcStream.readLine();
            if (( rcLine.left(11) != selFile) && (  rcLine.left(2) != s_numofFiles)) {
                newRc += rcLine+"\n";
            }
        }
    }
    rcFile.close();
    QFile rcFile2(strDir);

    if ( rcFile2.open(IO_WriteOnly) ) {  // file opened successfully
        rcFile2.writeBlock(newRc, newRc.length());
        rcFile2.close();
    }
    if( !selFile.contains("/", TRUE) ) {
        local_fileToRemove = local_library + selFile;
    } else {
        local_fileToRemove = selFile;
    }
//    if(!QFile::remove(local_fileToRemove))
//        QMessageBox::message( "Note","Could not delete\n" + selFile );
    config->write();
   QListBox_1->triggerUpdate(true);
}

/*
sorts the list*/
void OpenEtext::scan() {

    QListBox_1->sort(TRUE);
    QListBox_1->triggerUpdate(true);
}

