/*
 * KHeiseReg
 *
 * A utility to search for articles within the Heise register.
 *
 * Copyright (C) 2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SEARCHDLG_H
#define SEARCHDLG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qwidget.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qslider.h>

#include <kdialog.h>
#include <kconfig.h>

#include "regfile.h"


class SearchDlg: public KDialog
{
	Q_OBJECT
public:
	SearchDlg(QWidget *parent = 0, const char *name = 0);
	virtual ~SearchDlg();

signals:
	void search(const RegMask &mask);

private slots:
	void slotFuzzyToggled(bool on);

	void slotHelp();
	void slotDefault();
	void slotSearch();

private:
	KConfig *config;

	RegMask mask;

	QLineEdit *bywords, *authors, *editors, *editions, *years;
	QCheckBox *ctmag, *ixmag, *case_sensitive, *fuzzy;
	QLabel *min_threshold, *max_threshold;
	QSlider *threshold;
};


#endif // SERACHDLG_H
