/***************************************************************************
                          dockwidget.cpp  -  description
                             -------------------
    begin                : Sun Nov 28 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>
#include <kpopupmenu.h>

#include <qtooltip.h>

#include "dockwidget.h"

DockWidget::DockWidget(QWidget *parent, const char *name ) : KSystemTray(parent,name)
{
location = 0;
docked = false;

dockIcons = new KIconLoader();
if(dockIcons)
	{
	mini_seti         = dockIcons->loadIcon("mini-seti", KIcon::User);
	mini_setigrey     = dockIcons->loadIcon("mini-setidockgrey", KIcon::User);
	mini_setifinished = dockIcons->loadIcon("mini-setidockfinished", KIcon::User);
	mini_setistopped  = dockIcons->loadIcon("mini-setidockstopped", KIcon::User);
	mini_setiloading  = dockIcons->loadIcon("mini-setidockloading", KIcon::User);
	picsmall_pixmap   = dockIcons->loadIcon("ksetiwatch", KIcon::Small);
	}

contextMenu()->changeTitle(contextMenu()->idAt(0), "Ksetiwatch");	
contextMenu()->insertItem(i18n("Start Client"), StartClient);
contextMenu()->insertItem(i18n("Stop Client"), StopClient);
connect(contextMenu(), SIGNAL(aboutToShow()), SLOT(preparePopupMenu()));
connect(contextMenu(), SIGNAL(activated(int)), SLOT(handlePopupCommand(int)));

QToolTip::add(this, "Ksetiwatch");

// initialize and start the timer for a blinking icon
blink = new QTimer(this);
showIcon = true;
connect(blink, SIGNAL(timeout()), SLOT(slotBlinkIcon()));
// blinking interval is 1 sec
blink->start(1000);
}

DockWidget::~DockWidget()
{
}

void DockWidget::dock(SetiLoc* loc)
{
if (!docked)
 	{
	// copy the pointer to the SetiLoc location
	location = loc;
  docked = true;
 	this->show();
  }
}

void DockWidget::undock()
{
if (docked)
 	{
  docked = false;
  this->hide();
  }
}

void DockWidget::paintEvent(QPaintEvent *e)
{
paintIcon();
}

void DockWidget::paintIcon()
{
int x(0),y(0);

//clear the widget first
erase();
if(location == 0) // no location selected
	{	
	QSize s(picsmall_pixmap.size());
	if(s.width() < 24) x = (24 - s.width())/2;
	if(s.height() < 24) y = (24 - s.height())/2;
	bitBlt(this, x, y, &picsmall_pixmap);
	}
else //location selected, show details
	{
	QPixmap* icon;
	char prog[8];
	if(showIcon)
		{
		// determine the icon to be shown
  	switch(location->state())
  		{
  		case SetiLoc::Stopped:
  			icon = &mini_setistopped;
  			break;
  		case SetiLoc::Running:
  			icon = &mini_seti;
  			break;
  		case SetiLoc::Loading:
  			icon = &mini_setiloading;
  			break;
  		case SetiLoc::Finished:
  			icon = &mini_setifinished;
  			break;
  		default:
  			icon = &mini_setigrey;
  			break;
  		}
  	}
  else
  	icon = &mini_setigrey;
  // determine the text to be shown
  QString info;
  switch(location->state())
  	{
 		case SetiLoc::Stopped:
 			if(location->completed() >= 0.0)
 				{
				sprintf(prog, "%.0f%%", location->completed());
				info = i18n("stopped");
				}
			else
				{
				prog[0] = 0;
				info = "";
				}
 			break;
 		case SetiLoc::Running:
			sprintf(prog, "%.0f%%", location->completed());
			info = "-" + location->timeLeftAsString();
 			break;
 		case SetiLoc::Loading:
 			// don't show any text
 			prog[0] = 0;
 			info = i18n("loading");
 			break;
 		case SetiLoc::Finished:
 			sprintf(prog, "100%%");
 			info = i18n("finished");
 			break;
 		default:
 			// don't show any text
 			prog[0] = 0;
 			info = "";
 			break;
  		}
	QSize s(icon->size());
	if(s.width() < 24) x = (24 - s.width())/2;
	bitBlt(this, x, 2, icon);
	// draw the progress bar
	QRect pbar(0, 14, 23, 8);
	QPainter p(this);
	p.fillRect(pbar, darkGray);
	p.setPen(QColor(200, 200, 200));
	p.moveTo(0, 21);
	p.lineTo(23, 21);
	p.lineTo(23, 14);
	p.fillRect(0, 15, (int)(location->completed()*24/100.0), 6, QColor(180,100,0));
	p.setPen(white);
	p.setFont(QFont("system", 8));
	p.drawText( 0, 13, 23, 8, AlignCenter, (const char*)prog);
	// update tooltip with "remaining time" info
	QString tip("Ksetiwatch - ");
	tip += location->location();
	if(!info.isEmpty()) tip += " (" + info + ")";
	QToolTip::add(this, tip);	
	}
}


void DockWidget::handlePopupCommand(int id)
{
switch(id)
	{
	case StartClient:
		if(location) location->startClient();
		break;
	case StopClient:
		if(location) location->stopClient();
		break;
	}
}

/** Enables, disables or changes the popup menu entries */
void DockWidget::preparePopupMenu()
{
// disable start/stop client first
contextMenu()->setItemEnabled(StartClient, false);
contextMenu()->setItemEnabled(StopClient, false);
if(location)
	{
	switch(location->state())
		{
		case SetiLoc::Running:
		case SetiLoc::Loading:
			{
			// enable stop
	  	contextMenu()->setItemEnabled(StopClient, true);
	  	break;
	  	}
	  case SetiLoc::Stopped:
	  	{
			// enable start
	  	contextMenu()->setItemEnabled(StartClient, true);
	  	break;
	  	}
	  case SetiLoc::Finished:
	  	{
	  	if(location->isClientRunning() == true)
		  	contextMenu()->setItemEnabled(StopClient, true);
		  else
		  	contextMenu()->setItemEnabled(StartClient, true);			  		
	  	break;
	  	}
		}
	}
}

/** Repaints the dock widget with settings of the new location. */
void DockWidget::updateDockWidget(SetiLoc* loc)
{
// disconnect any previous connection
if(location != loc && location != 0)
	disconnect(location, SIGNAL(statusChanged()), this, SLOT(paintIcon()));
// react on changes of the status
if(location != loc)
	{
	location = loc;
	if(location)
		{
		connect(location, SIGNAL(statusChanged()), this, SLOT(paintIcon()));
		}
	else
		QToolTip::add(this, "Ksetiwatch");
	}
// finally repaint the icon
paintIcon();
}

/** Handles blinking of icon. */
void DockWidget::slotBlinkIcon()
{
if(location)
	{
	if(location->state() != SetiLoc::Running)
		{
		showIcon ^= true;
		paintIcon();
		}
	else
		{
		if(showIcon == false)
			{
			showIcon = true;
			paintIcon();
			}
		}
	}
}
