/***************************************************************************
                          ksetiwatch.h  -  description
                             -------------------
    begin                : Fre Okt 22 17:39:47 CEST 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef KSETIWATCH_H
#define KSETIWATCH_H

#include <qtimer.h>
#include <qdatetime.h>
#include <qwidget.h>
#include <qpopupmenu.h>
#include <qpixmap.h>

#include <kmainwindow.h>
#include <kapp.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <ktabctl.h>

#include "analysis.h"
#include "datainfo.h"
#include "userinfo.h"
#include "completedwulist.h"
#include "options.h"
#include "about.h"
#include "dockwidget.h"

class Ksetiwatch : public KMainWindow
{
Q_OBJECT

public:
  /** constructor */
  Ksetiwatch(const char* name=0);
  /** destructor */
  ~Ksetiwatch();
  bool startMinimized() {return startmin;}
  /**
   * Returns the corresponding SetiLoc entry from
	 * a QListView item in the Analysis list.
	 * @param list the ListView in question
	 * @param it the QListViewItem
	 * @return the SetiLoc entry, or 0 if it couldn't be found.
	 */
  static SetiLoc* getLocation(int list, QListViewItem* it);
  /** initializes the record score with zeros and empty strings */
  static void initWUScore(WUScore* score);

public slots:
	
protected:
	void closeEvent(QCloseEvent *e);
	bool event(QEvent *e);
  /** Writes all important work unit results to a file named SETILog.csv */
  void logWorkUnit(SetiLoc *loc);
  /** constructs a string from readEntry  */
  //QString constructEntry(QFile *f, const char *id, int type);
  QString constructEntry(const char* fn, const char *id, int type);
  /** Starts the SETI@home clients if the startup switch is on. */
  void startClients();

private:
	KConfig*         config;
	KIconLoader*     loader;
	KTabCtl*         ktb;
	Analysis*        ana;
	DataInfo*        di;
	UserInfo*        ui;
	CompletedWUList* cwu;
	Options*         opt;
	About*           abt;
	DockWidget*      ksdock;
	QPopupMenu*      dockrightpopup;
  /** this timer is required for checking whether a WU is completed or not */
  QTimer*          completed_timer;
	bool             startmin;
	QPixmap          StarMap;

private slots:
	void saveConfig();
	void readConfig();
	void handleTabSelection(int);


protected slots: // Protected slots
  /** Checks for a completed work unit */
  void checkWUStatus();
  /** Toggles dock icon on or off when the user makes changes in the options. */
  void toggleIcon();
};
#endif





