/***************************************************************************
                          addsetilocdlg.cpp  -  description
                             -------------------
    begin                : Sat Oct 30 1999
    copyright            : (C) 1999 by Gordon Machel
    email                : gmachel@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <kcolorbutton.h>

#include <qcheckbox.h>
#include <qtooltip.h>

#include "addsetilocdlg.h"

/*------------------------------------------------------------------------ */
AddSetiLocDlg::AddSetiLocDlg(QWidget *parent, const char *name)
             : AddSetiTmpl(parent,name,true)
{
QToolTip::add(StopAfterProcChkBox, i18n("Process the work unit and stop after \n"
                                   "processing is complete, do not return \n"
                                   "the result."));

QToolTip::add(StopAfterSendChkBox, i18n("Finish the current work unit, and \n"
                                   "return the result without downloading\n"
                                   "a new work unit."));

QToolTip::add(EmailChkBox, i18n("Send email (to login email address) on\n"
                           "errors. This option is not available\n"
                           "for all clients."));

QToolTip::add(GraphicsChkBox, i18n("Generate a data stream for the xsetiathome\n"
                              "graphical interface (see README.xsetiathome).\n"
                              "This option is not available for all clients."));

}

/*------------------------------------------------------------------------ */
AddSetiLocDlg::~AddSetiLocDlg()
{
}

/*------------------------------------------------------------------------ */
void AddSetiLocDlg::slotGetSetiDirectory()
{
QString d = KFileDialog::getExistingDirectory();
if(!d.isNull()) setSetiDirectory(d);
}

/*------------------------------------------------------------------------ */
void AddSetiLocDlg::slotGetLogDirectory()
{
QString d = KFileDialog::getExistingDirectory();
if(!d.isNull()) setLogDirectory(d);
}

/*------------------------------------------------------------------------ */
void AddSetiLocDlg::slotHandleText(const QString& t)
{
QString l1 = DescrEdit->text();
QString l2 = DirecEdit->text();
if(l1.isEmpty() || l2.isEmpty())
  buttonOk->setEnabled(false);
else
  buttonOk->setEnabled(true);	
}

/*------------------------------------------------------------------------ */
void AddSetiLocDlg::slotOk()
{
QDir d(DirecEdit->text());
if(d.exists())
	accept();
else
 	KMessageBox::error(this, i18n("Directory not found.\n"
                                "Make sure to enter a valid\n"
                                "SETI@Home directory."));
}

/*------------------------------------------------------------------------ */
void AddSetiLocDlg::setOptions(const LocSettings& setloc)
{
DescrEdit->setText(setloc.description);
ColorButton->setColor(setloc.color);
DirecEdit->setText(setloc.directory);
StartSetiChkBox->setChecked(setloc.startSeti);
StopSetiChkBox->setChecked(setloc.stopSeti);
ArgEdit->setText(setloc.arguments);
StopAfterProcChkBox->setChecked(setloc.stopAfterProcess);
StopAfterSendChkBox->setChecked(setloc.stopAfterSend);
EmailChkBox->setChecked(setloc.email);
GraphicsChkBox->setChecked(setloc.graphics);
LogChkBox->setChecked(setloc.log);
RedirChkBox->setChecked(setloc.redirectLog);
RedirEdit->setText(setloc.logDirectory);
}

/*------------------------------------------------------------------------ */
LocSettings AddSetiLocDlg::options() const
{
LocSettings setloc;

setloc.description      = DescrEdit->text();
setloc.color            = ColorButton->color();
setloc.directory        = DirecEdit->text();
setloc.startSeti        = StartSetiChkBox->isChecked();
setloc.stopSeti         = StopSetiChkBox->isChecked();
setloc.arguments        = ArgEdit->text();
setloc.stopAfterProcess = StopAfterProcChkBox->isChecked();
setloc.stopAfterSend    = StopAfterSendChkBox->isChecked();
setloc.email            = EmailChkBox->isChecked();
setloc.graphics         = GraphicsChkBox->isChecked();
setloc.log              = LogChkBox->isChecked();
setloc.redirectLog      = RedirChkBox->isChecked();
setloc.logDirectory     = RedirEdit->text();

return(setloc);
}

#include "addsetilocdlg.moc"