/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#include <qpainter.h>
#include <kconfig.h>
#include "cervisiaapp.h"
#include "misc.h"

#include "annotateview.h"
#include "annotateview.moc"


static const int BORDER = 4;


class AnnotateViewItem
{
public:
    QString rev;
    QString author;
    QString date;
    QString line;
};
    

AnnotateView::AnnotateView( QWidget *parent, const char *name )
#if QT_VERSION >= 200
    : QTableView(parent, name, WNorthWestGravity | WRepaintNoErase)
#else
    : QTableView(parent, name)
#endif
{
    setNumRows(0);
    setNumCols(4);
    setTableFlags( Tbl_autoVScrollBar|Tbl_autoHScrollBar|
		   Tbl_smoothVScrolling 
		   );
    setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
    setBackgroundMode( PaletteBase );
    setWFlags( WResizeNoErase );

    KConfig *config = capp->config();
    config->setGroup("LookAndFeel");
    setFont(config->readFontEntry("AnnotateFont"));
    QFontMetrics fm(font());
    setCellHeight(fm.lineSpacing());
    setCellWidth(0);

    items.setAutoDelete(true);
}


void AnnotateView::setFont(const QFont &font)
{
    QTableView::setFont(font);
    QFontMetrics fm(font);
    setCellHeight(fm.lineSpacing());
}


void AnnotateView::addLine(QString rev, QString author,
			   QString date, QString line)
{
    AnnotateViewItem *item = new AnnotateViewItem;
    item->rev = rev;
    item->author = author;
    item->date = date;
    item->line = line;
    items.append(item);
    setNumRows(numRows()+1);
}


int AnnotateView::myCellWidth(int col) const
{
    QFontMetrics fm(font());

    switch (col)
	{
	case 0:  return fm.width("1.0.1.0.1");
	case 1:  return fm.width("012345678")+2*BORDER;
	case 2:  return fm.width("26-Jan-72")+8+2*BORDER;
	default: return 0; // should not occur
	}
}


int AnnotateView::cellWidth(int col)
{
    if (col == 3)
	{
	    int rest = myCellWidth(0) + myCellWidth(1)
		+ myCellWidth(2);
	    return viewWidth() - rest;
	}
    return myCellWidth(col);
}


QSize AnnotateView::sizeHint() const
{
    QFontMetrics fm(font());
    return QSize( myCellWidth(0) + myCellWidth(1)
		  + myCellWidth(2) + 8*fm.width("0123456789"),
		  fm.lineSpacing()*8 );
}


void AnnotateView::paintCell(QPainter *p, int row, int col)
{
    AnnotateViewItem *item = items.at(row);

    int width = cellWidth(col);
    int height = cellHeight();

    QColor backgroundColor;
    int align;
    int innerborder;
    QString str;
    
    if (col == 0)
	{
	    backgroundColor = QColor(222, 222, 222);
	    align = AlignLeft;
	    innerborder = 0;
	    str = item->rev;
	}
    else if (col == 1)
	{
	    backgroundColor = gray;
	    align = AlignCenter;
	    innerborder = BORDER;
	    str = item->author;
	}
    else if (col == 2)
	{
	    backgroundColor = lightGray;
	    align = AlignLeft;
	    innerborder = BORDER;
	    str = item->date;
	}  
    else // col == 3
	{
	    backgroundColor = white;
	    align = AlignLeft;
	    innerborder = 0;
	    str = item->line;
	}
    
    p->fillRect(0, 0, width, height, backgroundColor);
    //    p->setFont("fixed");
    p->drawText(innerborder, 0, width-2*innerborder, height, align, str);
}    
