/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#ifndef _ANNOTATEVIEW_H_
#define _ANNOTATEVIEW_H_

#include <qtableview.h>
#include <qlist.h>


class AnnotateViewItem;

class AnnotateView : public QTableView
{
    Q_OBJECT
    
public:
    AnnotateView( QWidget *parent=0, const char *name=0 );

    void addLine(QString rev, QString author, QString date, QString line);

    virtual void setFont(const QFont &font);
    virtual int cellWidth(int col);
    virtual QSize sizeHint() const;
    virtual void paintCell(QPainter *p, int row, int col);
    
private:
    int myCellWidth(int col) const;
    QList<AnnotateViewItem> items;
};

#endif
