/* 
 *  Copyright (C) 1999-2001 Bernd Gehrmann
 *                          bernd@physik.hu-berlin.de
 *
 * This program may be distributed under the terms of the Q Public
 * License as defined by Trolltech AS of Norway and appearing in the
 * file LICENSE.QPL included in the packaging of this file.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


#include <stdio.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <kfiledialog.h>
#include <kapp.h>
#include <klocale.h>
#include "toplevel.h"
#include "checkoutdlg.h"
#include "cervisiaapp.h"
#include "config.h"
#if QT_VERSION >= 200
#include "kaboutdata.h"
#include "kcmdlineargs.h"
#endif


int main(int argc, char **argv)
{
#if QT_VERSION >= 200
    KAboutData about("cervisia", I18N_NOOP("Cervisia"), VERSION, I18N_NOOP("A CVS frontend"),
                     KAboutData::License_QPL, I18N_NOOP("(c) 1999-2001 Bernd Gehrmann"));
    KCmdLineArgs::init(argc, argv, &about);
#endif
    
    CApplication *app = new CApplication(argc, argv, "cervisia");

    if (argc == 2 &&
        (qstrcmp(argv[1], "-h") == 0 || qstrcmp(argv[1], "--help") == 0))
        {
            fprintf(stderr, "usage: cervisia <directory>\n"
                    "For further options, consult the manpage\n");
            return 1;
        }
    else if (argc == 2 &&
             (qstrcmp(argv[1], "-v") == 0 || qstrcmp(argv[1], "--version") == 0))
        {
            fprintf(stderr, "Cervisia " VERSION "\n");
            return 1;
        }
        
    if ( app->isRestored() )
	{
	    RESTORE(TopLevel);
	}
    else
	{
	    TopLevel *t = new TopLevel();
            QString dirname = QString((argc == 2)? argv[1] : "");
#if QT_VERSION >= 200
	    t->resize(t->sizeHint().width(),
		      KApplication::desktop()->height()*8/10);
#else
	    t->resize(t->childrenRect().width(),
		      KApplication::desktop()->height()*8/10);
#endif
            t->restorePseudo(dirname); 
	    t->setIcon(app->icon());
	    app->setMainWidget(t);
	    t->show();
	}
    
    return app->exec();
}


// Local Variables:
// c-basic-offset: 4
// End:
