/***************************************************************************
                          kconfigure.h  -  description
                             -------------------
    begin                : Sat Dec 11 1999
    copyright            : (C) 1999 by Javier Campos Morales
    email                : javi_c@ctv.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KCONFIGURE_H
#define KCONFIGURE_H
#include <kapp.h>
#include <ktmainwindow.h>
#include <kprocess.h>
#include <qdir.h>
#include <qpopupmenu.h>
#include <qmultilinedit.h>

#include "logWindow.h"
/**
  *@author Javier Campos Morales
  */

class Kconfigure : public KTMainWindow  {
   Q_OBJECT
public: 
	Kconfigure(QWidget *parent=0, const char *name=0);
	~Kconfigure();
  /** Search the configure file */
  void SearchPath(QString=0);
	/* toogle the view of the toolbar */
	void slotViewToolBar();
	/* toogle the view of the output command */
	void slotViewOutput();
  /** toogle the view of the log window */
  void slotViewLog();
  /** Set the Path */
  QDir setDirectory;
	/** Return if it is a fatal error */
	bool FatalError;
protected: // Protected attributes
  /** Exit the application */
  virtual bool queryExit();
	/** Output the messages */
	QMultiLineEdit *output;
	/** Output the messages Errors in a String */
	QString outputStringError;
private: // Private attributes
	void initDialog();
	/* init the menu bar */
	void initMenuBar();
	/* init the menu bar */
	void initToolBar();
  /** Make sure that the file can be install.
	 * Execute su to install the sources.
	 */
  void slotInstall();
	/** Search the Configure File and open a kfile dialog with a filter to find configure.
	 * If the user press cancel or cannot find any configure. The QString return value is NULL.
	 */
  QString SearchConfigure();
  /** Read the config file */
  void readConfig();
  /** Write config options */
  void writeConfig();
  /** Execute configure or Makefiles */
  KShellProcess *q;
  /** The PopUp Menu FILE */
  QPopupMenu *Menufile;
  /** View variable */
  QPopupMenu *Menuview;
  /** The main menu for configure */
  QPopupMenu *Menubuild;
  /** The main menu for configure */
  QPopupMenu *Menuoptions;
  /** The Help menu */
  QPopupMenu *Menuhelp;
  /** Config variable */
  KConfig *config;
  /** Menu variable */
  KMenuBar *MenuBar;
  /** The log window */
  logWindow *LogString;
public slots: // Public slots
  /** Execute a QString */
  void slotAction(QString);

private slots:
  /** Display Output Messages */
  void slotOutputMessages(KProcess*,char*,int);
  /** Display Error Output Messages */
  void slotOutputMessagesError(KProcess*,char*,int);
  /** Filemenu Options */
  void commandCallback(int);
  /** When the action is finish. */
  void slotFinishAction();
  /** Select output text */
  void slotOutputText();
protected slots: // Protected slots
  /** Configure with arguments */
  void slotArguments();
};

#endif
