/***************************************************************************
                          kfilecoder.cpp  -  description                              
                             -------------------                                         
    begin                : lun mai  3 20:19:52 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux
    email                : fdupoux@free.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qpushbt.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qstrlist.h>
#include <qprogressdialog.h>
#include <qwhatsthis.h>
#include <qdragobject.h>
#include <qfileinfo.h>
#include <qcstring.h>
#include <qxembed.h>

// KDE includes
#include <kprogress.h>
#include <kmessagebox.h>
#include <kaccel.h>
#include <kiconloader.h>
#include <kstdaccel.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kpropsdlg.h>
#include <krun.h>
#include <kstddirs.h>
#include <kiconloader.h>
#include <kio/netaccess.h>
#include <kaboutdialog.h>
#include <kpassdlg.h>
#include <kurl.h>
#include <kfiledialog.h>
#include <kedittoolbar.h>
#include <kstdaction.h>
#include <kaction.h>
#include <kdebug.h>
#include <kdirsize.h>
#include <kaboutkde.h>
#include <kbugreport.h>

// unix standard includes
#include <unistd.h>

// application includes
#include "kfilecoder.h"
#include "kfilecoderdoc.h"
#include "filelib.h"
#include "kpropdlg.h"
#include "kextractdlg.h"
#include "kalgodlg.h"
#include "struct.h"
#include "misc.h"
#include "kaboutkfilecoder.h"

// ===========================================================================================================================
KFileCoderApp::KFileCoderApp()
{
 	m_dlgAbout = NULL;
 	
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initGUI();
  setWhatsThis();
  initView();

 ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup

  // Prepare the Drag & Drop
  setAcceptDrops(true);
	
	readOptions();
  updateCommandsAccess();
}

// ===========================================================================================================================
KFileCoderApp::~KFileCoderApp()
{
  delete m_dlgAbout;
}

// ===========================================================================================================================
void KFileCoderApp::updateCommandsAccess()
{	
	bool bDoesListViewContainFiles;
	
	bDoesListViewContainFiles = (m_view -> childCount() > 0);

	actionCollection()->action("file_new")->setEnabled((m_doc -> isArchiveOpened() == false) && (m_doc -> m_bIsWorking == false));
	actionCollection()->action("file_open")->setEnabled((m_doc -> isArchiveOpened() == false) && (m_doc -> m_bIsWorking == false));
	actionCollection()->action("file_open_recent")->setEnabled((m_doc -> isArchiveOpened() == false) && (m_doc -> m_bIsWorking == false));
	actionCollection()->action("file_close")->setEnabled((m_doc -> isArchiveOpened() == true) && (m_doc -> m_bIsWorking == false));
	actionCollection()->action("file_prop")->setEnabled((m_doc -> isArchiveOpened() == true) && (m_doc -> m_bIsWorking == false));
	actionCollection()->action("file_test")->setEnabled((m_doc -> isArchiveOpened() == true) && (m_doc -> m_bIsWorking == false) && bDoesListViewContainFiles);
	actionCollection()->action("file_quit")->setEnabled(m_doc -> m_bIsWorking == false);

	actionCollection()->action("archive_add_file")->setEnabled((m_doc -> isArchiveOpened() == true) && (m_doc -> m_bIsWorking == false));
	actionCollection()->action("archive_add_dir")->setEnabled((m_doc -> isArchiveOpened() == true) && (m_doc -> m_bIsWorking == false));
	actionCollection()->action("archive_extract_all")->setEnabled((m_doc -> isArchiveOpened() == true) && (m_doc -> m_bIsWorking == false) && bDoesListViewContainFiles);
	actionCollection()->action("archive_extract_sel")->setEnabled((m_doc -> isArchiveOpened() == true) && (m_doc -> m_bIsWorking == false) && bDoesListViewContainFiles);
	actionCollection()->action("archive_delete")->setEnabled((m_doc -> isArchiveOpened() == true) && (m_doc -> m_bIsWorking == false) && bDoesListViewContainFiles);

	m_actCompress->setEnabled(m_doc -> m_bIsWorking == false);
}

// ===========================================================================================================================
void KFileCoderApp::setWhatsThis()
{
	actionCollection()->action("archive_add_file")->setWhatsThis(i18n("Add one on more files to the current archive. They will be encoded with the current password"));
	actionCollection()->action("archive_add_dir")->setWhatsThis(i18n("Add all files of a directory to the archive"));
	actionCollection()->action("archive_extract_all")->setWhatsThis(i18n("Extract all files of the archive to the directory you will have to select"));
	actionCollection()->action("archive_extract_sel")->setWhatsThis(i18n("Extract only selected files of the archive to the directory you will select"));
	actionCollection()->action("archive_delete")->setWhatsThis(i18n("Delete the selected files of the archive. After, they won't be in archive."));
}

// ===========================================================================================================================
void KFileCoderApp::initGUI()
{
	// File
	KStdAction::openNew(this, SLOT(slotFileNew()), actionCollection(), "file_new");
	KStdAction::open(this, SLOT(slotFileOpen()), actionCollection(), "file_open");
	KStdAction::openRecent(this, SLOT(openURL(const KURL&)), actionCollection(), "file_open_recent");
	KStdAction::close(this, SLOT(slotFileClose()), actionCollection(), "file_close");
	(void)new KAction(i18n("&Properties"), "fileprop", 0, this, SLOT(slotFileProperties()), actionCollection(), "file_prop");
	(void)new KAction(i18n("&Test archive"), 0, this, SLOT(slotFileTest()), actionCollection(), "file_test");
	KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection(), "file_quit");

	// Archive
	(void)new KAction(i18n("&Add files..."), "addfile", 0, this, SLOT(slotArchiveAddFile()), actionCollection(), "archive_add_file");
	(void)new KAction(i18n("&Add directory..."), "adddir", 0, this, SLOT(slotArchiveAddDir(QString)), actionCollection(), "archive_add_dir");
	(void)new KAction(i18n("&Extract all..."), "extract", 0, this, SLOT(slotArchiveExtractAll()), actionCollection(), "archive_extract_all");
	(void)new KAction(i18n("&Extract selected..."), "extract", 0, this, SLOT(slotArchiveExtractSel()), actionCollection(), "archive_extract_sel");
	(void)new KAction(i18n("&Delete..."), "delete", 0, this, SLOT(slotArchiveDelete()), actionCollection(), "archive_delete");
	
	// Options
	KStdAction::configureToolbars(this, SLOT(slotFileConfigureToolbars()), actionCollection(), "toolbars");
	m_actCompress = new KSelectAction(i18n("Compression"), 0, this, SLOT(slotOptionsCompress()), actionCollection(), "options_compress");
	QStringList strlCompressModes;
	strlCompressModes << "None" << "Gzip" << "Bzip2";
	m_actCompress->setItems(strlCompressModes);
		
	// Help menu
	setHelpMenuEnabled(false);
	KStdAction::aboutApp(this, SLOT(showAboutApplication(void)), actionCollection());
	KStdAction::helpContents(this, SLOT(appHelpActivated()), actionCollection());
	KStdAction::whatsThis(this, SLOT(contextHelpActivated()), actionCollection());
	KStdAction::reportBug(this, SLOT(reportBug()), actionCollection());
	KStdAction::aboutKDE(this, SLOT(aboutKDE()), actionCollection());

	// Status bar
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG);
	
	// Create GUI
	createGUI();
}

// ===========================================================================================================================
void KFileCoderApp::initView()
{
	m_doc = new KFileCoderDoc(this);

	////////////////////////////////////////////////////////////////////
	// set the main widget here

	m_view = new QListView(this);
	m_view ->setAcceptDrops(false); // Drag & Drop
	QWhatsThis::add(m_view, i18n("The list of all the files of the archive"));

	setView(m_view);
	m_doc -> setListView(m_view);
	
	m_view -> addColumn(i18n("Name"), 250);
	m_view -> setColumnWidthMode (0, QListView::Maximum);
	
	m_view -> addColumn(i18n("Decoded size"), 100);
	m_view -> setColumnAlignment(1, 2);
	m_view -> setColumnWidthMode (1, QListView::Maximum);

	m_view -> addColumn(i18n("Encoded size"), 100);
	m_view -> setColumnAlignment(2, 2);
	m_view -> setColumnWidthMode (2, QListView::Maximum);

	m_view -> addColumn(i18n("Path"), 300);
	m_view -> setColumnWidthMode (3, QListView::Maximum);

	m_view -> addColumn(i18n("Permissions"), 80);
	m_view -> setColumnWidthMode (4, QListView::Maximum);

	m_view -> addColumn(i18n("Owner / Group"), 100);
	m_view -> setColumnWidthMode (5, QListView::Maximum);

	m_view -> addColumn(i18n("Compression"), 50);
	m_view -> setColumnWidthMode (6, QListView::Maximum);

	m_view -> addColumn(i18n("Ratio"), 50);
	m_view -> setColumnWidthMode (7, QListView::Maximum);

	m_view -> setSorting(-1); // Disable sorting for all columns
	m_view -> setMultiSelection(true);

	m_view -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
	m_view -> setLineWidth(2);
	m_view -> setItemMargin(3);
}

// ===========================================================================================================================
void KFileCoderApp::setWorking(bool bIsWorking)
{	
	m_doc->m_bIsWorking = bIsWorking;
	
	if (bIsWorking)
	{
		QApplication::setOverrideCursor(Qt::waitCursor);
	}
	else
	{	QApplication::restoreOverrideCursor();	
		slotStatusMsg(IDS_DEFAULT);
	}
		
	updateCommandsAccess();
}

// ===========================================================================================================================
void KFileCoderApp::closeEvent (QCloseEvent *event)
{
	saveOptions();
	
	if (m_doc->m_bIsWorking)
	{	KMessageBox::error(this, i18n("Can't exit before the end of the operation."));
		return;
	}
	
	KTMainWindow::closeEvent(event);
}

// ===========================================================================================================================
void KFileCoderApp::slotFileProperties()
{
	KPropDlg dlg(m_doc -> getArchivePath(), m_doc -> getNbFiles(), m_doc -> getAlgoUsed(), this, NULL);
	dlg.exec();
}

// ===========================================================================================================================
void KFileCoderApp::slotFileTest()
{
	long int nErrors; // number of error files
	QString strMess;
	QString strErrorFiles;
	
	nErrors = m_doc -> testFiles(&strErrorFiles);
	
	if (nErrors == -1)
	{	KMessageBox::error(this, i18n("Test function failed"));
	}
	else if (nErrors == 0)
	{	KMessageBox::information(this, i18n("All files were tested and are good. No error detected in the archive"));
	}
	else if (nErrors > 0)
	{	strMess.sprintf(i18n("<p><big><b>All files of the archive were tested. %ld ones have errors in data, and won't be extractible successfully</b></big></p><ul>%s</ul>"), nErrors, strErrorFiles.data());
		KMessageBox::error(this, strMess);
	}	
}

// ===========================================================================================================================
void KFileCoderApp::saveOptions()
{
	KConfig *config = kapp->config();

	config->setGroup("General Options");
	config->writeEntry("Geometry", size());
	config->writeEntry("ShowToolbar",toolBar()->isVisible());
	config->writeEntry("ShowStatusbar", statusBar()->isVisible());
	config->writeEntry("ToolBarPos", (int)toolBar()->barPos());
	config->writeEntry("Recent files", m_recentStringFileList);

	config->setGroup("Misc");
	config->writeEntry("compress", m_actCompress->currentItem());
	config->writeEntry("Recent files", m_recentStringFileList);
	
	config->sync();
}

// ===========================================================================================================================
void KFileCoderApp::readOptions()
{
	KConfig *config = kapp->config();
	QSize size;
	int nTemp;
	
	config->setGroup("General Options");
	size = config -> readSizeEntry("Geometry");
	if (size.isEmpty()) // If no size ==> Default size
	{
		size = QSize(320,240);
		move(0,0);
	}
	resize(size);

	m_bViewToolbar = config->readBoolEntry("ShowToolbar", true);
	m_bViewStatusbar = config->readBoolEntry("ShowStatusbar", true);
	KToolBar::BarPosition tool_bar_pos = (KToolBar::BarPosition)config->readNumEntry("ToolBarPos", KToolBar::Top);

	if (!m_bViewToolbar)
		enableToolBar(KToolBar::Hide);

	if (!m_bViewStatusbar)
		enableStatusBar(KStatusBar::Hide);

	toolBar() -> setBarPos(tool_bar_pos);

	config->setGroup("Misc");
	nTemp = config->readNumEntry("compress", COMPRESS_GZIP);
	m_actCompress->setCurrentItem(nTemp);
	
	// Recent files
	m_recentStringFileList = config->readListEntry("Recent files");
	((KRecentFilesAction *) actionCollection()->action("file_open_recent"))->setItems(m_recentStringFileList);
	
	updateCommandsAccess();
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

// ===========================================================================================================================
void KFileCoderApp::slotFileOpen()
{
	KURL urlFile;

	urlFile = KFileDialog::getOpenURL(QString::null, i18n("*.kfc|KFileCoder archives (*.kfc)\n*|All files (*.*)"), this, i18n("Open KFileCoder archive"));
	if (urlFile.isEmpty())
	    return;

	setWorking(true);
	
	openURL(urlFile);
	
	setWorking(false);
}

// ===========================================================================================================================
void KFileCoderApp::openURL(const KURL &urlFile)
{
	QString strFilename;
	QString strMess;
	int nRes;
	QFileInfo fi;
	BYTE cPassword[ENCODING_LEN+1];

	// Download file if need (if url is "http://...")
	if (!(KIO::NetAccess::download(urlFile, strFilename))) // Open the Archive
		return;

	// Check it's not a directory
	fi.setFile(strFilename);
	if (fi.isDir())
	{	KMessageBox::error(this, i18n("Can't open directories."));
		return;
	}

	// The file doesn't exists: create ?
	if (!fi.exists())
	{	strMess.sprintf(i18n("The archive <b>%s</b> doesn't exists. Do you want to create it ? ."), strFilename.data());
		if (KMessageBox::questionYesNo(this, strMess, "KFileCoder") == KMessageBox::No) // No clicked
			return;

		// Yes ==> Create a new archive
		createNewArchive(strFilename);
		return;
	}
		
	// Dialog to ask password ==> cPassword
	nRes = askPassword(cPassword);
	if (nRes == -1)
		return ;
			
	// Add file to "load strings form file" menu
	if (!m_recentStringFileList.contains(strFilename))
	{	
		m_recentStringFileList.append(strFilename);
		((KRecentFilesAction *) actionCollection()->action("file_open_recent"))->setItems(m_recentStringFileList);
	}
	
	nRes = m_doc -> openArchive(strFilename.data(), cPassword);

	// Update menu & toolbar commands
	updateCommandsAccess();
}

// ===========================================================================================================================
void KFileCoderApp::dragEnterEvent(QDragEnterEvent *event)
{
	event -> accept(QUriDrag::canDecode(event));
}

// ===========================================================================================================================
void KFileCoderApp::deleteSelectedFilesInArchive()
{
	int nRes;
	
	nRes = m_doc -> deleteSelectedFilesInArchive();
	if (nRes == -1)
		m_doc -> closeArchive();
	
	// Update menu & toolbar commands
	updateCommandsAccess();
}

// ===========================================================================================================================
void KFileCoderApp::dropEvent(QDropEvent *event)
{
	QStrList urls;
	QString strUrl;
	QFileInfo fi;
	int i;
	int nRes;
	
	if (QUriDrag::decode(event, urls))
	{
		// if no archive opened, open it
		if (!m_doc->isArchiveOpened())
		{
			if (urls.first())
				openURL(urls.first());
		}
		else // an archive is already opened ==> add files
		{
			for (i=0; i < (int) urls.count(); i++)
			{
				if (urls.at(i))
				{
					KURL url(urls.at(i));
					fi.setFile(url.path());
					
					// If URL is a directory
					if (fi.isDir())
					{	slotArchiveAddDir(url.path());
					}
					else // if a file
					{	setWorking(true);
						nRes = m_doc->addFile(url, m_actCompress->currentItem());
						setWorking(false);
						if (nRes == ERROR_FAILED)
							return;
					}
									
				}
			}		
		}
	}
	
	// Update menu & toolbar commands
	updateCommandsAccess();
}

// ===========================================================================================================================
void KFileCoderApp::slotFileNew()
{
	QString strFilename;
	int nRes;

	// Select the new file
	strFilename = KFileDialog::getSaveFileName(QString::null, i18n("*.kfc|KFileCoder archives (*.kfc)\n*|All files (*.*)"), this,i18n("New KFileCoder archive"));
	if (strFilename.isEmpty())
		return;

	// Force the extension to be "kfc"
	strFilename = addFilenameExtension(strFilename, "kfc");
	
	nRes = createNewArchive(strFilename);
	slotStatusMsg(IDS_DEFAULT);
}

// ===========================================================================================================================
int KFileCoderApp::askPassword(BYTE *szDestPass)
{
	QString strMess;
	QCString strPass;
	int nRes;
	
	// Ask password with the dialog box
	do
	{	nRes = KPasswordDialog::getNewPassword(strPass, i18n("Please, enter the password which will be used to encode files."));
		if (nRes != KPasswordDialog::Accepted)
			return ERROR_FAILED;

		// check the minimum password size is oaky
		if (strPass.length() < MIN_BYTELEN || strPass.length() > MAX_BYTELEN)
		{	strMess.sprintf(i18n("The size of a password must be between %d and %d characters."), MIN_BYTELEN, MAX_BYTELEN);
			KMessageBox::error(this, strMess);
		}
	} while (strPass.length() < MIN_BYTELEN || strPass.length() > MAX_BYTELEN);

	// resize the password to ENCODING_LEN bytes
	makePasswordLength(szDestPass, ENCODING_LEN, (BYTE *)strPass.data(), strPass.length()); // force password to have a length equal to dwPassLen
	
	return ERROR_SUCCESS;
}

// ===========================================================================================================================
int KFileCoderApp::createNewArchive(QString strFilename)
{
	int nRes;
	KURL urlFile;
	DWORD dwAlgorithm;
	BYTE cPassword[ENCODING_LEN+1];
	
	// Dialog to ask password ==> cPassword
	nRes = askPassword(cPassword);
	if (nRes == -1)
		return ERROR_FAILED;
		
	// ask algorithm to use
	KAlgoDlg dlg(this);
	nRes = dlg.exec();
	if (nRes == QDialog::Rejected)
		return ERROR_FAILED;
	dwAlgorithm = dlg.getAlgo();

	// Add file to "load strings form file" menu
	if (!m_recentStringFileList.contains(strFilename))
	{	
		m_recentStringFileList.append(strFilename);
		((KRecentFilesAction *) actionCollection()->action("file_open_recent"))->setItems(m_recentStringFileList);
	}
		
	nRes = m_doc -> createArchive(strFilename.data(), cPassword, dwAlgorithm);
	if (nRes == -1)
		return ERROR_FAILED;		
	
	// Update menu & toolbar commands
	updateCommandsAccess();
}

// ===========================================================================================================================
void KFileCoderApp::slotFileClose()
{
	if (m_doc->m_bIsWorking)
	{	KMessageBox::error(this, i18n("Can't exit before the end of the operation."));
		return;
	}
	
 	m_doc -> closeArchive();
	
	// Update menu & toolbar commands
	updateCommandsAccess();
	slotStatusMsg(IDS_DEFAULT);
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveAddFile()
{	
	QStringList strlFileList;
	QString strCurrentFile;
	int nRes;
	int nPos = 0; // Nb of files added
	KURL::List urlFilesList;
	int i;

	// The user select files to add to archive
	urlFilesList = KFileDialog::getOpenURLs(QString::null, QString::null,this,i18n("Add files to archive"));
		if (urlFilesList.count() == 0)
			return;

	// Draw the progress dialog
	QProgressDialog dlgProgress(i18n("Adding files to archive..."),0, strlFileList.count(), this,"",true);
	dlgProgress.setCaption("KFileCoder");
	dlgProgress.show();
	dlgProgress.setProgress(nPos);
	
	// cursor = wait + disable menus
	setWorking(true);
	
	for (i=0; i < (int)urlFilesList.count(); i++) // While not end of list
	{	// Add a file to archive
		nRes = m_doc -> addFile(urlFilesList[i], m_actCompress->currentItem());
		dlgProgress.setProgress(++nPos);
		if (dlgProgress.wasCancelled())
			break;
	}

	// cursor = wait + disable menus
	setWorking(false);
	
	// Update menu & toolbar commands
	updateCommandsAccess();
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveAddDir(QString strDir)
{	
	int nRes;
	QWORD qwDirSize;
	QString strAdding;
	
	// The user select files to add to archive
	if (strDir.isEmpty())
	{	strAdding = KFileDialog::getExistingDirectory(QString::null, this, i18n("Add directory to archive..."));
		if (strAdding.isEmpty())
			return ;
	}
	else
	{	strAdding = strDir;
	}
	
	// cursor = wait + disable menus
	setWorking(true);

  statusBar()->insertItem(i18n("Calculating the directory size..."), ID_STATUS_MSG);
	KURL urlDir(strAdding);
	qwDirSize = (QWORD) KDirSize::dirSize(urlDir);
	nRes = m_doc -> addDirectory(strAdding, m_actCompress->currentItem(), qwDirSize, NULL);

	// cursor = wait + disable menus
	setWorking(false);
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveExtractAll()
{
	char szDestPath[MAXPATHLEN];
	int nRes;	

	// Dialog to select the destination directory
	KExtractDlg extractDlg(this);
	nRes = extractDlg.exec();
	if (nRes == -1)
		return;
	
	// cursor = wait + disable menus
	setWorking(true);

	sprintf (szDestPath, "%s", extractDlg.getDestinationDirectory());

	m_doc -> extractFiles(szDestPath, false);
	
	// cursor = wait + disable menus
	setWorking(false);
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveExtractSel()
{
	char szDestPath[MAXPATHLEN];
	int nRes;	

	// Dialog to select the destination directory
	KExtractDlg extractDlg(this, (const char*) 0);
	nRes = extractDlg.exec();
	if (nRes == -1)
		return;

	// cursor = wait + disable menus
	setWorking(true);
	
	sprintf (szDestPath, "%s", extractDlg.getDestinationDirectory());

	m_doc -> extractFiles(szDestPath, true);
	
	// cursor = wait + disable menus
	setWorking(false);
}

// ===========================================================================================================================
void KFileCoderApp::slotArchiveDelete()
{
	if (!m_doc->isArchiveOpened())
		return;

	// cursor = wait + disable menus
	setWorking(true);
		
	m_doc -> deleteSelectedFilesInArchive();
	
	// cursor = wait + disable menus
	setWorking(false);
}

// ===========================================================================================================================
void KFileCoderApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new Application window..."));
  (new KFileCoderApp)->show();
  slotStatusMsg(IDS_DEFAULT);
}

// ===========================================================================================================================
void KFileCoderApp::slotFileQuit()
{
	saveOptions();
	
	if (m_doc->m_bIsWorking)
	{	KMessageBox::error(this, i18n("Can't exit before the end of the operation."));
		return;
	}

  slotFileClose();

  ///////////////////////////////////////////////////////////////////
  // exits the Application

	/*KTMainWindow *w;
	if (memberList)
	{
		for (w=memberList->first(); w; w = memberList->first())
		{
			if (!w->close())
				break;
		}
	}*/
    
	kapp->quit();
}

// ===========================================================================================================================
void KFileCoderApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  m_bViewToolbar=!m_bViewToolbar;
  //menuBar()->setItemChecked(ID_VIEW_TOOLBAR, m_bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  slotStatusMsg(IDS_DEFAULT);

	// Update menu & toolbar commands
	updateCommandsAccess();
}

// ===========================================================================================================================
void KFileCoderApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  m_bViewStatusbar=!m_bViewStatusbar;
  //menuBar()->setItemChecked(ID_VIEW_STATUSBAR, m_bViewStatusbar);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
	
	// Update menu & toolbar commands
	updateCommandsAccess();
}


// ===========================================================================================================================
void KFileCoderApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}

// ===========================================================================================================================
void KFileCoderApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

// ===========================================================================================================================
// This function may not be used. Delete in the final release if can't work
void KFileCoderApp::showAboutApplication()
{
	printf ("===================>showAboutApplication()\n");

  if(m_dlgAbout == NULL)
  {	m_dlgAbout = new KAboutKFileCoder(this, 0, false);
    if(m_dlgAbout == NULL) { return; }
  }

  if( m_dlgAbout->isVisible() == false )
  {
    m_dlgAbout->show();
  }
  else
  {
    m_dlgAbout->raise();
  }
	
	// Update menu & toolbar commands
	updateCommandsAccess();
}

// ===========================================================================================================================
void KFileCoderApp::slotFileConfigureToolbars()
{
	KEditToolbar edit(actionCollection());
	if (edit.exec() == true)
	{
		createGUI();
	}
	
	// Update menu & toolbar commands
	updateCommandsAccess();
}

// ===========================================================================================================================
void KFileCoderApp::slotOptionsCompress()
{
	return;
}

// ===========================================================================================================================
void KFileCoderApp::appHelpActivated()
{
  kapp->invokeHelp();
}

// ===========================================================================================================================
void KFileCoderApp::contextHelpActivated()
{
  QWhatsThis::enterWhatsThisMode();
  QWidget* w = QApplication::widgetAt( QCursor::pos(), TRUE );
  while ( w && !w->isTopLevel() && !w->inherits("QXEmbed")  )
      w = w->parentWidget();
   if ( w && w->inherits("QXEmbed") )
	  (( QXEmbed*) w )->enterWhatsThisMode();
}

// ===========================================================================================================================
void KFileCoderApp::aboutKDE()
{
	KAboutKDE dlg(this, "aboutkde", true);
	dlg.show();
}

// ===========================================================================================================================
void KFileCoderApp::reportBug()
{
	KBugReport dlg(this, true);
	dlg.show();
}











