/***************************************************************************
                          misc.cpp  -  description
                             -------------------
    begin                : Sun Jul 9 2000
    copyright            : (C) 2000 by Franois Dupoux
    email                : fdupoux@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>

#include "resource.h"
#include "algo_pc1.h"
#include "misc.h"

// the constant key used to hash numbers (to calculate a control hash table)
BYTE g_cConstantKey[] = {32, 133, 237, 158, 248, 54, 91, 79, 101, 154, 113, 217, 255, 87, 153, 95};
// must have a size of ENCODING_LEN bytes

// ===========================================================================================================================
// cPass is the password user to hash the buffer. If cPass is NULL, then the constant key
// must be used
int calculatePC1Hash(BYTE *cHash, const BYTE *cBuffer, DWORD dwBufferLen, const BYTE *cPass)
{
	DWORD z, end;
	DWORD dwCount, dwBufferPos, dwHashPos;
	BYTE pcKey[ENCODING_LEN+1];
	BYTE cCurChar;

	UINT pcSi, pcX1a2, pcI, pcInter, pcCfc, pcCfd, pcX1a0[8];

	pcSi=0;
	pcX1a2=0;
	pcI=0;

	// initialize key
	if (cPass) // if the key was passed
	{	memcpy(pcKey, cPass, ENCODING_LEN);
	}
	else // key not passed ==> use the constant key
	{	memcpy(pcKey, g_cConstantKey, ENCODING_LEN);
	}

  dwHashPos = 0;

  // initialize the hash to zero
  memset(cHash, 0, ENCODING_LEN);

	// first part: encoding
  // for every byte of the buffer...
	for (dwBufferPos = 0; dwBufferPos < dwBufferLen; dwBufferPos++)
	{
		cCurChar = cBuffer[dwBufferPos];
	
		pc1Assemble(pcX1a0, pcKey, &pcInter, &pcI, &pcX1a2, &pcSi);
		
		pcCfc = pcInter >> 8;
		pcCfd = pcInter & 255;  // pcCfc ^ pcCfd = ramdom byte

		for (dwCount=0; dwCount < ENCODING_LEN; dwCount++)
			pcKey[dwCount] ^= cCurChar;

		cCurChar ^= (pcCfc ^ pcCfd);

		cHash[dwHashPos] ^= cCurChar;

    dwHashPos++;
    if (dwHashPos >= ENCODING_LEN)
    	dwHashPos = 0;
	}
	
	
	// second part:
	// re-encode the hash table
	end = (ENCODING_LEN+1)*ENCODING_LEN;

	for (z=1; z <= end; z++)
	{
		cCurChar = cHash[dwHashPos];

		pc1Assemble(pcX1a0, pcKey, &pcInter, &pcI, &pcX1a2, &pcSi);
		
		pcCfc = pcInter >> 8;
		pcCfd = pcInter & 255;  // pcCfc ^ pcCfd = random byte

		for (dwCount = 0; dwCount < ENCODING_LEN; dwCount++)
			pcKey[dwCount] ^= cCurChar;

		cCurChar ^= (pcCfc ^ pcCfd);

		cHash[dwHashPos] ^= cCurChar;

		dwHashPos++;
		if (dwHashPos >= ENCODING_LEN)
			dwHashPos = 0;
	}

	return ERROR_SUCCESS;
}

// ===========================================================================================================================
void makePasswordLength(BYTE *cDestPass, DWORD dwPassLen, const BYTE *cSrcPass, DWORD dwOldPassLen) // force password to have a length equal to dwPassLen
{
	DWORD i;
	BYTE cTempPassword[1024];

	// if empty password
	if (dwOldPassLen == 0)
		return;
	
	memset(cDestPass, 0, dwPassLen);	
	memset(cTempPassword, 0, dwPassLen);	
	
	// if password is good
	if (dwOldPassLen == dwPassLen)
	{	memcpy(cTempPassword, cSrcPass, dwOldPassLen);
	}
		
	// if password is too long
	else if (dwOldPassLen > dwPassLen)
	{
		// copy the first good len
		memcpy(cTempPassword, cSrcPass, dwPassLen);
			
		// XOR to make the end of the password modify the first part
		for (i=dwPassLen; i < dwOldPassLen ; i++)
			cTempPassword[(i-dwPassLen) % dwPassLen] ^= cSrcPass[i];
	}
	
	// if password is too short
	else if (dwOldPassLen < dwPassLen)
	{
		// add other bytes to complete (example: "ABCDEF" ==> "ABCDEFABCDEFABCD")
		for (i=0; i < dwPassLen-1 ; i++)
			cTempPassword[i] = cSrcPass[i % dwOldPassLen];
		
		// the last byte of the password is the length of the password of the user.
		// Then, "XXX" and "XXXX" are now differents passwords.			
		cTempPassword[dwPassLen-1] = (BYTE) dwOldPassLen;
	}
	
	// Hash the password. Then two password which have many common bytes will
	// become really differents
	
	// in cTempPassword, there is a password which length is dwPassLen bytes
	calculatePC1Hash(cDestPass, cTempPassword, dwPassLen, 0); // hash with the constant key
	
	//printf ("\nmakePasswordLength(%s) = (%s)\n\n", printfBuffer(cSrcPass, dwOldPassLen).data() , printfBuffer(cDestPass, ENCODING_LEN).data());
}

// ===========================================================================================================================
QString printfBuffer(const BYTE *cBuffer, DWORD dwLen)
{
	DWORD i;
	QString strResult;
	QString strTemp;
	
	for (i=0; i < dwLen; i++)
	{	strTemp.sprintf("%.2X ", cBuffer[i]);
		strResult += strTemp;
	}
		
	strTemp.sprintf(" (Len=%ld)", dwLen);
	strResult += strTemp;
	
	return strResult;
}

// ===========================================================================================================================
QString printfCharBuffer(const BYTE *cBuffer, DWORD dwLen)
{
	DWORD i;
	QString strResult;
	QString strTemp;
	
	for (i=0; i < dwLen; i++)
	{		
		if (cBuffer[i] == 0)
			strTemp.sprintf("0");
		else if (cBuffer[i] > 32)
			strTemp.sprintf("%c", cBuffer[i]);
		else
			strTemp.sprintf(".");
			
		strResult += strTemp;
	}
		
	return strResult;
}

// ===========================================================================================================================
// return -1 if failed
//         0 if okay (gzip is present)
int checkCompress(char *szFile, char *szCompressApp)
{	
	char szCommand[1024];
	FILE *fGzipTube;
	int nRes;
	
	sprintf(szCommand, "%s -c \"%s\"", szCompressApp, szFile);
	
	fGzipTube = popen(szCommand, "r");
	if (!fGzipTube)
	 	return ERROR_FAILED;

	// try to read a byte from the file
	nRes = fgetc(fGzipTube);
	
	pclose(fGzipTube);

	if (nRes == EOF)
		return ERROR_FAILED;
	else
		return ERROR_SUCCESS;
}


