/***************************************************************************
                          random.cpp  -  PC2 random generator
                             -------------------
    copyright            : (C) 1992 by Alexandre PUKALL

 written using Borland Turbo C 2.0
 PC2 encoding algorithm (Pukall Cipher 2)
 by (c) Alexandre PUKALL 1992

 free code no restriction to use
 please include the name of the Author in the final software
 the Key is 128 bits

 This algorithm was written in asm language under Motorola 6809

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <syscall.h>
#include <unistd.h>
#include <linux/kernel.h>
#include <sys/vfs.h>
#include <time.h>

#include "random.h"
#include "misc.h"

DWORD g_dec, g_cod1, g_cod2, g_vart1, g_vart2;
short int c=0;
short int c1=0;

// ===========================================================================================================================
void generateRandomNumber(BYTE *cMixer)
{
	DWORD dwRandom0;
	DWORD dwRandom1;
	DWORD dwRandom2;
	DWORD dwRandom3;
	BYTE cRandomBuffer[ENCODING_LEN+1];
	BYTE cBuffer[ENCODING_LEN+1];
	struct sysinfo infos;
	struct statfs stats;
	BYTE cPc2Key[8]; // 64 bits pc2 key
	DWORD i;
	
	// get infos on system	
	syscall(SYS_sysinfo, &infos);
	statfs("/etc/inittab", &stats);
	
	// 1. generate data with rand() to fill buffer
	pc2Encode(cBuffer, ENCODING_LEN);
		
	// create a 128 bits hash from a 32 bits time number, using the constant key
	calculatePC1Hash(cRandomBuffer, cBuffer, ENCODING_LEN, 0);
	
	// create a 64 bits key from the 128 bits hash
	memcpy(&dwRandom0, cRandomBuffer+(0*sizeof(DWORD)), sizeof(DWORD));
	memcpy(&dwRandom1, cRandomBuffer+(1*sizeof(DWORD)), sizeof(DWORD));
	memcpy(&dwRandom2, cRandomBuffer+(2*sizeof(DWORD)), sizeof(DWORD));
	memcpy(&dwRandom3, cRandomBuffer+(3*sizeof(DWORD)), sizeof(DWORD));
	dwRandom0 ^= dwRandom2;
	dwRandom1 ^= dwRandom3;
	
	// copy 2 * 32 bits into an 64 bits number
	memcpy(cPc2Key+(0*sizeof(DWORD)), &dwRandom0, sizeof(DWORD));
	memcpy(cPc2Key+(1*sizeof(DWORD)), &dwRandom1, sizeof(DWORD));
	
	// pc2Encode (input buffer = cConstantPc2Key, password = 64 bits cPc2Key, output = 128 random bytes in cBuffer)
	pc2Encode(cBuffer, ENCODING_LEN);
	
	// 2. mix random data with memory infos random data
	dwRandom0 = (DWORD) infos.freeram;
	dwRandom1 = (DWORD) infos.freeswap;
	dwRandom2 = (DWORD) infos.sharedram;
	dwRandom3 = (DWORD) infos.bufferram;
	memcpy(cRandomBuffer+(0*sizeof(DWORD)), &dwRandom0, sizeof(DWORD));
	memcpy(cRandomBuffer+(1*sizeof(DWORD)), &dwRandom1, sizeof(DWORD));
	memcpy(cRandomBuffer+(2*sizeof(DWORD)), &dwRandom2, sizeof(DWORD));
	memcpy(cRandomBuffer+(3*sizeof(DWORD)), &dwRandom3, sizeof(DWORD));
	
	for (i=0L; i < ENCODING_LEN; i++)
		cBuffer[i] ^= cRandomBuffer[i];
	
	// 3. mix random data with
	dwRandom0 = (DWORD) (16 * infos.procs) + (32 * getuid()) + (64 * geteuid()) + (128 * getgid()) + (256 * getegid()); // number of processes
	dwRandom1 = (DWORD) stats.f_bsize * stats.f_bavail; // free space on disk where the file is written
	dwRandom2 = (DWORD) stats.f_type * stats.f_blocks;
	dwRandom3 = (DWORD) stats.f_namelen * stats.f_files;
	memcpy(cRandomBuffer+(0*sizeof(DWORD)), &dwRandom0, sizeof(DWORD));
	memcpy(cRandomBuffer+(1*sizeof(DWORD)), &dwRandom1, sizeof(DWORD));
	memcpy(cRandomBuffer+(2*sizeof(DWORD)), &dwRandom2, sizeof(DWORD));
	memcpy(cRandomBuffer+(3*sizeof(DWORD)), &dwRandom3, sizeof(DWORD));
	
	for (i=0L; i < ENCODING_LEN; i++)
		cBuffer[i] ^= cRandomBuffer[i];
	
	// 4. hash the new random number with a constant key to make the number really random
	calculatePC1Hash(cMixer, cBuffer, ENCODING_LEN, 0);
}

// ===========================================================================================================================
UINT pc2Mul()
{
	UINT resultat,fois;

	if (g_vart1 == 0)
	{
		resultat=pc2Byte();
		g_vart1=(resultat*256)+pc2Byte();

		if (g_vart1 == 0)
		{
			g_vart1=g_cod1;
		}
	}
	if (g_vart2 == 0)
	{
		resultat=pc2Byte();
		g_vart2=(resultat*256)+pc2Byte();

		if (g_vart2 == 0)
		{
			g_vart2=g_cod2;
		}
	}

	fois=g_vart1*g_vart2;
	return fois;
}

// ===========================================================================================================================
UINT pc2Exp(UINT ex)
{
  UINT z;
  UINT tot=0;

  if (ex==0) tot=1;
  if (ex==1) tot=2;
  if (ex>1)
    {
	tot=2;
	for (z=2;z<=ex;z++)
	{
	  tot=tot*2;
	}
    }
  return tot;
}

// ===========================================================================================================================
UINT pc2Byte()
{
  UINT res,puiss,otct;
  otct=0;
  for (puiss=0;puiss<=7;puiss++)
   {
     res=pc2Decal();
     otct = otct + ( res * ( pc2Exp(puiss) ) );
   }
   return otct;
}

// ===========================================================================================================================
UINT pc2Decal()
{
  g_dec = (((((g_dec>>31) ^ (g_dec>>6) ^ (g_dec>>4) ^ (g_dec>>2) ^ (g_dec>>1)
	^ g_dec)) & 0x00000001) <<31) | (g_dec>>1);
  return g_dec & 0x00000001;
}

// ===========================================================================================================================
void pc2Init()
{
	DWORD decall;
	DWORD dwTime;
	BYTE cTime[sizeof(DWORD)+1];
	BYTE cKey[] = {108, 58, 59, 192, 84, 42, 171, 186};

	dwTime = time(0);
	memcpy(cTime, &dwTime, sizeof(DWORD));
	
	cKey[0]=cTime[0];
	cKey[1]=cTime[1];
	cKey[2]=cTime[2];
	cKey[3]=cTime[3];

	g_dec=0;

	decall=cKey[0];
	decall=decall<<24;
	g_dec += decall;

	decall=cKey[1];
	decall=decall<<16;
	g_dec += decall;

	decall=cKey[2];
	decall=decall<<8;
	g_dec += decall;

	g_dec += cKey[3];

	g_cod1=0;
	decall=cKey[4];
	decall=decall<<8;
	g_cod1+=decall;

	g_cod1+=cKey[5];

	g_cod2=0;
	decall=cKey[6];
	decall=decall<<8;
	g_cod2+=decall;

	g_cod2 += cKey[7];

	memset(cKey, 0, PC2_KEY_LEN);

	g_vart1=g_cod1;
	g_vart2=g_cod2;
}	

// ===========================================================================================================================
void pc2Encode(BYTE *cResult, DWORD dwLen)
{
	UINT final1,cfc,cfd;
	UINT a1,a2,a3,a4;
	DWORD dwBufferPos;
  	
	for (dwBufferPos=0;dwBufferPos<dwLen;dwBufferPos++)
	{
  	final1=pc2Mul();

  	a1=pc2Byte()*256;
  	a2=pc2Byte();
  	a3=pc2Byte()*256;
  	a4=pc2Byte();

  	g_vart1=(g_vart1^final1) ^ ( a1+a2 );
  	g_vart2=(g_vart2^final1) ^ ( a3+a4 );
  	g_dec ^= final1;
  	cfc=final1 >> 8;
  	cfd=final1 & 255;  // cfc^cfd = random byte

  	// K ZONE !!!!!!!!!!!!!

  	g_vart1 ^= 0x41;
  	g_dec ^= 0x41;

  	c ^= (cfc^cfd); // encoding
  	c1 = c & 0xffff;
  	
  	// write the result in the buffer
  	*(cResult+dwBufferPos) = (BYTE) c1;
  }


}
