/***************************************************************************
filter.h  -  description
-------------------
begin                : Sun Mar 19 11:30:14 MET 2000
copyright            : (C) 2000 by Martin Erdtmann
email                : martin.erdtmann@gmx.de
***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#ifndef FILTER_H
#define FILTER_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


// include files for KDE 
#include <kapp.h>
#include <kmenubar.h>
#include <kmainwindow.h>
#include <kaccel.h>

// forward declaration of the Filter classes
class FilterDoc;
class FilterView;

/**
* The base class for Filter application windows. It sets up the main
* window and reads the config file as well as providing a menubar, toolbar
* and statusbar. An instance of FilterView creates your center view, which is connected
* to the window's Doc object.
* FilterApp reimplements the methods that KTMainWindow provides for main window handling and supports
* full session management as well as keyboard accelerator configuration by using KAccel.
* @see KTMainWindow
* @see KApplication
* @see KConfig
* @see KAccel
*
* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
* @version KDevelop version 0.4 code generation
*/

class FilterApp : public KMainWindow
{
	Q_OBJECT
		
		friend class FilterView;
	
public:
/** construtor of FilterApp, calls all init functions to create the application.
* @see initMenuBar initToolBar
	*/
	FilterApp();
	~FilterApp();
	/** enables menuentries/toolbar items
	*/
	void EnableCommand(int id_);
	/** disables menuentries/toolbar items
	*/
	void DisableCommand(int id_);
	/** add a opened file to the recent file list and update recent_file_menu
	*/
	void addRecentFile(const QString &file);
	/** opens a file specified by commandline option
	*/
	void openDocumentFile(const char *_cmdl);
	/** returns a pointer to the current document connected to the KTMainWindow instance and is used by
	* the View class to access the document object's methods
	*/	
	FilterDoc *getDocument() const; 	
	
protected:
/** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
* file
	*/ 	
	void SaveOptions();
	/** read general Options again and initialize all variables like the recent file list
	*/
	void ReadOptions();
	/** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
	* @see KAccel
	*/
	void InitializeAccelerators();
	/** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
	* @see KApplication#getHelpMenu
	*/
	void InitializeMenuBar();
	/** this creates the toolbars.
	*/
	void InitializeToolBar();
	/** sets up the statusbar for the main window by initialzing a statuslabel.
	*/
	void InitializeStatusBar();
	/** initializes the document object of the main window that is connected to the view in initView().
	* @see initView();
	*/
	void InitializeDocument();
	/** creates the centerwidget of the KTMainWindow instance and sets it as the view
	*/
	void InitializeView();
	/** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
	* default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
	* be saved if Modified; on cancel the closeEvent is rejected.
	* @see KTMainWindow#queryClose
	* @see KTMainWindow#closeEvent
	*/
	virtual bool queryClose();
	/** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
	* Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
	* properties.
	* @see KTMainWindow#queryExit
	* @see KTMainWindow#closeEvent
	*/
	virtual bool queryExit();
	/** saves the window properties for each open window during session end to the session config file, including saving the currently
	* opened file by a temporary filename provided by KApplication.
	* @see KTMainWindow#saveProperties
	*/
	virtual void saveProperties( KConfig* a_pkconfigConfiguration );
	/** reads the session config file and restores the application's state including the last opened files and documents by reading the
	* temporary files saved by saveProperties()
	* @see KTMainWindow#readProperties
	*/
	virtual void readProperties(KConfig* a_pkconfigConfiguration );
	
public slots:
	void slotrefreshview();
	/** switch argument for slot selection by menu or toolbar ID */
	void commandCallback( int a_intFileIndex );
	/** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries. */
	void statusCallback( int a_intFileIndex );
	/** open a new application window by creating a new instance of FilterApp */
	void slotFileNewWindow();
	/** clears the document in the actual view to reuse it as the new document */
	void slotFileNew();
	/** open a file and load it into the document*/
	void slotFileOpen();
	/** opens a file from the recent files menu */
	void slotFileOpenRecent( int a_intFileIndex );
	/** save a document */
	void slotFileSave();
	/** save a document by a new filename*/
	void slotFileSaveAs();
	/** asks for saving if the file is modified, then closes the actual file and window*/
	void slotFileClose();
	/** print the actual file */
	void slotFilePrint();
	/** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
	* If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
	*/
	void slotFileQuit();
	/** put the marked text/object into the clipboard and remove
	*	it from the document
	*/
	void slotEditCut();
	/** put the marked text/object into the clipboard
	*/
	void slotEditCopy();
	/** paste the clipboard into the document
	*/
	void slotEditPaste();
	/** toggles the toolbar
	*/
	void slotViewToolBar();
	/** toggles the statusbar
	*/
	void slotViewStatusBar();
	/** changes the statusbar contents for the standard label permanently, used to indicate current actions.
	* @param text the text that is displayed in the statusbar
	*/
	void slotDriverParam();
	/*initialisation of the driver parameters dialog*/
	
	void slotDriverNetwork();
	
	void slotDriverVolume();
	
	void slotToolsWizard();
	
	void slotOptionsColors();
	
	void slotStatusMsg(const QString &text);
	/** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
	* statusbar messages that give information about actions for toolbar icons and menuentries.
	* @param text the text that is displayed in the statusbar
	*/
	void slotStatusHelpMsg(const QString &text);
	
private:
	/** contains the recently used filenames */
	QStrList m_qstrlistRecentFiles;
	
	/** the configuration object of the application */
	KConfig* m_pkconfigConfiguration;
	/** the key accelerator container */
	KAccel* m_pkaccelAccelerators;
	/** file_menu contains all items of the menubar entry "File" */
	QPopupMenu* m_pqpopupmenuFileMenu;
	/** the recent file menu containing the last five opened files */
	QPopupMenu* m_pqpopupmenuRecentFilesMenu;
	/** edit_menu contains all items of the menubar entry "Edit" */
	QPopupMenu* m_pqpopupmenuEditMenu;
	/** view_menu contains all items of the menubar entry "View" */
	QPopupMenu* m_pqpopupmenuViewMenu;
	/** help_menu contains all items of the menubar entry "Help" */
	QPopupMenu* m_pqpopupmenuHelpMenu;
	/** view is the main widget which represents your working area. The View
	* class should handle all events of the view widget.  It is kept empty so
	* you can create your view according to your application's needs by
	* changing the view class.
	*/
	QPopupMenu* m_pqpopupmenuDriverMenu;
	QPopupMenu* m_pqpopupmenuToolsMenu;
	QPopupMenu* m_pqpopupmenuOptionsMenu;
	
	FilterView* m_pfilterviewFilterView;
	/** doc represents your actual document and is created only once. It keeps
	* information such as filename and does the serialization of your files.
	*/
	FilterDoc* m_pfilterdocFilterDocument;


	
};

#endif // FILTER_H
