/***************************************************************************
filterdoc.cpp  -  description
-------------------
begin                : Sun Mar 19 11:30:14 MET 2000
copyright            : (C) 2001 by Martin Erdtmann  /  Stefan Okrongli
email                : martin.erdtmann@gmx.de  /  s_okrongli@gmx.net
***************************************************************************/

/***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>
#include <qtextstream.h>

// include files for KDE
#include <kapp.h>
#include <klocale.h>
#include <kmessagebox.h>

// application specific includes
#include "resource.h"
#include "kfilterdoc.h"
#include "kfilter.h"
#include "kfilterview.h"
#include "math.h"
#include "driverinput.h"
#include "networkdialog.h"
#include "volumedialog.h"
#include "wizard.h"

#include <iostream.h>


QList<FilterView> *FilterDoc::m_pqlistViewList = 0L;

FilterDoc::FilterDoc( QWidget* a_pqwidgetParent, const char* a_pcharName )
	: QObject( a_pqwidgetParent, a_pcharName )
{
	if( !m_pqlistViewList )
	{
		m_pqlistViewList = new QList<FilterView>();
	}
	/*
	//////////////////////////////////////////////////TESTING TESTING !!!!!!
	activeparams = false;
	m_driverDriver[0].F0 = 100.0;
	m_driverDriver[1].F0 = 200.0;
	m_driverDriver[2].F0 = 400.0;
	m_driverDriver[3].F0 = 800.0;
	m_driverDriver[0].Qtc = 0.5;
	m_driverDriver[0].Qe = 0.6;
	m_driverDriver[0].Qms = 2.5;
	m_driverDriver[1].Qtc = 0.7;
	m_driverDriver[2].Qtc = 1.3;
	m_driverDriver[3].Qtc = 2.0;
	
	m_driverDriver[3].Qe = 2.1;
	m_driverDriver[3].Qms = 10.5;
	m_driverDriver[0].Rdc = 8.0;
	m_driverDriver[1].Rdc = 5.0;
	m_driverDriver[2].Rdc = 7.0;
	m_driverDriver[3].Rdc = 10.0;
	m_driverDriver[0].PressureisActive = true;
	//m_driverDriver[0].ScalarSummaryisActive = true;
	//m_driverDriver[0].SummaryisActive = true;
	//m_driverDriver[3].PressureisActive = true;
	//m_driverDriver[3].ScalarSummaryisActive = true;
	//m_driverDriver[3].SummaryisActive = true;
	m_driverDriver[0].ImpedanzisActive = true;
	//////////////////////////////////////////////////
	*/
}

FilterDoc::~FilterDoc()
{
}

void FilterDoc::addView( FilterView* a_pfilterviewView )
{
	m_pqlistViewList->append( a_pfilterviewView );
}

void FilterDoc::removeView(FilterView* a_pfilterviewView )
{
	m_pqlistViewList->remove( a_pfilterviewView );
}

void FilterDoc::setAbsFilePath( const QString& a_qstringFilename )
{
	m_qstringAbsoluteFilePath = a_qstringFilename;
}

const QString &FilterDoc::getAbsFilePath() const
{
	return m_qstringAbsoluteFilePath;
}

void FilterDoc::setTitle( const QString& a_qstringTitle )
{
	m_qstringTitle = a_qstringTitle;
}

const QString &FilterDoc::getTitle() const
{
	return m_qstringTitle;
}

void FilterDoc::slotUpdateAllViews( FilterView* a_pfilterviewSender )
{
	FilterView *pfilterviewView;
	if( m_pqlistViewList )
	{
		for( pfilterviewView = m_pqlistViewList->first(); pfilterviewView != 0; \
			pfilterviewView = m_pqlistViewList->next())
		{
			if( pfilterviewView != a_pfilterviewSender )
			{
				pfilterviewView->repaint();
			}
		}
	}
	
}

bool FilterDoc::saveModified()
{
	bool boolCompleted = true;
	
	if( m_boolModified )
	{
		FilterApp *pfilterappApplication = (FilterApp *) parent();
		int intWantSave = KMessageBox::warningYesNoCancel( pfilterappApplication, \
			i18n("The current file" \
			" has been modified.\nDo you want to save it?"), i18n("Save changes?"));
		switch( intWantSave )
		{
		case KMessageBox::Yes:
			if ( m_qstringTitle == i18n("Untitled") )
			{
				pfilterappApplication->slotFileSaveAs();
			}
			else
			{
				saveDocument( getAbsFilePath() );
			}
			
			deleteContents();
			boolCompleted = true;
			break;
			
		case KMessageBox::No:
			setModified( false );
			deleteContents();
			boolCompleted = true;
			break;	
			
		case KMessageBox::Cancel:
			boolCompleted = false;
			break;
			
		default:
			boolCompleted = false;
			break;
		}
	}
	
	return boolCompleted;
}

void FilterDoc::closeDocument()
{
	deleteContents();
}

bool FilterDoc::newDocument()
{
	m_boolModified = false;
	m_qstringAbsoluteFilePath = QDir::homeDirPath();
	m_qstringTitle = i18n("Untitled");
	deleteContents();
	forceviewrefresh();
	return true;
}

bool FilterDoc::openDocument( const QString& a_qstringFilename, const char* /*a_pcharFormat*/ )
{
	QFileInfo qfileinfoFileInfo( a_qstringFilename );
	m_qstringTitle = qfileinfoFileInfo.fileName();
	m_qstringAbsoluteFilePath = qfileinfoFileInfo.absFilePath();	
	
	QFile qfileFile( a_qstringFilename );
	if ( qfileFile.exists() )
	{
		qfileFile.open( IO_ReadOnly );
	}
	else
	{
		return 1;
	}
	QTextStream qtextstreamStream( &qfileFile );
	QString qstringLine;
	while ( !qtextstreamStream.eof() )	
	{
		qstringLine = qtextstreamStream.readLine();
		if ( qstringLine.find("#") != 0)
		{
			if ( qstringLine.contains ( "Network values", false ) != 0)
			{
				for ( int intI = 0; intI < 4 ; intI++ )
				{
					for (int intZ = 1; intZ < 49 ; intZ++ )
					{
						if ( !qtextstreamStream.eof() )
						{
							qstringLine = qtextstreamStream.readLine();
						}
						else 
						{
							truncatedFile( &qfileFile );
							return 1;
						}
						while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
						{
							qstringLine = qtextstreamStream.readLine();
						}
						if ( qstringLine.find("[") != 0)
						{
							m_driverDriver[ intI ].Bauteil[ intZ ] = atof( qstringLine.data() );
						}
						else 
						{
							intI = 4;
							intZ = 49;
						}
					}
				}
			}
			if ( qstringLine.contains ( "Driver Parameters", false ) != 0 )
			{
				for (int intI = 0; intI < 4; intI++ )
				{
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].Rdc = atof( qstringLine.data() );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].Lsp = atof( qstringLine.data() );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].F0  = atof( qstringLine.data() );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].Qtc = atof( qstringLine.data() );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].Qe  = atof( qstringLine.data() );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].Qms = atof( qstringLine.data() );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].Vas = atof( qstringLine.data() );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI].Dm  = atof( qstringLine.data() );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].Vb  = atof( qstringLine.data() );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].Fb  = atof( qstringLine.data() );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].V2  = atof( qstringLine.data() );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].GTypProposal  = atoi( qstringLine.data() );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].gain  = atof( qstringLine.data() );
					
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].PressureisActive  = ( atoi( qstringLine.data() ) == 1 );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].ImpedanzisActive  = ( atoi( qstringLine.data() ) == 1 );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].SummaryisActive  = ( atoi( qstringLine.data() ) == 1 );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].ScalarSummaryisActive  = ( atoi( qstringLine.data() ) == 1 );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].ImpedanzSummaryisActive  = ( atoi( qstringLine.data() ) == 1 );
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else 
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].InvertPhase  = ( atoi( qstringLine.data() ) == 1 );
					
					if ( !qtextstreamStream.eof() )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					else
					{
						truncatedFile( &qfileFile );
						return 1;
					}
					while ( ( qstringLine.find("#") == 0 ) && ( !qtextstreamStream.eof() ) )
					{
						qstringLine = qtextstreamStream.readLine();
					}
					qstringLine.remove( 0, qstringLine.find("=") + 1 );
					m_driverDriver[ intI ].SetTitle( qstringLine.data() );
				}
			}
		}
	}
	qfileFile.close();
	for( int intI = 0; intI < 3; intI++ )
	{ 
		m_driverDriver[ intI ].Berechneparameter();
		m_driverDriver[ intI ].setmodified();
	}
	forceviewrefresh();
	m_boolModified = false;
	return true;
}

bool FilterDoc::saveDocument( const QString& a_qstringFilename, const char* /*a_pcharFormat*/ )
{
	/////////////////////////////////////////////////
	// TODO: Add your document saving code here
	/////////////////////////////////////////////////
	char charBuffer[ 20 ];
	QFile qfileFile( a_qstringFilename );
	qfileFile.open( IO_ReadWrite );
	
	qfileFile.writeBlock( "# KFilter datafile", 18 );
	qfileFile.writeBlock( "\n[Network values]", 17 );
	
	for (int intI = 0; intI < 4; intI++ )
	{
		qfileFile.writeBlock( "\n# Driver ", 10 );
		sprintf( charBuffer, "%1.0d", intI + 1 );
		qfileFile.writeBlock( charBuffer, 1 );
		for (int intZ = 1; intZ < 49; intZ++ )
		{
			sprintf ( charBuffer, "\n%14.9f", m_driverDriver[ intI ].Bauteil[ intZ ] );
			qfileFile.writeBlock( charBuffer, 16 );
		}
	}
	qfileFile.writeBlock( "\n[Driver parameters]", 21 );
	for (int intI = 0; intI < 4; intI++ )
	{
		sprintf( charBuffer, "%1.0d", intI + 1 );
		qfileFile.writeBlock( "\n# Driver ", 10 );
		qfileFile.writeBlock( charBuffer, 1 );
		sprintf( charBuffer, "\nRdc=%10.6f", m_driverDriver[ intI ].Rdc );
		qfileFile.writeBlock( charBuffer, 14 );
		sprintf( charBuffer, "\nLsp=%10.6f", m_driverDriver[ intI ].Lsp );
		qfileFile.writeBlock( charBuffer, 14 );
		sprintf( charBuffer, "\nF0 =%10.6f", m_driverDriver[ intI ].F0 );
		qfileFile.writeBlock( charBuffer, 14 );
		sprintf( charBuffer, "\nQts=%10.6f", m_driverDriver[ intI ].Qtc );
		qfileFile.writeBlock( charBuffer, 14 );
		sprintf( charBuffer, "\nQe =%10.6f", m_driverDriver[ intI ].Qe );
		qfileFile.writeBlock( charBuffer, 14 );
		sprintf( charBuffer, "\nQms=%10.6f", m_driverDriver[ intI ].Qms );
		qfileFile.writeBlock( charBuffer, 14 );
		sprintf( charBuffer, "\nVas=%10.6f", m_driverDriver[ intI ].Vas );
		qfileFile.writeBlock( charBuffer, 14 );
		sprintf( charBuffer, "\nDm =%10.6f", m_driverDriver[ intI ].Dm );
		qfileFile.writeBlock( charBuffer, 14 );
		sprintf( charBuffer, "\nVb =%10.6f", m_driverDriver[ intI ].Vb );
		qfileFile.writeBlock( charBuffer, 14 );
		sprintf( charBuffer, "\nFb =%10.6f", m_driverDriver[ intI ].Fb );
		qfileFile.writeBlock( charBuffer, 14 );
		sprintf( charBuffer, "\nV2 =%10.6f", m_driverDriver[ intI ].V2 );
		qfileFile.writeBlock( charBuffer, 14 );
		sprintf( charBuffer, "\nGTypProposal =%3.0d", m_driverDriver[ intI ].GTypProposal );
		qfileFile.writeBlock( charBuffer, 18 );
		sprintf( charBuffer, "\nGain =%10.6f", m_driverDriver[ intI ].gain );
		qfileFile.writeBlock( charBuffer, 17 );
		
		if (m_driverDriver[ intI ].PressureisActive)
		{
			qfileFile.writeBlock( "\nPressure = 1", 14 );
		}
		else
		{
			qfileFile.writeBlock( "\nPressure = 0", 14 );
		}
		if (m_driverDriver[ intI ].ImpedanzisActive)
		{
			qfileFile.writeBlock( "\nImpedanz = 1", 14 );
		}
		else
		{
			qfileFile.writeBlock( "\nImpedanz = 0", 14 );
		}
		if (m_driverDriver[ intI ].SummaryisActive)
		{
			qfileFile.writeBlock( "\nSummary = 1", 13 );
		}
		else
		{
			qfileFile.writeBlock( "\nSummary = 0", 13 );
		}
		if (m_driverDriver[ intI ].ScalarSummaryisActive)
		{
			qfileFile.writeBlock( "\nScalarSummary = 1", 18 );
		}
		else
		{
			qfileFile.writeBlock( "\nScalarSummary = 0", 18 );
		}
		if (m_driverDriver[ intI ].ImpedanzSummaryisActive)
		{
			qfileFile.writeBlock( "\nImpedanzSummary = 1", 20 );
		}
		else
		{
			qfileFile.writeBlock( "\nImpedanzSummary = 0", 20 );
		}
		if (m_driverDriver[ intI ].InvertPhase)
		{
			qfileFile.writeBlock( "\nInvertPhase = 1", 16 );
		}
		else
		{
			qfileFile.writeBlock( "\nInvertPhase = 0", 16 );
		}
		qfileFile.writeBlock( "\nTitle = ", 9 );
		qfileFile.writeBlock( m_driverDriver[ intI ].GetTitle(), 40 );
	}
	
	qfileFile.close();
	
	m_boolModified = false;
	return true;
}

void FilterDoc::deleteContents()
{
	/////////////////////////////////////////////////

	// TODO: Add implementation to delete the document contents
	/////////////////////////////////////////////////
	for (int intI = 0; intI < 4; intI++ )
	{
		m_driverDriver[ intI ].initContents();
	}
	m_boolModified = false;
	
}

void FilterDoc::initParamDialog()
{
	FilterApp *pfilterappApplication = (FilterApp *) parent();
	pfilterappApplication->DisableCommand( ID_DRIVER_PARAM );
	
	driverinput* driverinputDialog = new driverinput( i18n("Driver Parameters"), \
		&m_driverDriver[0], &m_driverDriver[1], &m_driverDriver[2], &m_driverDriver[3]);
	driverinputDialog->show();
	QObject::connect( driverinputDialog, SIGNAL( paramchanged() ), this, SLOT( viewrefresh() ) );
	QObject::connect( driverinputDialog, SIGNAL( isclosed() ), this, SLOT( slot_EnableParamMenue() ) );
	QObject::connect( this, SIGNAL( refreshDialog() ), driverinputDialog, SLOT( slot_initnewvalues() ) );
}

void FilterDoc::initNetworkDialog()
{
	FilterApp *pfilterappApplication = (FilterApp *)parent();
	pfilterappApplication->DisableCommand( ID_DRIVER_NETWORK );
	
	NetworkDialog* pnetworkdialogDialog = new NetworkDialog( i18n("Frequency Range Network Parameters"),
		&m_driverDriver[0], &m_driverDriver[1], &m_driverDriver[2], &m_driverDriver[3] );
	pnetworkdialogDialog-> show();
	QObject::connect( pnetworkdialogDialog, SIGNAL( paramchanged() ), this, SLOT( viewrefresh() ) );
	QObject::connect( pnetworkdialogDialog, SIGNAL( isclosed() ), this, SLOT( slot_EnableNetworkMenue() ) );
	QObject::connect( this, SIGNAL(refreshDialog() ), pnetworkdialogDialog, SLOT( slot_initnewvalues() ) );
}

void FilterDoc::initVolumeDialog()
{
	FilterApp *pfilterappApplication= (FilterApp *)parent();
	pfilterappApplication->DisableCommand( ID_DRIVER_VOLUME );
	
	VolumeDialog* pvolumedialogDialog = new VolumeDialog( i18n("Box and Volume Parameters"),
		&m_driverDriver[0], &m_driverDriver[1], &m_driverDriver[2], &m_driverDriver[3] );
	pvolumedialogDialog-> show();
	QObject::connect( pvolumedialogDialog, SIGNAL( paramchanged() ), this, SLOT( viewrefresh() ) );
	QObject::connect( pvolumedialogDialog, SIGNAL( isclosed() ), this, SLOT( slot_EnableVolumeMenue() ) );
}

void FilterDoc::initToolsWizard()
{
	FilterApp *pfilterappApplication = (FilterApp *)parent();
	Wizard* pwizardDialog = new Wizard( pfilterappApplication, "Filter Wizard",
		&m_driverDriver[0], &m_driverDriver[1], &m_driverDriver[2], &m_driverDriver[3] );
	pwizardDialog->show();
	slotUpdateAllDialogs();
}

void FilterDoc::viewrefresh()
{
	emit forceviewrefresh();
}

bool FilterDoc::Sound( int a_intIndex )
{
	if (m_driverDriver[ a_intIndex ].PressureisActive )
	{
		m_driverDriver[ a_intIndex ].Schall();
		int intJ = 0;
		for (int intI = 0; intI < 300; intI = intI + 2 )
		{
			m_doubleXContainer[ a_intIndex ][ intJ ] = DB( sqrt( pow( \
				m_driverDriver[ a_intIndex ].ResultSchall[ intI ], 2.0 ) + \
				pow( m_driverDriver[ a_intIndex ].ResultSchall[ intI + 1 ], 2.0 ) ) );
			intJ++;
		}
	}                       
	return m_driverDriver[ a_intIndex ].PressureisActive;
}

bool FilterDoc::Impedance( int a_intIndex )
{
	if (m_driverDriver[ a_intIndex ].ImpedanzisActive)
	{
		m_driverDriver[ a_intIndex ].Impedanz();
		int intJ = 0;
		for (int intI = 0; intI < 300; intI = intI + 2 )
		{
			m_doubleXContainer[ a_intIndex ][ intJ ] = sqrt( pow( \
				m_driverDriver[ a_intIndex ].ResultImpedanz[ intI ], 2.0 ) + \
				pow( m_driverDriver[ a_intIndex ].ResultImpedanz[ intI + 1 ], 2.0 ) );
			intJ++;
		}
	}                     
	return m_driverDriver[ a_intIndex ].ImpedanzisActive;
}

bool FilterDoc::PressureSummary()
{
	/////////////////////////////init temp variable
	double doubleSum[ 300 ];
	for( int intZ = 0; intZ < 300; intZ++ )
	{
		doubleSum[ intZ ] = 0.0;
	}
	////////////////////////////// calculate vector summary for active drivers
	for( int intIndex = 0; intIndex < 4; intIndex++ )
	{
		if ( m_driverDriver[ intIndex ].SummaryisActive )
		{
			m_driverDriver[ intIndex ].Schall();
			for ( int intI = 0; intI < 300; intI++ )
			{
				doubleSum[ intI ] = doubleSum[ intI ] + \
					m_driverDriver[ intIndex ].ResultSchall[ intI ];
			}
		}
	}
	////////////////////////////// vector summary becomes real summary
	int intZ = 0;
	for (int intI = 0; intI < 300; intI = intI + 2 )
	{
		m_doubleXContainer[ 0 ][ intZ ] = DB( sqrt( pow( doubleSum[ intI ], 2.0 ) + \
			pow( doubleSum[ intI + 1 ], 2.0 ) ) );
		intZ++;
	}
	///////////////////////////////
	return ( m_driverDriver[ 0 ].SummaryisActive || m_driverDriver[ 1 ].SummaryisActive || \
		m_driverDriver[ 2 ].SummaryisActive || m_driverDriver[ 3 ].SummaryisActive);
}

bool FilterDoc::PressureScalarSummary()
{
	///////////////////init m_doubleXContainer
	for ( int intI = 0; intI < 150; intI++ )
	{
		m_doubleXContainer[ 0 ][ intI ] = 0;
	}
	
	for ( int intIndex = 0; intIndex < 4; intIndex++ )
	{
		if ( m_driverDriver[ intIndex ].ScalarSummaryisActive )
		{
			m_driverDriver[ intIndex ].Schall();
			int intJ = 0;
			for ( int intI = 0; intI < 300; intI = intI + 2 )
			{
				//		turbo pascal version				dB0-round(	ln(sqrt(sqr(qx1)+sqr(qy1)+sqr(qx2)+sqr(qy2)+sqr(qx3)+sqr(qy3))	)
				//  	old C version 				m_doubleXContainer[0][j] = m_doubleXContainer[0][j] + sqrt(pow(m_driverDriver[index].ResultSchall[i],2.0)+pow(m_driverDriver[index].ResultSchall[i+1],2.0));
				m_doubleXContainer[ 0 ][ intJ ] = \
					m_doubleXContainer[ 0 ][ intJ ] + pow( m_driverDriver[ intIndex ].ResultSchall[ intI ], 2.0) + \
					pow( m_driverDriver[ intIndex ].ResultSchall[ intI + 1 ], 2.0 );
				intJ++;
			}
		}
	}
	for (int intI = 0; intI < 150; intI++ )
	{
		m_doubleXContainer[ 0 ][ intI ] = DB( sqrt( m_doubleXContainer[ 0 ][ intI ] ) );
	}
	///////////////////////////////
	return ( m_driverDriver[ 0 ].ScalarSummaryisActive || m_driverDriver[ 1 ].ScalarSummaryisActive || \
		m_driverDriver[ 2 ].ScalarSummaryisActive || m_driverDriver[ 3 ].ScalarSummaryisActive );
}

bool FilterDoc::ImpedanceSummary()
{
	
	double doubleSum[ 300 ];
	for ( int intZ = 0; intZ < 300; intZ++ )
	{
		doubleSum[ intZ ] = 0;
	}
	////////////////////////////// calculate vector summary for active drivers
	for ( int intIndex = 0; intIndex < 4; intIndex++ )
	{
		if ( m_driverDriver[ intIndex ].ImpedanzSummaryisActive )
		{
			m_driverDriver[ intIndex ].Impedanz();
			m_driverDriver[ intIndex ].invertImpedanz();
			for ( int intI = 0; intI < 300; intI++ )
			{
				doubleSum[ intI ]= doubleSum[ intI ] + m_driverDriver[ intIndex ].ResultImpedanz[ intI ];
			}
			m_driverDriver[ intIndex ].invertImpedanz();
		}
	}
	////////////////////////////// vector summary becomes real summary
	int intZ = 0;
	for ( int intI = 0; intI < 300; intI = intI + 2 )
	{
		m_doubleXContainer[ 0 ][ intZ ] = 1.0 / ( sqrt( pow( doubleSum[ intI ], 2.0 ) +\
			pow( doubleSum[ intI + 1 ], 2.0 ) ) );
		intZ++;
	}
	///////////////////////////////
	return ( m_driverDriver[ 0 ].ImpedanzSummaryisActive || m_driverDriver[ 1 ].ImpedanzSummaryisActive || \
		m_driverDriver[ 2 ].ImpedanzSummaryisActive || m_driverDriver[ 3 ].ImpedanzSummaryisActive);
}

double FilterDoc::DB( double a_doubleA )
{
	return ( 8.685889638 * log( a_doubleA ) );
}

void FilterDoc::truncatedFile( QFile* a_pqfileFile)
{
	a_pqfileFile->close();
	for ( int intI = 0; intI < 3; intI++ )
	{ 
		m_driverDriver[ intI ].Berechneparameter();
		m_driverDriver[ intI ].setmodified();
	}
	forceviewrefresh();
	m_boolModified = false;
}

/** is called when open dialogs
need an update */
void FilterDoc::slotUpdateAllDialogs()
{
	emit refreshDialog();
	forceviewrefresh();
}
/**  */
void FilterDoc::slot_EnableParamMenue()
{
	FilterApp *pfilterappApplication = (FilterApp*)parent();
	pfilterappApplication->EnableCommand( ID_DRIVER_PARAM );
}

/**  */
void FilterDoc::slot_EnableNetworkMenue()
{
	FilterApp *pfilterappApplication = (FilterApp*)parent();
	pfilterappApplication->EnableCommand( ID_DRIVER_NETWORK );
}

void FilterDoc::slot_EnableVolumeMenue()
{
	FilterApp *pfilterappApplication = (FilterApp*)parent();
	pfilterappApplication->EnableCommand( ID_DRIVER_VOLUME );
}
