/***************************************************************************
                          imagemap.h  -  description
                             -------------------
    begin                : Wed Apr 4 2001
    copyright            : (C) 2001 by Jan Schfer
    email                : j_schaef@informatik.uni-kl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef IMAGEMAP_H
#define IMAGEMAP_H

#include <qscrollview.h>
#include <qimage.h>
#include <qpoint.h>
#include <qrect.h>

class KImageMapEditor;
class Area;

/**
	*@short Draws the image and areas and handle the draw actions
  *@author Jan Sch&auml;fer
  *@internal
  *@see Area
  */
class DrawZone : public QScrollView  {
public:
	
	DrawZone(QWidget *parent,KImageMapEditor* _imageMapEditor);
	~DrawZone();
	
	QImage picture() const;
	void repaintArea(const Area & a);
	
	void setPicture(const QImage &_image);
	void setZoom(double z);
	
	/**
	 *
	 */
	QPoint translateFromZoom(const QPoint & p) const;
	QPoint translateToZoom(const QPoint & p) const;
	QRect translateToZoom(const QRect & p) const;

protected:
	virtual void contentsMouseDoubleClickEvent(QMouseEvent* e);
	virtual void contentsMousePressEvent(QMouseEvent* e);
	virtual void contentsMouseReleaseEvent(QMouseEvent *e);
	virtual void contentsMouseMoveEvent(QMouseEvent *e);
	virtual void resizeEvent(QResizeEvent* e);
	virtual void drawContents(QPainter* p,int clipx,int clipy,int clipw,int cliph);
	virtual void viewportDropEvent( QDropEvent* e);
	/**
	 * Represents whats currently going on
	 * @li None : Nothing
	 * @li DrawCircle : The user is drawing a circle
	 * @li DrawRectangle : The user is drawing a rectangle
	 * @li MoveSelectionPoint : The user is resizing an @ref Area or moving a polygon point
	 * @li MoveArea : The user is moving an @ref Area
	 */
	enum DrawAction { None, DrawCircle, DrawRectangle, DrawPolygon, MoveSelectionPoint, MoveArea };

private:
	DrawAction currentAction;
	// The currently drawing area
	Area *currentArea;
	// Needed when moving selectionpoints
	QRect *currentSelectionPoint;
	// The point where the user clicked the mouse
	QPoint drawStart;
	// The original image
	QImage image;
	KImageMapEditor *imageMapEditor;
	// Only the rect of the zoomed image, perhaps redundant
	QRect imageRect;
	// Only for repaint issues
	Area *oldArea;
	// Holds the zoomed image for efficiency reasons
	QPixmap zoomedImage;
	// The current zoom-factor
	double _zoom;
};

inline QImage DrawZone::picture() const {
	return image;
}


#endif
