/***************************************************************************
                          kimedialogs.h  -  description
                             -------------------
    begin                : Tue Apr 17 2001
    copyright            : (C) 2001 by Jan Schfer
    email                : j_schaef@informatik.uni-kl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdialogbase.h>
#include <kurl.h>
#include "kimagemapeditor.h"

class QLineEdit;
class QMultiLineEdit;

class AreaDialog : public KDialogBase {
Q_OBJECT
	private:
		Area *area;
		Area *areaCopy;
		QLineEdit *hrefEdit;
		QLineEdit *altEdit;
		QMultiLineEdit *coordsEdit;
	public:
		AreaDialog(QWidget* parent,Area * a);
		~AreaDialog();
	protected slots:
		virtual void slotOk();
		virtual void slotApply();
		virtual void slotCancel();
		void slotChooseHref();
	signals:
		void areaChanged(Area* a);
};

class QLineEdit;
class QListBox;
class QLabel;
class QTable;


class ImageMapChooseDialog : public KDialogBase {
Q_OBJECT
	private:
		QTable *imageListTable;
		QLabel *imagePreview;		
		QListBox *mapListBox;	
		QLineEdit *mapNameEdit;
		QList<MapTag> *maps;
		QList<ImageTag> *images;
		KURL baseUrl;
	public:
		ImageMapChooseDialog(QWidget* parent,QList<MapTag> *_maps,QList<ImageTag> *_images, const KURL & _baseUrl);
		~ImageMapChooseDialog();
		KURL pixUrl;
		MapTag* currentMap;
	protected slots:
		void slotImageChanged();
		void slotMapChanged(int i);
};

class QSpinBox;

class PreferencesDialog : public KDialogBase {
Q_OBJECT
	public:
		PreferencesDialog(QWidget *parent);
		~PreferencesDialog();
	protected slots:
	  virtual void slotDefault( void );
  	virtual void slotOk( void );
  	virtual void slotApply( void );
	private:
		QSpinBox *rowHeightSpinBox;
};
