/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Die Apr 10 19:46:49 CEST 2001
    copyright            : (C) 2001 by Jan Schfer
    email                : j_schaef@informatik.uni-kl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kapp.h>
#include <dcopclient.h>

#include "kimagemapeditor.h"

static const char *description =
	I18N_NOOP("KImageMapEditor");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
	{ "c", 0, 0 },
	{ "stdout", I18N_NOOP("write HTML-Code to stdout on exit"), 0 },
	{ "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

  KAboutData aboutData( "kimagemapeditor", I18N_NOOP("KImageMapEditor"),
    VERSION, description, KAboutData::License_GPL,
    "(c) 2001, Jan Schfer", 0, 0, "j_schaef@informatik.uni-kl.de");
  aboutData.addAuthor("Jan Schfer",0, "j_schaef@informatik.uni-kl.de");

  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication a;
	a.dcopClient()->registerAs(a.name());

  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		
  KImageMapEditor *kimagemapeditor = new KImageMapEditor();
  a.setMainWidget(kimagemapeditor);
	kimagemapeditor->setStdout(args->isSet("stdout"));
	
	if (args->count()) {
			kimagemapeditor->slotOpenFile(args->url(0));
	}
  kimagemapeditor->show();
  return a.exec();
}
