/***************************************************************************
                          kbconfig.h  -  description
                             -------------------
    begin                : Sun Jul 8 2001
    copyright            : (C) 2001 by Leonid Zeitlin
    email                : lz@europe.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBCONFIG_H
#define KBCONFIG_H

#include "kbgroup.h"

#include <qobject.h>
#include <qvector.h>
#include <kconfig.h>

#define ICONS_SECTION "Icons"
#define OPTIONS_SECTION "Options"
#define TOGGLE_MODE_ENTRY "toggle_mode"

typedef QVector<KBGroup> KBGroupVector;

/**The class that stores configuration information of KBSwitch
  *@author Leonid Zeitlin
  */

class KBConfig : public QObject {
  Q_OBJECT
private:
  KBGroupVector m_groups;
  bool m_toggle_mode;
public: 
	KBConfig();
	~KBConfig();
	int groupCount() { return m_groups.count(); };
	KBGroup *getGroup(int groupno) { return m_groups[groupno]; };
	bool toggle_mode() {return m_toggle_mode; };
  /** No descriptions */
  void set_toggle_mode(bool value) {m_toggle_mode = value; };
  /** Load the KBSwitch configration from the application KConfig object */
  void load(KConfig *config);
  /** No descriptions */
  void notifyChanged();
  static QString entryForGroup(int i) {
    return QString("Group%1").arg(i+1);
  }
private: // Private methods
  /** No descriptions */
  void guessGroupPixmaps();
  /** No descriptions */
  void drawDefaultPixmaps();
  /** No descriptions */
  void loadConfiguredPixmaps(KConfig *config);
signals: // Signals
  /** No descriptions */
  void changed();
};

#endif
