/***************************************************************************
                          groupitem.cpp  -  description
                             -------------------
    begin                : Sat Dec 2 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "groupitem.h"
#include <kmessagebox.h>
#include "groupviewwidget.h"

#include <iostream.h>

GroupItem::GroupItem(GroupManager * gm, GroupViewWidget * gvw) {
	_groupViewWidget = gvw;	
	_parent = gvw -> ListView1;
	_topItem = new QListViewItem (parent());
	_groupManager = gm;
	connect(parent(), SIGNAL(clicked(QListViewItem *, const QPoint &, int )),SLOT(slotItemClicked(QListViewItem *, const QPoint &, int)));
	connect(groupManager(), SIGNAL(updateReady()), SLOT(slotUpdateReady()));
	connect(parent(),SIGNAL(rightButtonPressed(QListViewItem *, const QPoint &, int )),SLOT(slotPopup(QListViewItem *, const QPoint &, int)));
	connect(groupViewWidget(), SIGNAL(cleanup(FileGroupExt*)),SLOT(slotCleanup(FileGroupExt*)));
	connect(this, SIGNAL(setupFileList(FileGroupBase *)), groupViewWidget(), SLOT(slotSetupFileList(FileGroupBase *)));
	connect(this, SIGNAL(setProperties(FileGroupBase *)), groupViewWidget(), SLOT(slotSetProperties(FileGroupBase *)));
}

GroupItem::~GroupItem(){
	delete _topItem;
}

void GroupItem::deleteChilderen(){
	QListViewItem * i  = topItem() -> firstChild();
	while (i != 0){
		delete i;
		i  = topItem() -> firstChild();
	}
}

void GroupItem::groupToItem(FileGroupBase * g, QListViewItem * i){
	QString s;
	i -> setText(10, g -> name());
	i -> setText(0, QString(" ") + g -> name());
	s.setNum(g -> numFiles());
	i -> setText(2, s);
	s.setNum(float(g -> sizeGreen())/(1024 * 1024),'f',1);
	s += " M";
	i -> setText(3, s);
	s.setNum(float(g -> totalSize())/(1024 * 1024),'f',1);
	s += " M";
	i -> setText(4, s);

	if ( g -> totalSize() != 0){
		float p = float(g -> sizeGreen())/ g -> totalSize() * 100;
		int p2 = int(p);
		s.setNum(p2);
	}
	else
		s = "0";
	s += " %";
	i -> setText(5, s);
	s.setNum(g -> safetyLevel());
	i -> setText(6, s);
}

QString GroupItem::name(QListViewItem * i){
	QString s;
	if (i!= 0)
		s = i -> text(10);
	else
		s = "";
	return s;
}

QListViewItem * GroupItem::item(QListViewItem * parent, QString s){
	if (parent != 0){
		QListViewItem * next = parent -> firstChild();
		while (next != 0){
			item( next, s);
			next = next -> nextSibling();
			if ( name(next) == s)
				return next;
		}
	}
}

void GroupItem::deleteItem(QString s){
	delete item(topItem(), s);
}

bool GroupItem::hasAncestor(QListViewItem * i, QListViewItem * a){
	bool  b = false;
	while (i != 0){
		if (i == a){
			b = true;
			break;
		}
		i = i -> parent();
	}
	return b;
}

QListViewItem * GroupItem::itemHasChild(QListViewItem * i, QString s){
	QListViewItem * item = i -> firstChild(), * retitem = 0;
	while (item != 0){
		if (item -> text(0) == s){
			retitem = item;
			break;
		}
		else
			item = item -> nextSibling();
	}
	return retitem;
}

void GroupItem::slotCleanup(FileGroupExt * g){
	if (g){
		if (type() == g -> type()){
			if ( g -> numMarked() == 0)
				KMessageBox::information(0,i18n("No files have been marked. Mark one or more files"));
			if ( g -> numMarked()){
				cleanUpWizard = new CleanUpWizard(g);
				connect(cleanUpWizard, SIGNAL(ready()),SLOT(slotCleanupEnded()));
				cleanUpWizard -> show();
			}
		}
	}
	else
		KMessageBox::information(0,"No group is selected. First select a group");
}